/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.nutcluster;

import com.atlassian.bitbucket.dmz.cluster.ClusterNodeAttributes;
import com.atlassian.bitbucket.dmz.cluster.MirrorClusterNode;
import com.atlassian.bitbucket.dmz.mirror.ClusterCounter;
import com.atlassian.bitbucket.dmz.mirror.DmzEphemeralStateStore;
import com.atlassian.bitbucket.dmz.mirror.DmzMirrorFarm;
import com.atlassian.bitbucket.dmz.mirror.FarmQueue;
import com.atlassian.bitbucket.dmz.mirror.SynchronizationState;
import com.atlassian.event.api.EventListener;
import com.atlassian.johnson.event.AddEvent;
import com.atlassian.nutcluster.core.Cluster;
import com.atlassian.nutcluster.core.IMap;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.internal.serialization.InternalSerializationService;
import com.atlassian.nutcluster.internal.serialization.impl.ObjectDataInputStream;
import com.atlassian.nutcluster.internal.serialization.impl.ObjectDataOutputStream;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.spi.impl.SerializationServiceSupport;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.cluster.NutclusterClusterNode;
import com.atlassian.stash.internal.event.MirrorStateEventPublisher;
import com.atlassian.stash.internal.johnson.JohnsonUtils;
import com.atlassian.stash.internal.mode.MirrorApplicationMode;
import com.atlassian.stash.internal.nutcluster.DefaultFarmQueue;
import com.atlassian.stash.internal.nutcluster.DefaultMirrorClusterNode;
import com.atlassian.stash.internal.nutcluster.NutclusterCounter;
import com.atlassian.stash.internal.nutcluster.NutclusterEphemeralStateStore;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import com.google.common.base.Suppliers;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=DmzMirrorFarm.class)
@Component(value="mirrorFarm")
@MirrorApplicationMode
public class DefaultMirrorFarm
extends AbstractSmartLifecycle
implements DmzMirrorFarm,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultMirrorFarm.class);
    private final Cluster cluster;
    private final ClusterNodeAttributes clusterNodeAttributes;
    private final NutclusterEphemeralStateStore ephemeralStateStore;
    private final Supplier<MirrorClusterNode> localNodeSupplier;
    private final MirrorStateEventPublisher mirrorStateEventPublisher;
    private final NutclusterInstance nutcluster;
    private final Map<String, FarmQueue<?>> queues;
    private final DmzMirrorFarm.SerializationService serializationService;
    private final AtomicReference<SynchronizationState> synchronizationState;
    private Environment environment;

    @Autowired
    public DefaultMirrorFarm(NutclusterInstance nutcluster, MirrorStateEventPublisher mirrorStateEventPublisher, ClusterNodeAttributes clusterNodeAttributes) {
        this.nutcluster = nutcluster;
        this.mirrorStateEventPublisher = mirrorStateEventPublisher;
        this.clusterNodeAttributes = clusterNodeAttributes;
        this.cluster = nutcluster.getCluster();
        this.ephemeralStateStore = new NutclusterEphemeralStateStore((IMap<String, Object>)nutcluster.getMap("mirror.secrets.map"));
        this.queues = new ConcurrentHashMap();
        this.serializationService = new NutclusterSerializationService(nutcluster);
        this.localNodeSupplier = Suppliers.memoizeWithExpiration(() -> new DefaultMirrorClusterNode(this.cluster.getLocalMember(), clusterNodeAttributes), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        this.synchronizationState = new AtomicReference<SynchronizationState>(SynchronizationState.STARTING);
        clusterNodeAttributes.setAttribute("state", this.synchronizationState.get().name());
        this.mirrorStateEventPublisher.publish(SynchronizationState.STARTING);
    }

    public boolean compareAndSetSynchronizationState(@Nonnull SynchronizationState expectedState, @Nonnull SynchronizationState targetState) {
        Objects.requireNonNull(expectedState, "expectedState");
        Objects.requireNonNull(targetState, "targetState");
        if (this.synchronizationState.compareAndSet(expectedState, targetState)) {
            this.clusterNodeAttributes.setAttribute("state", targetState.name());
            this.mirrorStateEventPublisher.publish(targetState);
            log.info("Transitioned synchronizationState from {} to {}", (Object)expectedState, (Object)targetState);
            return true;
        }
        log.debug("Expected synchronizationState to be {} but was {}, ignoring transition to {}", new Object[]{expectedState, this.synchronizationState.get(), targetState});
        return false;
    }

    @Nonnull
    public ClusterCounter getCounter(@Nonnull String name) {
        return new NutclusterCounter(this.nutcluster.getAtomicLong(Objects.requireNonNull(name, "name")));
    }

    @Nonnull
    public DmzEphemeralStateStore getEphemeralStateStore() {
        return this.ephemeralStateStore;
    }

    @Nonnull
    public Supplier<MirrorClusterNode> getLocalNode() {
        return this.localNodeSupplier;
    }

    @Nonnull
    public Set<MirrorClusterNode> getNodes() {
        return this.cluster.getMembers().stream().map(member -> new DefaultMirrorClusterNode((Member)member, this.clusterNodeAttributes)).collect(Collectors.toSet());
    }

    public int getPhase() {
        return 1525;
    }

    @Nonnull
    public <T extends Serializable> FarmQueue<T> getQueue(@Nonnull String name, @Nonnull Class<T> requiredType) {
        this.queues.putIfAbsent(name, new DefaultFarmQueue<T>(this.nutcluster.getQueue(name), requiredType));
        FarmQueue<?> farmQueue = this.queues.get(name);
        if (!farmQueue.getElementType().getName().equals(requiredType.getName())) {
            throw new IllegalArgumentException(String.format("Requested queue '%s' with element type '%s' but is has already been handed out with element type '%s'", name, requiredType.getName(), farmQueue.getElementType().getName()));
        }
        return farmQueue;
    }

    @Nonnull
    public DmzMirrorFarm.SerializationService getSerializationService() {
        return this.serializationService;
    }

    @Nonnull
    public SynchronizationState getSynchronizationState() {
        return this.synchronizationState.get();
    }

    public boolean isBootstrapped() {
        return this.synchronizationState.get().isBootstrapped();
    }

    public boolean isReadyForHosting() {
        if (this.synchronizationState.get().equals((Object)SynchronizationState.SYNCHRONIZED)) {
            return true;
        }
        if (this.environment != null && ((Boolean)this.environment.getProperty("plugin.mirroring.strict.hosting.status", Boolean.class, (Object)Boolean.FALSE)).booleanValue()) {
            return false;
        }
        if (this.cluster.getMembers().size() == 1) {
            return true;
        }
        return this.cluster.getMembers().stream().map(member -> this.clusterNodeAttributes.getAttribute(NutclusterClusterNode.transform(member), "state")).filter(Objects::nonNull).noneMatch(memberSyncState -> SynchronizationState.valueOf((String)memberSyncState) == SynchronizationState.SYNCHRONIZED);
    }

    @EventListener
    public void onJohnson(AddEvent johnsonEvent) {
        if (JohnsonUtils.isLevelAtLeast((String)johnsonEvent.getEvent().getLevel().getLevel(), (String)"error")) {
            this.compareAndSetSynchronizationState(SynchronizationState.BOOTSTRAPPING, SynchronizationState.ERROR);
        }
    }

    public void setEnvironment(@Nonnull Environment environment) {
        this.environment = Objects.requireNonNull(environment, "environment");
    }

    public void start() {
        super.start();
        this.compareAndSetSynchronizationState(SynchronizationState.STARTING, SynchronizationState.BOOTSTRAPPING);
        this.compareAndSetSynchronizationState(SynchronizationState.BOOTSTRAPPING, SynchronizationState.BOOTSTRAPPED);
    }

    private static class NutclusterSerializationService
    implements DmzMirrorFarm.SerializationService {
        private final InternalSerializationService serializationService;

        NutclusterSerializationService(NutclusterInstance nutcluster) {
            this.serializationService = (InternalSerializationService)((SerializationServiceSupport)nutcluster).getSerializationService();
        }

        @Nullable
        public Object readObject(@Nonnull InputStream data) {
            Objects.requireNonNull(data, "data");
            return this.serializationService.readObject((ObjectDataInput)new ObjectDataInputStream(data, this.serializationService));
        }

        public void writeObject(@Nonnull OutputStream outputStream, Object object) {
            Objects.requireNonNull(outputStream, "outputStream");
            this.serializationService.writeObject((ObjectDataOutput)new ObjectDataOutputStream(outputStream, this.serializationService), object);
        }
    }
}

