/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.nutcluster;

import com.atlassian.bitbucket.dmz.mirror.DmzMirrorLockHarvester;
import com.atlassian.nutcluster.concurrent.lock.LockResource;
import com.atlassian.nutcluster.concurrent.lock.LockService;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.internal.serialization.InternalSerializationService;
import com.atlassian.nutcluster.map.impl.proxy.MapProxyImpl;
import com.atlassian.nutcluster.spi.impl.SerializationServiceSupport;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.mode.MirrorApplicationMode;
import com.atlassian.stash.internal.nutcluster.DefaultMirrorFarm;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=DmzMirrorLockHarvester.class)
@Component(value="mirrorLockHarvester")
@MirrorApplicationMode
public class DefaultMirrorLockHarvester
implements DmzMirrorLockHarvester {
    private static final Logger log = LoggerFactory.getLogger(DefaultMirrorFarm.class);
    private final MapProxyImpl<String, String> lockMap;
    private final LockService lockService;
    private final NutclusterInstance nutcluster;
    private final InternalSerializationService serializationService;

    @Autowired
    public DefaultMirrorLockHarvester(NutclusterInstance nutcluster) {
        this.nutcluster = nutcluster;
        this.lockMap = (MapProxyImpl)nutcluster.getMap("atlassian.beehive.locks");
        this.lockService = (LockService)this.lockMap.getNodeEngine().getService("hz:impl:lockService");
        this.serializationService = (InternalSerializationService)((SerializationServiceSupport)nutcluster).getSerializationService();
    }

    public void forceUnlock(@Nonnull String key) {
        Objects.requireNonNull(key, "key");
        this.lockMap.forceUnlock((Object)key);
    }

    @Nonnull
    public String getLocalMemberUuid() {
        return this.nutcluster.getLocalEndpoint().getUuid();
    }

    @Nonnull
    public HashSet<String> getLocksForMember(@Nonnull String memberUuid) {
        Objects.requireNonNull(memberUuid, "memberUuid");
        Collection allLocks = this.lockService.getAllLocks();
        return (HashSet)allLocks.stream().filter(Objects::nonNull).filter(this.isOwnerPredicate(memberUuid)).peek(l -> log.trace("Locally held lock {}", l)).map(this::extractKey).collect(Collectors.toSet());
    }

    private String extractKey(LockResource lockResource) {
        return (String)this.serializationService.toObject((Object)lockResource.getKey());
    }

    private Predicate<LockResource> isOwnerPredicate(String localMemberUuid) {
        return lockResource -> Objects.equals(lockResource.getOwner(), localMemberUuid);
    }
}

