/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.nutcluster;

import com.atlassian.bitbucket.dmz.mirror.DmzMirrorSetupHelper;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.mode.MirrorApplicationMode;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=DmzMirrorSetupHelper.class)
@Component(value="mirrorSetupHelper")
@MirrorApplicationMode
public class DefaultMirrorSetupHelper
implements DmzMirrorSetupHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultMirrorSetupHelper.class);
    private final InternalApplicationPropertiesService propertiesService;
    private final SecurityService securityService;

    @Autowired
    public DefaultMirrorSetupHelper(SecurityService securityService, InternalApplicationPropertiesService propertiesService) {
        this.securityService = securityService;
        this.propertiesService = propertiesService;
    }

    public void markAlreadySetup() {
        log.debug("Setting farm to be already setup");
        this.securityService.withPermission(Permission.SYS_ADMIN, "mirror farm bootstrap process").call(() -> {
            this.propertiesService.setSetup(true);
            return null;
        });
    }

    public void setServerId(@Nonnull String serverId) {
        Objects.requireNonNull(serverId, "serverId");
        log.debug("Setting server id to [{}]", (Object)serverId);
        this.securityService.withPermission(Permission.SYS_ADMIN, "mirror farm bootstrap process").call(() -> {
            this.propertiesService.setServerId(serverId);
            return null;
        });
    }
}

