/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.nutcluster;

import com.atlassian.bitbucket.dmz.mirror.DmzEphemeralStateStore;
import com.atlassian.bitbucket.dmz.mirror.DmzMirrorFarm;
import com.atlassian.bitbucket.dmz.mirror.DmzSecretService;
import com.atlassian.nutcluster.serialization.OsgiSafe;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.mirror.FarmCryptoService;
import com.atlassian.stash.internal.mode.MirrorApplicationMode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Null;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=DmzSecretService.class)
@Component(value="mirrorSecretService")
@MirrorApplicationMode
public class DefaultSecretService
implements DmzSecretService,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultSecretService.class);
    private final DmzEphemeralStateStore ephemeralStateStore;
    private final FarmCryptoService farmCryptoService;
    private final DmzMirrorFarm.SerializationService serializationService;
    private final Map<String, String> subscriptions;

    @Autowired
    public DefaultSecretService(FarmCryptoService farmCryptoService, DmzMirrorFarm mirrorFarm) {
        this.farmCryptoService = farmCryptoService;
        this.ephemeralStateStore = mirrorFarm.getEphemeralStateStore();
        this.subscriptions = new HashMap<String, String>();
        this.serializationService = mirrorFarm.getSerializationService();
    }

    public <T> T compute(@Nonnull String key, @Nonnull UnaryOperator<T> mappingFunction) {
        return this.decrypt((byte[])this.ephemeralStateStore.compute(key, value -> {
            Object newValue;
            Object currentValue = this.decrypt((byte[])value);
            if (!Objects.equals(currentValue, newValue = mappingFunction.apply(currentValue))) {
                log.debug("Computed new secret for [{}]", (Object)key);
                return this.encrypt(newValue);
            }
            return value;
        }));
    }

    public <T> T computeIfAbsent(@Nonnull String key, @Nonnull Supplier<T> ifAbsent) {
        return this.decrypt((byte[])this.ephemeralStateStore.computeIfAbsent(key, () -> {
            byte[] encrypted = this.encrypt(ifAbsent.get());
            log.debug("Computed absent secret for [{}]", (Object)key);
            return encrypted;
        }));
    }

    public void destroy() {
        this.subscriptions.forEach((subscriptionId, secretKey) -> {
            log.debug("Unsubscribing subscription id {} for key {}", subscriptionId, secretKey);
            this.ephemeralStateStore.unregisterChangeListener(subscriptionId);
        });
        this.subscriptions.clear();
    }

    @Nonnull
    public <T> Optional<T> get(@Nonnull String key) {
        Objects.requireNonNull(key, "key");
        log.debug("Getting [{}]", (Object)key);
        Optional<Object> secret = this.ephemeralStateStore.get(key).map(this::decrypt);
        secret.ifPresent(v -> log.debug("Found secret for [{}]", (Object)key));
        return secret;
    }

    public void put(@Nonnull String key, @Null Object value) {
        Objects.requireNonNull(key, "key");
        log.debug("Putting [{}]", (Object)key);
        byte[] encryptedBytes = this.encrypt(value);
        this.ephemeralStateStore.put(key, (Object)encryptedBytes);
    }

    @Nonnull
    public <T> String registerChangeListener(@Nonnull String key, @Nonnull Consumer<T> changeListener) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(changeListener, "changeListener");
        String subscriptionId = this.ephemeralStateStore.registerChangeListener(key, value -> {
            Object decrypted;
            try {
                decrypted = this.decrypt((byte[])value);
            }
            catch (IllegalStateException e) {
                log.warn("Failed to decrypt value for key [{}]", (Object)key, (Object)(log.isDebugEnabled() ? e : null));
                return;
            }
            changeListener.accept(decrypted);
        });
        this.subscriptions.put(subscriptionId, key);
        return subscriptionId;
    }

    public boolean unregisterChangeListener(@Nonnull String subscriptionId) {
        Objects.requireNonNull(subscriptionId, "subscriptionId");
        boolean removed = this.ephemeralStateStore.unregisterChangeListener(subscriptionId);
        if (removed) {
            this.subscriptions.remove(subscriptionId);
        }
        return removed;
    }

    @Nullable
    private <T> T decrypt(@Nullable byte[] val) {
        if (val == null) {
            return null;
        }
        byte[] decryptedVal = this.farmCryptoService.decrypt(new ByteArrayInputStream(val));
        OsgiSafe osgiSafeSecret = (OsgiSafe)this.serializationService.readObject((InputStream)new ByteArrayInputStream(decryptedVal));
        if (osgiSafeSecret != null) {
            return (T)osgiSafeSecret.getValue();
        }
        throw new IllegalStateException("Failed to read the secret from the cluster");
    }

    @Nullable
    private byte[] encrypt(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
        this.serializationService.writeObject((OutputStream)outputStream, (Object)new OsgiSafe(value));
        return this.farmCryptoService.encrypt(new ByteArrayInputStream(outputStream.toByteArray()));
    }
}

