/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.nutcluster;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.event.cluster.ClusterNodeRejoinedEvent;
import com.atlassian.bitbucket.event.cluster.ClusterNodeRemovedEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.MemberAttributeEvent;
import com.atlassian.nutcluster.core.MembershipEvent;
import com.atlassian.nutcluster.core.MembershipListener;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.stash.internal.cluster.NutclusterClusterNode;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NutclusterClusterListener {
    private static final Logger log = LoggerFactory.getLogger(NutclusterClusterListener.class);
    private final EventPublisher eventPublisher;
    private final NutclusterInstance nutcluster;
    private volatile String listenerId;

    @Autowired
    public NutclusterClusterListener(EventPublisher eventPublisher, NutclusterInstance nutcluster) {
        this.eventPublisher = eventPublisher;
        this.nutcluster = nutcluster;
    }

    @PostConstruct
    public void register() {
        this.listenerId = this.nutcluster.getCluster().addMembershipListener(new MembershipListener(){
            private final ConcurrentMap<String, Long> lastModifiedByMember = new ConcurrentHashMap<String, Long>();

            public void memberAdded(MembershipEvent membershipEvent) {
                long now = System.currentTimeMillis();
                Member member = membershipEvent.getMember();
                String nodeId = member.getStringAttribute("node.vm.id");
                Long lastChange = null;
                if (nodeId != null) {
                    lastChange = this.lastModifiedByMember.put(nodeId, now);
                } else {
                    log.warn("No '{}' attribute available for new member {}", (Object)"node.vm.id", (Object)member.getSocketAddress());
                }
                if (lastChange == null) {
                    NutclusterClusterListener.this.eventPublisher.publish((Object)new ClusterNodeAddedEvent((Object)NutclusterClusterListener.this, (ClusterNode)new NutclusterClusterNode(member), NutclusterClusterNode.transform(membershipEvent.getMembers())));
                } else {
                    NutclusterClusterListener.this.eventPublisher.publish((Object)new ClusterNodeRejoinedEvent((Object)NutclusterClusterListener.this, (ClusterNode)new NutclusterClusterNode(member), NutclusterClusterNode.transform(membershipEvent.getMembers()), lastChange.longValue(), now));
                }
            }

            public void memberRemoved(MembershipEvent membershipEvent) {
                Member member = membershipEvent.getMember();
                NutclusterClusterListener.this.eventPublisher.publish((Object)new ClusterNodeRemovedEvent((Object)NutclusterClusterListener.this, (ClusterNode)new NutclusterClusterNode(member), NutclusterClusterNode.transform(membershipEvent.getMembers())));
                String nodeId = member.getStringAttribute("node.vm.id");
                if (nodeId != null) {
                    this.lastModifiedByMember.put(nodeId, System.currentTimeMillis());
                }
            }

            public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            }
        });
    }

    @PreDestroy
    public boolean unregister() {
        String id = this.listenerId;
        return id != null && this.nutcluster.getCluster().removeMembershipListener(id);
    }
}

