/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.nutcluster;

import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.nutcluster.aws.AwsDiscoveryStrategyFactory;
import com.atlassian.nutcluster.aws.AwsProperties;
import com.atlassian.nutcluster.azure.AzureDiscoveryStrategyFactory;
import com.atlassian.nutcluster.azure.AzureProperties;
import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.DiscoveryStrategyConfig;
import com.atlassian.nutcluster.config.EvictionPolicy;
import com.atlassian.nutcluster.config.ExecutorConfig;
import com.atlassian.nutcluster.config.GroupConfig;
import com.atlassian.nutcluster.config.InMemoryFormat;
import com.atlassian.nutcluster.config.JoinConfig;
import com.atlassian.nutcluster.config.MapConfig;
import com.atlassian.nutcluster.config.MapIndexConfig;
import com.atlassian.nutcluster.config.MaxSizeConfig;
import com.atlassian.nutcluster.config.MemberAttributeConfig;
import com.atlassian.nutcluster.config.MergePolicyConfig;
import com.atlassian.nutcluster.config.MulticastConfig;
import com.atlassian.nutcluster.config.NearCacheConfig;
import com.atlassian.nutcluster.config.NetworkConfig;
import com.atlassian.nutcluster.config.QueueConfig;
import com.atlassian.nutcluster.config.SerializationConfig;
import com.atlassian.nutcluster.config.SerializerConfig;
import com.atlassian.nutcluster.config.SocketInterceptorConfig;
import com.atlassian.nutcluster.config.TcpIpConfig;
import com.atlassian.nutcluster.core.ManagedContext;
import com.atlassian.nutcluster.kubernetes.NutclusterKubernetesDiscoveryStrategyFactory;
import com.atlassian.nutcluster.map.merge.LatestUpdateMapMergePolicy;
import com.atlassian.nutcluster.nio.serialization.Serializer;
import com.atlassian.nutcluster.serialization.OsgiClassLoaderRegistrySynchronizer;
import com.atlassian.nutcluster.serialization.OsgiSafe;
import com.atlassian.nutcluster.serialization.OsgiSafeStreamSerializer;
import com.atlassian.nutcluster.spi.discovery.DiscoveryStrategyFactory;
import com.atlassian.nutcluster.spi.properties.GroupProperty;
import com.atlassian.nutcluster.spring.context.SpringManagedContext;
import com.atlassian.stash.internal.BuildInfo;
import com.atlassian.stash.internal.cluster.ClusterJoinManager;
import com.atlassian.stash.internal.cluster.ClusterNodeNameResolver;
import com.atlassian.stash.internal.hibernate.EntityCache;
import com.atlassian.stash.internal.license.LicenseHelper;
import com.atlassian.stash.internal.license.SimpleDualLicense;
import com.atlassian.stash.internal.mesh.ControlPlaneStateMergePolicy;
import com.atlassian.stash.internal.nutcluster.ClusterJoinSocketInterceptor;
import com.atlassian.stash.internal.nutcluster.LicenseStreamSerializer;
import com.atlassian.stash.internal.nutcluster.OptionStreamSerializer;
import com.atlassian.stash.internal.nutcluster.OptionalStreamSerializer;
import com.atlassian.stash.internal.utils.ExpressionUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;

public class NutclusterConfigFactoryBean
implements FactoryBean<Config>,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(NutclusterConfigFactoryBean.class);
    private final BuildInfo buildInfo;
    private final ClusterJoinManager joinManager;
    private final LicenseHelper licenseHelper;
    private final OsgiSafeStreamSerializer osgiSafeStreamSerializer;
    private ApplicationContext applicationContext;
    @Value(value="${hibernate.cache.instance.name}")
    private String cacheInstanceName;
    private Environment environment;
    @Value(value="${hazelcast.group.name}")
    private String groupName;
    @Value(value="${hazelcast.group.password}")
    private String groupPassword;
    @Value(value="${hazelcast.jmx.detailed}")
    private boolean jmxDetailed;
    @Value(value="${jmx.enabled}")
    private boolean jmxEnabled;
    @Value(value="${hazelcast.network.aws}")
    private boolean networkAwsEnabled;
    @Value(value="${hazelcast.network.azure}")
    private boolean networkAzureEnabled;
    @Value(value="${hazelcast.network.kubernetes}")
    private boolean networkKubernetesEnabled;
    @Value(value="${hazelcast.network.multicast}")
    private boolean networkMulticastEnabled;
    @Value(value="${hazelcast.port}")
    private int networkPort;
    @Value(value="${hazelcast.network.tcpip}")
    private boolean networkTcpIpEnabled;
    @Value(value="${hazelcast.local.public.address}")
    private String publicAddress;
    @Value(value="${server.session.timeout}")
    private int serverSessionTimeout;
    @Value(value="${hazelcast.statistics.enabled}")
    private boolean statisticsEnabled;

    public NutclusterConfigFactoryBean(BuildInfo buildInfo, ClusterJoinManager joinManager, LicenseHelper licenseHelper, OsgiSafeStreamSerializer osgiSafeStreamSerializer) {
        this.buildInfo = buildInfo;
        this.joinManager = joinManager;
        this.licenseHelper = licenseHelper;
        this.osgiSafeStreamSerializer = osgiSafeStreamSerializer;
    }

    public Config getObject() {
        SpringManagedContext managedContext = new SpringManagedContext();
        managedContext.setApplicationContext(this.applicationContext);
        Config config = new Config(this.cacheInstanceName);
        config.setLiteMember(true);
        config.setProperty(GroupProperty.SEARCH_DYNAMIC_CONFIG_FIRST.getName(), Boolean.TRUE.toString());
        config.setManagedContext((ManagedContext)managedContext);
        config.setClassLoader(this.getClass().getClassLoader());
        this.configureAttributes(config);
        this.configureGroup(config);
        this.configureJmx(config);
        this.configureEnterprise(config);
        this.configureNetwork(config);
        this.configureSerialization(config.getSerializationConfig());
        this.configureCaches(config);
        this.configureExecutors(config);
        this.configureMaps(config);
        this.configureScheduler(config);
        this.configureQueues(config);
        return config;
    }

    public Class<?> getObjectType() {
        return Config.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.environment = applicationContext.getEnvironment();
    }

    private MapConfig boundedCache(EntityCache cache) {
        return this.boundedCache(cache.getName(), cache.isNearCacheable());
    }

    private MapConfig boundedCache(String name, boolean nearCache) {
        int timeToIdleSeconds = this.getInt("cache." + name + ".tti", 0);
        int timeToLiveSeconds = this.getInt("cache." + name + ".ttl", 0);
        return this.boundedCache(name, this.getMaxOrFail("cache." + name + ".max"), timeToLiveSeconds, timeToIdleSeconds, nearCache);
    }

    private MapConfig boundedCache(String name, int size, int timeToLive, int timeToIdle, boolean nearCache) {
        size = this.normalizeSize(size);
        MapConfig config = new MapConfig(name).setBackupCount(0).setEvictionPolicy(EvictionPolicy.LFU).setMaxIdleSeconds(Math.max(0, timeToIdle)).setMaxSizeConfig(new MaxSizeConfig(size, MaxSizeConfig.MaxSizePolicy.PER_NODE)).setStatisticsEnabled(this.statisticsEnabled).setTimeToLiveSeconds(Math.max(0, timeToLive));
        if (nearCache) {
            config.setNearCacheConfig(this.defaultNearCacheConfig().setEvictionPolicy(EvictionPolicy.LFU.name()).setMaxSize(size).setMaxIdleSeconds(Math.max(0, timeToIdle))).setTimeToLiveSeconds(Math.max(0, timeToLive));
        }
        return config;
    }

    private void configureAttributes(Config config) {
        MemberAttributeConfig attributeConfig = new MemberAttributeConfig();
        attributeConfig.setStringAttribute("node.build.version", this.buildInfo.getBuildVersion());
        attributeConfig.setStringAttribute("node.vm.id", UUID.randomUUID().toString());
        attributeConfig.setStringAttribute("node.name", ClusterNodeNameResolver.getNodeName());
        String availabilityZone = this.environment.getProperty("node.availability-zone");
        if (availabilityZone != null) {
            attributeConfig.setStringAttribute("hazelcast.partition.group.zone", availabilityZone);
        }
        config.setMemberAttributeConfig(attributeConfig);
    }

    private void configureCaches(Config config) {
        OsgiClassLoaderRegistrySynchronizer.configure((Config)config);
        config.addMapConfig(new MapConfig("default-update-timestamps-region").setBackupCount(0).setMergePolicy(LatestUpdateMapMergePolicy.class.getName()).setNearCacheConfig(this.defaultNearCacheConfig()).setStatisticsEnabled(this.statisticsEnabled));
        config.addMapConfig(this.boundedCache("query.*", false));
        config.addMapConfig(this.boundedCache("default-query-results-region", true));
        Stream.of(EntityCache.values()).forEach(cache -> config.addMapConfig(this.boundedCache((EntityCache)cache)));
        config.addMapConfig(new MapConfig("atlassian-cache.*").setBackupCount(0).setNearCacheConfig(this.defaultNearCacheConfig()).setStatisticsEnabled(this.statisticsEnabled));
        config.addMapConfig(this.boundedCache("atlassian-cache.Cache." + ApplicationPropertiesService.class.getName(), 0, 0, 0, true));
        config.addMapConfig(this.boundedCache("atlassian-cache.CacheReference." + LicenseService.class.getName() + ".BitbucketServerLicense", 0, 0, 0, true));
    }

    private void configureEnterprise(Config config) {
        String license = this.environment.getProperty("hazelcast.enterprise.license");
        if (StringUtils.isNotBlank((CharSequence)license)) {
            config.setLicenseKey(license);
        }
    }

    private void configureExecutors(Config config) {
        int poolSize = ExpressionUtils.parseExpressionAsInt((String)this.environment.getProperty("hazelcast.executor.max.threads")).orElse(16);
        int queueCapacity = ExpressionUtils.parseExpressionAsInt((String)this.environment.getProperty("hazelcast.executor.queue.size")).orElse(0);
        ExecutorConfig executorConfig = new ExecutorConfig("bitbucket.core", poolSize).setQueueCapacity(queueCapacity).setStatisticsEnabled(this.statisticsEnabled);
        config.addExecutorConfig(executorConfig);
    }

    private void configureGroup(Config config) {
        config.setGroupConfig(new GroupConfig(this.groupName, this.groupPassword));
        config.setProperty(GroupProperty.GRACEFUL_SHUTDOWN_MAX_WAIT.getName(), this.environment.getProperty("hazelcast.graceful.shutdown.max.wait"));
        config.setProperty(GroupProperty.HEALTH_MONITORING_LEVEL.getName(), this.environment.getProperty("hazelcast.health.monitoring.level"));
        config.setProperty(GroupProperty.HEALTH_MONITORING_DELAY_SECONDS.getName(), this.environment.getProperty("hazelcast.health.monitoring.delay"));
        config.setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_ENABLED.getName(), Boolean.toString(false));
        config.setProperty(GroupProperty.MAX_NO_HEARTBEAT_SECONDS.getName(), this.environment.getProperty("hazelcast.max.no.heartbeat"));
        config.setProperty(GroupProperty.OPERATION_CALL_TIMEOUT_MILLIS.getName(), this.environment.getProperty("hazelcast.operation.call.timeout"));
        config.setProperty(GroupProperty.PARTITION_BACKUP_SYNC_INTERVAL.getName(), Long.toString(TimeUnit.MINUTES.toSeconds(this.getIntOrFail("hazelcast.backup.sync.interval"))));
        config.setProperty(GroupProperty.PHONE_HOME_ENABLED.getName(), Boolean.toString(false));
        config.setProperty(GroupProperty.SHUTDOWNHOOK_ENABLED.getName(), Boolean.toString(false));
    }

    private void configureJmx(Config config) {
        config.setProperty("hazelcast.jmx", Boolean.toString(this.jmxEnabled));
        config.setProperty("hazelcast.jmx.detailed", Boolean.toString(this.jmxEnabled && this.jmxDetailed));
    }

    private void configureMaps(Config config) {
        config.addMapConfig(new MapConfig("default").setBackupCount(1).setStatisticsEnabled(this.statisticsEnabled));
        config.addMapConfig(new MapConfig(HttpSession.class.getName()).setAsyncBackupCount(1).setBackupCount(0).setNearCacheConfig(this.defaultNearCacheConfig()).setMaxIdleSeconds(this.serverSessionTimeout).setStatisticsEnabled(this.statisticsEnabled));
        config.addMapConfig(new MapConfig("bucketed.executor.tasks").setAsyncBackupCount(1).setBackupCount(0).setStatisticsEnabled(this.statisticsEnabled).setInMemoryFormat(InMemoryFormat.OBJECT));
        config.addMapConfig(new MapConfig("com.atlassian.stash.internal.pull.PendingUpdatesCount").setAsyncBackupCount(1).setBackupCount(0).setStatisticsEnabled(this.statisticsEnabled));
        config.addMapConfig(new MapConfig("mirror.secrets.map").setAsyncBackupCount(5).setBackupCount(1).setMergePolicyConfig(new MergePolicyConfig(LatestUpdateMapMergePolicy.class.getName(), 100)).setStatisticsEnabled(this.statisticsEnabled));
        config.addMapConfig(new MapConfig("logging.state").setAsyncBackupCount(1).setBackupCount(0).setStatisticsEnabled(this.statisticsEnabled));
        config.addMapConfig(new MapConfig("profiling.state").setAsyncBackupCount(1).setBackupCount(0).setStatisticsEnabled(this.statisticsEnabled));
        config.addMapConfig(new MapConfig("mesh.control.plane").setAsyncBackupCount(5).setBackupCount(1).setMergePolicyConfig(new MergePolicyConfig(ControlPlaneStateMergePolicy.class.getName(), 100)).setStatisticsEnabled(this.statisticsEnabled));
    }

    private void configureNetwork(Config config) {
        NetworkConfig networkConfig = config.getNetworkConfig();
        if (this.networkMulticastEnabled && this.networkTcpIpEnabled) {
            log.warn("Both TCP/IP and Multicast have been enabled for Nutcluster node discovery. Setting to default TCP/IP");
            this.networkMulticastEnabled = false;
        }
        JoinConfig joinConfig = networkConfig.getJoin();
        if (this.networkAwsEnabled) {
            String portRange;
            config.setProperty("hazelcast.discovery.enabled", "true");
            String awsAccessKey = this.environment.getProperty("hazelcast.network.aws.access.key");
            String awsSecretKey = this.environment.getProperty("hazelcast.network.aws.secret.key");
            String awsIamRole = this.environment.getProperty("hazelcast.network.aws.iam.role");
            String awsRegion = this.environment.getProperty("hazelcast.network.aws.region");
            String awsHostHeader = this.environment.getProperty("hazelcast.network.aws.host.header");
            String awsSecurityGroupName = this.environment.getProperty("hazelcast.network.aws.security.group.name");
            String awsTagKey = this.environment.getProperty("hazelcast.network.aws.tag.key");
            String awsTagValue = this.environment.getProperty("hazelcast.network.aws.tag.value");
            Optional<Integer> awsTimeout = this.getTimeout("hazelcast.network.aws.connection.timeout.seconds");
            HashMap<String, Object> discoveryConfig = new HashMap<String, Object>();
            if (StringUtils.isNotEmpty((CharSequence)awsAccessKey) && StringUtils.isNotEmpty((CharSequence)awsSecretKey)) {
                discoveryConfig.put(AwsProperties.ACCESS_KEY.getDefinition().key(), awsAccessKey);
                discoveryConfig.put(AwsProperties.SECRET_KEY.getDefinition().key(), awsSecretKey);
            }
            if (StringUtils.isNotEmpty((CharSequence)awsIamRole)) {
                if (StringUtils.isNotEmpty((CharSequence)awsAccessKey) || StringUtils.isNotEmpty((CharSequence)awsSecretKey)) {
                    log.warn("hazelcast.network.aws.iam.role property will take precedence over hazelcast.network.aws.access.key and nutcluster.network.aws.secret.key");
                }
                discoveryConfig.put(AwsProperties.IAM_ROLE.getDefinition().key(), awsIamRole);
            }
            awsTimeout.ifPresent(timeout -> discoveryConfig.put(AwsProperties.CONNECTION_TIMEOUT_SECONDS.getDefinition().key(), timeout));
            if (StringUtils.isNotEmpty((CharSequence)awsRegion)) {
                discoveryConfig.put(AwsProperties.REGION.getDefinition().key(), awsRegion);
            }
            if (StringUtils.isNotEmpty((CharSequence)awsHostHeader)) {
                discoveryConfig.put(AwsProperties.HOST_HEADER.getDefinition().key(), awsHostHeader);
            }
            if (StringUtils.isNotEmpty((CharSequence)awsSecurityGroupName)) {
                discoveryConfig.put(AwsProperties.SECURITY_GROUP_NAME.getDefinition().key(), awsSecurityGroupName);
            }
            if (StringUtils.isNotEmpty((CharSequence)awsTagKey)) {
                discoveryConfig.put(AwsProperties.TAG_KEY.getDefinition().key(), awsTagKey);
                discoveryConfig.put(AwsProperties.TAG_VALUE.getDefinition().key(), awsTagValue);
            }
            if (StringUtils.isNotEmpty((CharSequence)(portRange = this.environment.getProperty("hazelcast.network.aws.port.range")))) {
                discoveryConfig.put(AwsProperties.PORT.getDefinition().key(), portRange);
            } else {
                discoveryConfig.put(AwsProperties.PORT.getDefinition().key(), this.networkPort);
            }
            DiscoveryStrategyConfig discoveryStrategyConfig = new DiscoveryStrategyConfig((DiscoveryStrategyFactory)new AwsDiscoveryStrategyFactory(), discoveryConfig);
            joinConfig.getDiscoveryConfig().addDiscoveryStrategyConfig(discoveryStrategyConfig);
            log.debug("Enabled nutcluster discovery for AWS");
        } else if (this.networkAzureEnabled) {
            config.setProperty("hazelcast.discovery.enabled", "true");
            HashMap<String, String> discoveryConfig = new HashMap<String, String>();
            discoveryConfig.put(AzureProperties.CLIENT_ID.key(), this.environment.getProperty("hazelcast.network.azure.client.id"));
            discoveryConfig.put(AzureProperties.CLIENT_SECRET.key(), this.environment.getProperty("hazelcast.network.azure.client.secret"));
            discoveryConfig.put(AzureProperties.TENANT_ID.key(), this.environment.getProperty("hazelcast.network.azure.tenant.id"));
            discoveryConfig.put(AzureProperties.SUBSCRIPTION_ID.key(), this.environment.getProperty("hazelcast.network.azure.subscription.id"));
            discoveryConfig.put(AzureProperties.CLUSTER_ID.key(), this.environment.getProperty("hazelcast.network.azure.cluster.id"));
            discoveryConfig.put(AzureProperties.GROUP_NAME.key(), this.environment.getProperty("hazelcast.network.azure.group.name"));
            DiscoveryStrategyConfig discoveryStrategyConfig = new DiscoveryStrategyConfig((DiscoveryStrategyFactory)new AzureDiscoveryStrategyFactory(), discoveryConfig);
            joinConfig.getDiscoveryConfig().addDiscoveryStrategyConfig(discoveryStrategyConfig);
            log.debug("Enabled nutcluster discovery for Azure");
        } else if (this.networkKubernetesEnabled) {
            config.setProperty("hazelcast.discovery.enabled", "true");
            DiscoveryStrategyConfig discoveryStrategyConfig = new DiscoveryStrategyConfig((DiscoveryStrategyFactory)new NutclusterKubernetesDiscoveryStrategyFactory());
            joinConfig.getDiscoveryConfig().addDiscoveryStrategyConfig(discoveryStrategyConfig);
            log.debug("Enabled nutcluster discovery for Kubernetes");
        }
        MulticastConfig multicastConfig = joinConfig.getMulticastConfig();
        multicastConfig.setEnabled(this.networkMulticastEnabled);
        if (multicastConfig.isEnabled()) {
            String multicastAddress = this.environment.getProperty("hazelcast.network.multicast.address");
            int multicastPort = this.getInt("hazelcast.network.multicast.port", 54327);
            Optional<Integer> multicastTimeout = this.getTimeout("hazelcast.network.multicast.timeout.seconds");
            Optional<Integer> multicastTtl = this.getTtl("hazelcast.network.multicast.ttl");
            multicastConfig.setMulticastPort(multicastPort);
            multicastTimeout.ifPresent(arg_0 -> ((MulticastConfig)multicastConfig).setMulticastTimeoutSeconds(arg_0));
            multicastTtl.ifPresent(arg_0 -> ((MulticastConfig)multicastConfig).setMulticastTimeToLive(arg_0));
            if (StringUtils.isNotBlank((CharSequence)multicastAddress)) {
                multicastConfig.setMulticastGroup(multicastAddress);
            }
        }
        TcpIpConfig tcpIpConfig = joinConfig.getTcpIpConfig();
        tcpIpConfig.setEnabled(this.networkTcpIpEnabled);
        if (tcpIpConfig.isEnabled()) {
            String tcpIpMembers = this.environment.getProperty("hazelcast.network.tcpip.members");
            Optional<Integer> tcpIpTimeout = this.getTimeout("hazelcast.network.tcpip.connection.timeout.seconds");
            tcpIpTimeout.ifPresent(arg_0 -> ((TcpIpConfig)tcpIpConfig).setConnectionTimeoutSeconds(arg_0));
            if (StringUtils.isNotBlank((CharSequence)tcpIpMembers)) {
                tcpIpConfig.addMember(tcpIpMembers);
            }
        }
        networkConfig.setPort(this.networkPort);
        if (StringUtils.isNotBlank((CharSequence)this.publicAddress)) {
            log.debug("Setting nutcluster public address to:" + this.publicAddress);
            networkConfig.setPublicAddress(this.publicAddress);
        }
        SocketInterceptorConfig interceptorConfig = new SocketInterceptorConfig();
        interceptorConfig.getProperties().put(ClusterJoinManager.class.getName(), this.joinManager);
        interceptorConfig.setClassName(ClusterJoinSocketInterceptor.class.getName());
        interceptorConfig.setEnabled(true);
        networkConfig.setSocketInterceptorConfig(interceptorConfig);
    }

    private void configureQueues(Config config) {
        config.addQueueConfig(new QueueConfig("mirror.refchanges.queue").setStatisticsEnabled(this.statisticsEnabled));
        config.addQueueConfig(new QueueConfig("mirror.project.metadata.queue").setStatisticsEnabled(this.statisticsEnabled));
        config.addQueueConfig(new QueueConfig("mirror.repository.metadata.queue").setStatisticsEnabled(this.statisticsEnabled));
    }

    private void configureScheduler(Config config) {
        config.addMapConfig(new MapConfig("quartz.jobStore.calendars").setStatisticsEnabled(this.statisticsEnabled));
        config.addMapConfig(new MapConfig("quartz.jobStore.jobs").setStatisticsEnabled(this.statisticsEnabled));
        config.addMapConfig(new MapConfig("quartz.jobStore.triggers").setStatisticsEnabled(this.statisticsEnabled).setMapIndexConfigs((List)ImmutableList.of((Object)new MapIndexConfig("jobGroup", false), (Object)new MapIndexConfig("jobName", false), (Object)new MapIndexConfig("nextFireTime", false), (Object)new MapIndexConfig("state", false))));
    }

    private void configureSerialization(SerializationConfig config) {
        config.addSerializerConfig(new SerializerConfig().setImplementation((Serializer)this.osgiSafeStreamSerializer).setTypeClass(OsgiSafe.class));
        config.addSerializerConfig(new SerializerConfig().setImplementation((Serializer)new LicenseStreamSerializer(this.licenseHelper)).setTypeClass(SimpleDualLicense.class));
        config.addSerializerConfig(new SerializerConfig().setImplementation((Serializer)new OptionStreamSerializer()).setTypeClass(Option.class));
        config.addSerializerConfig(new SerializerConfig().setImplementation((Serializer)new OptionalStreamSerializer()).setTypeClass(Optional.class));
    }

    private NearCacheConfig defaultNearCacheConfig() {
        return new NearCacheConfig().setInMemoryFormat(InMemoryFormat.OBJECT).setCacheLocalEntries(true);
    }

    private int getInt(String propertyName, int defaultValue) {
        String maxSize = this.environment.getProperty(propertyName);
        if (StringUtils.isBlank((CharSequence)maxSize)) {
            return defaultValue;
        }
        return Integer.parseInt(maxSize);
    }

    private int getIntOrFail(String propertyName) {
        String maxSize = this.environment.getProperty(propertyName);
        Preconditions.checkState((!StringUtils.isBlank((CharSequence)maxSize) ? 1 : 0) != 0, (String)"Property '{}' is undefined", (Object)propertyName);
        return Integer.parseInt(maxSize);
    }

    private int getMaxOrFail(String propertyName) {
        int configured = this.getIntOrFail(propertyName);
        int normalized = this.normalizeSize(configured);
        if (configured != 0 && configured != normalized) {
            log.warn("Ignoring \"{}={}\"; values less than 500, except 0, are not valid", (Object)propertyName, (Object)configured);
        }
        return normalized;
    }

    private Optional<Integer> getTimeout(String propertyName) {
        String value = this.environment.getProperty(propertyName, "-1");
        try {
            int timeout = Integer.parseInt(value);
            if (timeout > -1) {
                return Optional.of(timeout);
            }
        }
        catch (NumberFormatException e) {
            log.warn("Ignoring \"{}={}\"; timeouts must be numbers", (Object)propertyName, (Object)value);
        }
        return Optional.empty();
    }

    private Optional<Integer> getTtl(String propertyName) {
        String value = this.environment.getProperty(propertyName);
        if (StringUtils.isBlank((CharSequence)value)) {
            return Optional.empty();
        }
        try {
            int ttl = Integer.parseInt(value.trim());
            if (ttl >= 0 && ttl <= 255) {
                return Optional.of(ttl);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        log.warn("Ignoring \"{}={}\"; TTLs must be a number between 0 and 255", (Object)propertyName, (Object)value);
        return Optional.empty();
    }

    private int normalizeSize(int size) {
        if (size <= 0) {
            return Integer.MAX_VALUE;
        }
        return Math.max(size, 500);
    }
}

