/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.nutcluster;

import com.atlassian.bitbucket.dmz.mirror.DmzEphemeralStateStore;
import com.atlassian.nutcluster.core.EntryEvent;
import com.atlassian.nutcluster.core.ICompletableFuture;
import com.atlassian.nutcluster.core.IMap;
import com.atlassian.nutcluster.map.listener.EntryAddedListener;
import com.atlassian.nutcluster.map.listener.EntryMergedListener;
import com.atlassian.nutcluster.map.listener.EntryRemovedListener;
import com.atlassian.nutcluster.map.listener.EntryUpdatedListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

class NutclusterEphemeralStateStore
implements DmzEphemeralStateStore {
    private static final int EPHEMERAL_STORE_LOCK_TIMEOUT_SECONDS = 120;
    private static final int EPHEMERAL_STORE_OP_TIMEOUT_SECONDS = 60;
    private final int lockTimeoutSeconds;
    private final IMap<String, Object> map;
    private final int opTimeoutSeconds;

    NutclusterEphemeralStateStore(IMap<String, Object> map) {
        this(map, 120, 60);
    }

    @VisibleForTesting
    NutclusterEphemeralStateStore(IMap<String, Object> map, int lockTimeoutSeconds, int opTimeoutSeconds) {
        this.map = map;
        this.lockTimeoutSeconds = lockTimeoutSeconds;
        this.opTimeoutSeconds = opTimeoutSeconds;
    }

    @Nullable
    public <T> T compute(@Nonnull String key, @Nonnull UnaryOperator<T> mappingFunction) {
        return (T)this.withLock(key, () -> {
            Object value = this.withSafeTimeout(this.map.getAsync((Object)key));
            Object newValue = mappingFunction.apply(value);
            if (value != null && newValue == null) {
                this.withSafeTimeout(this.map.removeAsync((Object)key));
            } else if (newValue != null && !Objects.equals(value, newValue)) {
                this.withSafeTimeout(this.map.setAsync((Object)key, newValue));
            }
            return newValue;
        });
    }

    @Nullable
    public <T> T computeIfAbsent(@Nonnull String key, @Nonnull Supplier<T> ifAbsent) {
        return (T)this.withLock(key, () -> {
            Object value = this.withSafeTimeout(this.map.getAsync((Object)key));
            if (value == null && (value = ifAbsent.get()) != null) {
                this.withSafeTimeout(this.map.setAsync((Object)key, value));
            }
            return value;
        });
    }

    @Nonnull
    public <T> Optional<T> get(@Nonnull String key) {
        Objects.requireNonNull(key, "key");
        return Optional.ofNullable(this.withSafeTimeout(this.map.getAsync((Object)key)));
    }

    public void put(@Nonnull String key, @Nullable Object value) {
        Objects.requireNonNull(key, "key");
        if (value == null) {
            this.withSafeTimeout(this.map.removeAsync((Object)key));
        } else {
            this.withSafeTimeout(this.map.setAsync((Object)key, value));
        }
    }

    @Nonnull
    public <T> String registerChangeListener(@Nonnull String key, @Nonnull Consumer<T> changedValue) {
        return this.map.addEntryListener(new MapListenerAdapter(changedValue), (Object)key, true);
    }

    public boolean unregisterChangeListener(@Nonnull String registrationId) {
        return this.map.removeEntryListener(registrationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T withLock(String key, Supplier<T> underLock) {
        try {
            boolean lockAcquired = this.map.tryLock((Object)key, (long)this.lockTimeoutSeconds, TimeUnit.SECONDS);
            if (!lockAcquired) {
                throw new IllegalStateException("Failed to acquire lock for key '" + key + "' within timeout");
            }
            try {
                T t = underLock.get();
                return t;
            }
            finally {
                this.map.unlock((Object)key);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while waiting for lock on state key '" + key + "'", e);
        }
    }

    private <T> T withSafeTimeout(ICompletableFuture<T> future) {
        try {
            return (T)future.get((long)this.opTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for operation", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new UncheckedExecutionException(e.getCause());
        }
        catch (TimeoutException e) {
            throw new UncheckedTimeoutException("Timed out while waiting for operation to complete", (Throwable)e);
        }
    }

    private static class MapListenerAdapter<K, V>
    implements EntryAddedListener<K, V>,
    EntryUpdatedListener<K, V>,
    EntryRemovedListener<K, V>,
    EntryMergedListener<K, V> {
        private final Consumer<V> changedValue;

        MapListenerAdapter(Consumer<V> changedValue) {
            this.changedValue = changedValue;
        }

        public void entryAdded(EntryEvent<K, V> event) {
            if (!event.getMember().localMember()) {
                this.changedValue.accept(event.getValue());
            }
        }

        public void entryMerged(EntryEvent<K, V> event) {
            this.changedValue.accept(event.getValue());
        }

        public void entryRemoved(EntryEvent<K, V> event) {
            if (!event.getMember().localMember()) {
                this.changedValue.accept(null);
            }
        }

        public void entryUpdated(EntryEvent<K, V> event) {
            if (!event.getMember().localMember()) {
                this.changedValue.accept(event.getValue());
            }
        }
    }
}

