/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.nutcluster;

import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.event.Event;
import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.core.Cluster;
import com.atlassian.nutcluster.core.Nutcluster;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.core.OutOfMemoryHandler;
import com.atlassian.nutcluster.internal.serialization.InternalSerializationService;
import com.atlassian.nutcluster.serialization.OsgiSafeStreamSerializer;
import com.atlassian.nutcluster.spi.impl.SerializationServiceSupport;
import com.atlassian.stash.internal.cluster.NodePassivationException;
import com.atlassian.stash.internal.utils.ClassLoaderUtils;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.web.context.ServletContextAware;

public class NutclusterFactoryBean
extends AbstractFactoryBean<NutclusterInstance>
implements ServletContextAware {
    private static final Logger log = LoggerFactory.getLogger(NutclusterFactoryBean.class);
    private Config config;
    private OsgiSafeStreamSerializer osgiSafeStreamSerializer;
    private ServletContext servletContext;

    public Class<?> getObjectType() {
        return NutclusterInstance.class;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setOsgiSafeStreamSerializer(OsgiSafeStreamSerializer osgiSafeStreamSerializer) {
        this.osgiSafeStreamSerializer = osgiSafeStreamSerializer;
    }

    public void setOutOfMemoryHandler(OutOfMemoryHandler outOfMemoryHandler) {
        Nutcluster.setOutOfMemoryHandler((OutOfMemoryHandler)outOfMemoryHandler);
    }

    public void setServletContext(@Nonnull ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Nonnull
    protected NutclusterInstance createInstance() {
        NutclusterInstance nutcluster = this.newInstance();
        this.checkNotPassivated(nutcluster);
        Cluster cluster = nutcluster.getCluster();
        if (cluster.getMembers().size() == 1) {
            log.debug("No cluster found, promoting instance on port {} to full member", (Object)cluster.getLocalMember().getAddress().getPort());
            cluster.promoteLocalLiteMember();
        } else {
            log.debug("Joining existing cluster");
        }
        if (this.osgiSafeStreamSerializer != null) {
            this.osgiSafeStreamSerializer.setSerializationService((InternalSerializationService)((SerializationServiceSupport)nutcluster).getSerializationService());
        }
        return nutcluster;
    }

    private void checkNotPassivated(NutclusterInstance nutcluster) {
        for (Event event : Johnson.getEventContainer((ServletContext)this.servletContext).getEvents()) {
            if (!"node-passivated".equals(event.getKey().getType())) continue;
            nutcluster.shutdown();
            throw new NodePassivationException();
        }
    }

    private NutclusterInstance newInstance() {
        return (NutclusterInstance)ClassLoaderUtils.runWithClassloader((ClassLoader)Nutcluster.class.getClassLoader(), () -> Nutcluster.newNutclusterInstance((Config)this.config));
    }
}

