/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.nutcluster;

import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NutclusterLifecycle
extends AbstractSmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(NutclusterLifecycle.class);
    private final NutclusterInstance nutcluster;

    @Autowired
    public NutclusterLifecycle(NutclusterInstance nutcluster) {
        this.nutcluster = nutcluster;
    }

    public int getPhase() {
        return 1500;
    }

    public void start() {
        Address address = this.nutcluster.getCluster().getLocalMember().getAddress();
        if (this.nutcluster.getCluster().getLocalMember().isLiteMember()) {
            log.info("Promoting Nutcluster instance at {}:{} to full member", (Object)address.getHost(), (Object)address.getPort());
            this.nutcluster.getCluster().promoteLocalLiteMember();
        } else {
            log.debug("Nutcluster instance at {}:{} is already a full member, no promotion needed", (Object)address.getHost(), (Object)address.getPort());
        }
        super.start();
    }
}

