/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.oauth2;

import com.atlassian.oauth2.client.api.ClientConfiguration;
import com.atlassian.oauth2.client.api.ClientToken;
import com.atlassian.oauth2.client.api.lib.flow.FlowRequest;
import com.atlassian.oauth2.client.api.lib.flow.FlowRequestService;
import com.atlassian.oauth2.client.api.lib.flow.FlowResult;
import com.atlassian.oauth2.client.api.storage.TokenHandler;
import com.atlassian.oauth2.client.api.storage.config.ClientConfigStorageService;
import com.atlassian.oauth2.client.api.storage.config.ClientConfigurationEntity;
import com.atlassian.oauth2.client.api.storage.token.ClientTokenEntity;
import com.atlassian.oauth2.client.api.storage.token.ClientTokenStorageService;
import com.atlassian.oauth2.client.api.storage.token.exception.RecoverableTokenException;
import com.atlassian.oauth2.client.api.storage.token.exception.TokenNotFoundException;
import com.atlassian.oauth2.client.api.storage.token.exception.UnrecoverableTokenException;
import com.atlassian.stash.internal.oauth2.OAuth2Exception;
import com.atlassian.stash.internal.oauth2.OAuth2Service;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpSession;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class DefaultOAuth2Service
implements OAuth2Service {
    static final String FLOW_ID = "flow-id";
    private final ClientConfigStorageService clientConfigStorageService;
    private final ClientTokenStorageService clientTokenStorageService;
    private final FlowRequestService flowRequestService;
    private final TokenHandler tokenHandler;

    public DefaultOAuth2Service(ClientConfigStorageService clientConfigStorageService, ClientTokenStorageService clientTokenStorageService, FlowRequestService flowRequestService, TokenHandler tokenHandler) {
        this.clientConfigStorageService = Objects.requireNonNull(clientConfigStorageService, "clientConfigStorageService");
        this.clientTokenStorageService = Objects.requireNonNull(clientTokenStorageService, "clientTokenStorageService");
        this.flowRequestService = Objects.requireNonNull(flowRequestService, "flowRequestService");
        this.tokenHandler = Objects.requireNonNull(tokenHandler, "tokenHandler");
    }

    @Nonnull
    public String completeOAuth2Flow(@Nonnull HttpSession session, @Nonnull String oAuthProviderId) throws OAuth2Exception {
        Object flowId = session.getAttribute(FLOW_ID);
        if (flowId == null) {
            throw new OAuth2Exception("No Flow Identifier found for OAuth Provider Id: " + oAuthProviderId);
        }
        FlowResult flowResult = this.flowRequestService.getFlowResult(session, flowId.toString());
        if (flowResult.indicatesSuccess()) {
            ClientToken clientToken = flowResult.toSuccessResult();
            try {
                ClientTokenEntity savedToken = this.clientTokenStorageService.save(ClientTokenEntity.builder((ClientToken)clientToken).lastStatusUpdated(Instant.now()).configId(oAuthProviderId).build());
                return savedToken.getId();
            }
            catch (TokenNotFoundException tokenNotFoundException) {
                throw new OAuth2Exception((Throwable)tokenNotFoundException);
            }
        }
        throw new OAuth2Exception(flowResult.toErrorResult().getMessage());
    }

    @Nonnull
    public List<OAuth2Service.OAuth2Provider> getConfiguredOAuth2Providers() {
        return this.clientConfigStorageService.list().stream().map(entity -> new OAuth2Service.OAuth2Provider(entity.getId(), entity.getName(), entity.getProviderType().getKey())).collect(Collectors.toList());
    }

    @Nonnull
    public ClientToken getRefreshedToken(@Nonnull String token) throws OAuth2Exception {
        try {
            return this.tokenHandler.getRefreshedToken(token);
        }
        catch (RecoverableTokenException | UnrecoverableTokenException e) {
            throw new OAuth2Exception(e);
        }
    }

    @Nonnull
    public ClientTokenEntity getToken(@Nonnull String tokenId) throws OAuth2Exception {
        try {
            return this.clientTokenStorageService.getByIdOrFail(tokenId);
        }
        catch (TokenNotFoundException e) {
            throw new OAuth2Exception((Throwable)e);
        }
    }

    @Nonnull
    public OAuth2Service.OAuth2Result initialiseOAuth2Flow(@Nonnull HttpSession session, @Nonnull String oAuth2ProviderId, @Nonnull UnaryOperator<String> buildRedirect) throws IllegalArgumentException {
        ClientConfigurationEntity configurationEntity = (ClientConfigurationEntity)this.clientConfigStorageService.getById(oAuth2ProviderId).orElseThrow(() -> new IllegalArgumentException("No Authorization Method found for id: " + oAuth2ProviderId));
        FlowRequest flowRequest = this.flowRequestService.createFlowRequest(session, (ClientConfiguration)configurationEntity, buildRedirect);
        session.setAttribute(FLOW_ID, (Object)flowRequest.getId());
        return new OAuth2Service.OAuth2Result(flowRequest.getId(), flowRequest.getInitFlowUrl());
    }
}

