/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.permission;

import com.atlassian.bitbucket.permission.PermissionCheck;
import com.atlassian.bitbucket.permission.PermissionVote;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.permission.SimplePermissionCheck;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;

public class CompositePermissionVoter
implements PermissionVoter {
    private final List<PermissionVoter> voters;

    private CompositePermissionVoter(Builder builder) {
        this.voters = builder.voters.build();
    }

    @Nonnull
    public static CompositePermissionVoter of(@Nullable Iterable<PermissionVoter> voters) {
        return new Builder().add(voters).build();
    }

    @Nonnull
    public static CompositePermissionVoter of(@Nullable PermissionVoter voter, PermissionVoter ... moreVoters) {
        return new Builder().add(voter, moreVoters).build();
    }

    @Nonnull
    public PermissionVote vote(@Nonnull PermissionCheck check) {
        return this.vote(CompositePermissionVoter.toSimpleCheck(check));
    }

    public String toString() {
        return "{CompositePermissionVoter voters: " + String.valueOf(this.voters) + "}";
    }

    private static SimplePermissionCheck toSimpleCheck(PermissionCheck check) {
        if (check instanceof SimplePermissionCheck) {
            return (SimplePermissionCheck)check;
        }
        return new SimplePermissionCheck.Builder(check.getPermission()).resource(check.getResource()).result(check.getResult()).build();
    }

    @Nonnull
    private PermissionVote vote(@Nonnull SimplePermissionCheck check) {
        for (PermissionVoter voter : this.voters) {
            if (check.getResult() == PermissionVote.VETO) break;
            check.addVote(voter.vote((PermissionCheck)check));
        }
        return check.getResult();
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableList.Builder<PermissionVoter> voters = ImmutableList.builder();

        @Nonnull
        public Builder add(@Nullable PermissionVoter value, PermissionVoter ... moreValues) {
            Builder.addIf(Objects::nonNull, this.voters, (Object)value, (Object[])moreValues);
            return this;
        }

        @Nonnull
        public Builder add(@Nullable Iterable<PermissionVoter> values) {
            Builder.addIf(Objects::nonNull, this.voters, values);
            return this;
        }

        @Nonnull
        public CompositePermissionVoter build() {
            return new CompositePermissionVoter(this);
        }
    }
}

