/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.permission;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheStatisticsKey;
import com.atlassian.stash.internal.permission.PermissionCacheStatistics;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;

public class DefaultPermissionCacheStatistics
implements PermissionCacheStatistics {
    private final String cacheName;
    private final CacheManager cacheManager;
    private final LongAdder invalidations = new LongAdder();
    private final LongAdder partialInvalidations = new LongAdder();

    public DefaultPermissionCacheStatistics(@Nonnull String cacheName, @Nonnull CacheManager cacheManager) {
        this.cacheManager = Objects.requireNonNull(cacheManager);
        this.cacheName = Objects.requireNonNull(cacheName);
    }

    public long getHits() {
        return this.getAtlassianCacheStatistics(CacheStatisticsKey.HIT_COUNT);
    }

    public long getInvalidations() {
        return this.invalidations.longValue();
    }

    public long getLoads() {
        return this.getAtlassianCacheStatistics(CacheStatisticsKey.LOAD_COUNT);
    }

    public long getMisses() {
        return this.getAtlassianCacheStatistics(CacheStatisticsKey.MISS_COUNT);
    }

    public long getPartialInvalidations() {
        return this.partialInvalidations.longValue();
    }

    public long getSize() {
        return this.getAtlassianCacheStatistics(CacheStatisticsKey.SIZE);
    }

    public long getTotalLoadTime() {
        return this.getAtlassianCacheStatistics(CacheStatisticsKey.TOTAL_LOAD_TIME);
    }

    public void onInvalidation() {
        this.invalidations.increment();
    }

    public void onPartialInvalidation() {
        this.partialInvalidations.increment();
    }

    private long getAtlassianCacheStatistics(CacheStatisticsKey key) {
        return Optional.ofNullable(this.cacheManager.getManagedCache(this.cacheName)).map(cache -> (Supplier)cache.getStatistics().get(key)).map(Supplier::get).orElse(-1L);
    }
}

