/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.permission;

import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.auth.SimpleAuthentication;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.permission.PermissionVoterProvider;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.RequestLocalSoftCache;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.permission.CompositePermissionVoter;
import com.atlassian.stash.internal.permission.LazyPermissionVoter;
import com.atlassian.stash.internal.permission.PermissionVoterFactory;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="permissionVoterFactory")
public class DefaultPermissionVoterFactory
implements PermissionVoterFactory {
    private static final Authentication ANONYMOUS = new SimpleAuthentication.Builder(null).build();
    private final List<PermissionVoterProvider> coreVoters;
    private final PluginAccessor pluginAccessor;
    private final RequestLocalSoftCache<Authentication, PermissionVoter> voterCache;

    @Autowired
    public DefaultPermissionVoterFactory(List<PermissionVoterProvider> coreVoters, PluginAccessor pluginAccessor, RequestManager requestManager) {
        this.coreVoters = coreVoters;
        this.pluginAccessor = pluginAccessor;
        this.voterCache = new RequestLocalSoftCache(requestManager);
    }

    @Nonnull
    @Profiled
    public PermissionVoter create(@Nonnull Authentication authentication) {
        Authentication auth = authentication.getUser().filter(ApplicationUser::isActive).map(u -> authentication).orElse(ANONYMOUS);
        return (PermissionVoter)this.voterCache.get((Object)auth, () -> new CompositePermissionVoter.Builder().add((Iterable)this.providers().map(provider -> {
            try (Ticker ignored = Timers.start((String)(provider.getClass().getName() + ".create(Authentication)"));){
                PermissionVoter permissionVoter = provider.create(auth);
                return permissionVoter;
            }
        }).collect(MoreCollectors.toImmutableList())).build());
    }

    private Stream<PermissionVoterProvider> providers() {
        return Stream.concat(this.coreVoters.stream(), this.pluginAccessor.getEnabledModulesByClass(PermissionVoterProvider.class).stream().map(LazyPermissionVoterProvider::new));
    }

    private static class LazyPermissionVoterProvider
    implements PermissionVoterProvider {
        private final PermissionVoterProvider delegate;

        private LazyPermissionVoterProvider(PermissionVoterProvider delegate) {
            this.delegate = delegate;
        }

        public PermissionVoter create(@Nonnull Authentication authentication) {
            return new LazyPermissionVoter(authentication, this.delegate);
        }
    }
}

