/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.permission;

import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.dmz.permission.EffectiveGlobalPermission;
import com.atlassian.bitbucket.dmz.permission.EffectivePermission;
import com.atlassian.bitbucket.dmz.permission.EffectivePermissionVisitor;
import com.atlassian.bitbucket.dmz.permission.EffectiveProjectPermission;
import com.atlassian.bitbucket.dmz.permission.EffectiveRepositoryPermission;
import com.atlassian.bitbucket.permission.PermissionCheck;
import com.atlassian.bitbucket.permission.PermissionVote;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.permission.PermissionVoterProvider;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.permission.GrantedPermissionVoter;
import com.atlassian.stash.internal.user.EffectivePermissionsService;
import jakarta.annotation.Nonnull;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="effectivePermissionVoterProvider")
public class EffectivePermissionVoterProvider
implements PermissionVoterProvider {
    private static final ResourceIdVisitor RESOURCE_ID_VISITOR = new ResourceIdVisitor();
    private final EffectivePermissionsService effectivePermissionsService;

    @Autowired
    public EffectivePermissionVoterProvider(EffectivePermissionsService effectivePermissionsService) {
        this.effectivePermissionsService = effectivePermissionsService;
    }

    public PermissionVoter create(@Nonnull Authentication authentication) {
        return authentication.getUser().map(x$0 -> new EffectivePermissionVoter((ApplicationUser)x$0)).orElse(null);
    }

    private class EffectivePermissionVoter
    implements PermissionVoter {
        private final ApplicationUser user;

        private EffectivePermissionVoter(ApplicationUser user) {
            this.user = user;
        }

        @Nonnull
        public PermissionVote vote(@Nonnull PermissionCheck check) {
            if (check.getResult() != PermissionVote.ABSTAIN) {
                return PermissionVote.ABSTAIN;
            }
            Set<EffectivePermission> permissions = EffectivePermissionVoterProvider.this.effectivePermissionsService.getEffectivePermissions(this.user);
            if (permissions.isEmpty()) {
                return PermissionVote.ABSTAIN;
            }
            GrantedPermissionVoter.Builder builder = new GrantedPermissionVoter.Builder();
            permissions.forEach(effectivePerm -> builder.add(effectivePerm.getPermission(), (Integer)effectivePerm.accept((EffectivePermissionVisitor)RESOURCE_ID_VISITOR)));
            return builder.build().vote(check);
        }
    }

    private static class ResourceIdVisitor
    implements EffectivePermissionVisitor<Integer> {
        private ResourceIdVisitor() {
        }

        public Integer visit(@Nonnull EffectiveGlobalPermission permission) {
            return null;
        }

        public Integer visit(@Nonnull EffectiveRepositoryPermission permission) {
            return permission.getRepositoryId();
        }

        public Integer visit(@Nonnull EffectiveProjectPermission permission) {
            return permission.getProjectId();
        }
    }
}

