/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.permission;

import com.atlassian.bitbucket.permission.PermissionCheck;
import com.atlassian.bitbucket.permission.PermissionVote;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.stash.internal.permission.CompositePermissionVoter;
import com.atlassian.stash.internal.permission.PermissionVoters;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class EscalatedPermissionVoter
implements PermissionVoter {
    private final PermissionVoter escalationVoter;
    private final PermissionVoter regularVoter;

    EscalatedPermissionVoter(@Nonnull PermissionVoter escalationVoter, @Nonnull PermissionVoter regularVoter) {
        this.escalationVoter = Objects.requireNonNull(escalationVoter, "escalationVoter");
        this.regularVoter = Objects.requireNonNull(regularVoter, "regularVoter");
    }

    @Nonnull
    public static PermissionVoter maybeEscalate(@Nullable PermissionVoter activeVoter, @Nullable PermissionVoter escalationVoter, @Nullable PermissionVoter regularVoter) {
        PermissionVoter nextEscalationVoter = escalationVoter;
        if (activeVoter instanceof EscalatedPermissionVoter) {
            PermissionVoter activeEscalationVoter = ((EscalatedPermissionVoter)activeVoter).escalationVoter;
            Object object = nextEscalationVoter = escalationVoter == null ? activeEscalationVoter : CompositePermissionVoter.of(activeEscalationVoter, escalationVoter);
        }
        if (nextEscalationVoter == null) {
            return regularVoter == null ? PermissionVoters.alwaysAbstain() : regularVoter;
        }
        return new EscalatedPermissionVoter(nextEscalationVoter, (PermissionVoter)MoreObjects.firstNonNull((Object)regularVoter, (Object)PermissionVoters.alwaysAbstain()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EscalatedPermissionVoter that = (EscalatedPermissionVoter)o;
        return Objects.equals(this.escalationVoter, that.escalationVoter) && Objects.equals(this.regularVoter, that.regularVoter);
    }

    public int hashCode() {
        return Objects.hash(this.escalationVoter, this.regularVoter);
    }

    @Nonnull
    public PermissionVote vote(@Nonnull PermissionCheck permissionCheck) {
        Objects.requireNonNull(permissionCheck, "permissionCheck");
        PermissionVote vote = this.escalationVoter.vote(permissionCheck);
        if (vote != PermissionVote.ABSTAIN) {
            return vote;
        }
        return this.regularVoter.vote(permissionCheck);
    }
}

