/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.permission;

import com.atlassian.bitbucket.dmz.permission.EffectivePermission;
import com.atlassian.bitbucket.dmz.permission.SimpleEffectiveGlobalPermission;
import com.atlassian.bitbucket.dmz.permission.SimpleEffectiveProjectPermission;
import com.atlassian.bitbucket.dmz.permission.SimpleEffectiveRepositoryPermission;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionCheck;
import com.atlassian.bitbucket.permission.PermissionVote;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.user.ResourcePermission;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Pair;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.LongFunction;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class GrantedPermissionVoter
implements Externalizable,
Iterable<EffectivePermission>,
PermissionVoter {
    static final GrantedPermissionVoter NO_PERMS = new GrantedPermissionVoter(new long[0]);
    private static final Encoding ENCODING = new Encoding();
    private long[] values;

    public GrantedPermissionVoter() {
    }

    private GrantedPermissionVoter(long[] values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && Arrays.equals(this.values, ((GrantedPermissionVoter)o).values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @Nonnull
    public PermissionVote vote(@Nonnull PermissionCheck permissionCheck) {
        if (this.values.length == 0) {
            return PermissionVote.ABSTAIN;
        }
        return this.isGranted(ENCODING.createMatcher(permissionCheck));
    }

    public int getSize() {
        return this.values.length;
    }

    @Override
    @Nonnull
    public Iterator<EffectivePermission> iterator() {
        return this.stream().iterator();
    }

    @Nonnull
    public Stream<EffectivePermission> stream() {
        return Arrays.stream(this.values).mapToObj(Encoding.TO_EFFECTIVE_PERMISSION).filter(Objects::nonNull);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        this.values = new long[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = in.readLong();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GrantedPermissionVoter{values={");
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(ENCODING.toString(this.values[i]));
            }
        }
        sb.append("}}");
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.values.length);
        for (long value : this.values) {
            out.writeLong(value);
        }
    }

    private PermissionVote isGranted(Matcher matcher) {
        for (long value : this.values) {
            if (!matcher.matches(value)) continue;
            return PermissionVote.GRANT;
        }
        return PermissionVote.ABSTAIN;
    }

    static class Encoding {
        private static final long FLAG_PERM_GLOBAL = 0x100000000000000L;
        private static final long FLAG_PERM_PROJECT = 0x200000000000000L;
        private static final long FLAG_PERM_REPO = 0x400000000000000L;
        private static final long FLAG_PERM_USER = 0x800000000000000L;
        private static final int[] ENCODED_PERMISSIONS;
        private static final Map<Integer, Permission> DECODED_PERMISSIONS;
        private static final LongFunction<EffectivePermission> TO_EFFECTIVE_PERMISSION;

        Encoding() {
        }

        public String toString(long encoded) {
            String permissionString = Encoding.decodePermission(encoded).toString();
            if ((encoded & 0x100000000000000L) != 0L) {
                return permissionString;
            }
            return permissionString + ": " + Encoding.decodeResourceId(encoded);
        }

        public long encode(@Nonnull Permission permission, @Nullable Integer resourceId) {
            Preconditions.checkArgument((resourceId == null || resourceId > 0 ? 1 : 0) != 0, (Object)"resourceId must be null or greater than 0");
            return Encoding.getCategory(permission) | Encoding.encodeResourceId(resourceId) | (long)Encoding.encodeEffectivePermissionInt(permission);
        }

        @Nonnull
        Matcher createMatcher(@Nonnull PermissionCheck permissionCheck) {
            int permissionInt = Encoding.encodePermissionInt(permissionCheck.getPermission());
            return encoded -> {
                if ((encoded & (long)permissionInt) == 0L) {
                    return false;
                }
                if (!permissionCheck.getResource().isPresent()) {
                    return true;
                }
                if ((encoded & 0x100000000000000L) != 0L) {
                    return true;
                }
                int projectId = this.getProjectId(permissionCheck);
                int repositoryId = this.getRepositoryId(permissionCheck);
                int userId = this.getUserId(permissionCheck);
                int encodedId = Encoding.decodeResourceId(encoded);
                return (encoded & 0x200000000000000L) != 0L && projectId != 0 && (encodedId == 0 || projectId == encodedId) || (encoded & 0x400000000000000L) != 0L && repositoryId != 0 && (encodedId == 0 || repositoryId == encodedId) || (encoded & 0x800000000000000L) != 0L && userId != 0 && (encodedId == 0 || userId == encodedId);
            };
        }

        private int getProjectId(PermissionCheck permissionCheck) {
            return permissionCheck.getResource().map(resource -> {
                if (resource instanceof Project) {
                    return ((Project)resource).getId();
                }
                if (resource instanceof Repository) {
                    return ((Repository)resource).getProject().getId();
                }
                return 0;
            }).orElse(0);
        }

        private int getRepositoryId(PermissionCheck permissionCheck) {
            return permissionCheck.getResource().map(resource -> {
                if (resource instanceof Repository) {
                    return ((Repository)resource).getId();
                }
                return 0;
            }).orElse(0);
        }

        private int getUserId(PermissionCheck permissionCheck) {
            return permissionCheck.getResource().map(resource -> {
                if (resource instanceof ApplicationUser) {
                    return ((ApplicationUser)resource).getId();
                }
                return 0;
            }).orElse(0);
        }

        private static long getCategory(Permission permission) {
            if (permission.isGlobal()) {
                return 0x100000000000000L;
            }
            if (permission.isResource(Project.class)) {
                return 0x200000000000000L;
            }
            if (permission.isResource(Repository.class)) {
                return 0x400000000000000L;
            }
            if (permission.isResource(ApplicationUser.class)) {
                return 0x800000000000000L;
            }
            throw new IllegalArgumentException("Unsupported permission type " + String.valueOf(permission));
        }

        @VisibleForTesting
        static int decodeResourceId(long encoded) {
            return (int)(encoded >> 24);
        }

        private static boolean isSameCategoryAndResourceId(long encoded1, long encoded2) {
            return (encoded1 & 0xFFFFFFFFFF000000L) == (encoded2 & 0xFFFFFFFFFF000000L);
        }

        private static long encodeResourceId(Integer resourceId) {
            return resourceId != null ? (long)resourceId.intValue() << 24 : 0L;
        }

        @VisibleForTesting
        static Permission decodePermission(long encoded) {
            int permission = Encoding.unmaskPermissionBitsInt(encoded);
            return DECODED_PERMISSIONS.get(permission);
        }

        private static int unmaskPermissionBitsInt(long encoded) {
            return 0xFFFFFF & (int)encoded;
        }

        private static long unmaskPermissionBits(long encoded) {
            return 0xFFFFFFL & (long)((int)encoded);
        }

        private static int encodePermissionInt(Permission permission) {
            return 1 << permission.getId();
        }

        private static int encodeEffectivePermissionInt(Permission permission) {
            return ENCODED_PERMISSIONS[permission.ordinal()];
        }

        private long getProjectMatcher(int projectId) {
            return 0x200000000000000L | Encoding.encodeResourceId(projectId);
        }

        private static boolean isResourcePermission(long encoding) {
            return (encoding & 0x100000000000000L) == 0L;
        }

        static {
            TO_EFFECTIVE_PERMISSION = encoded -> {
                Permission permission = Encoding.decodePermission(encoded);
                if ((encoded & 0x100000000000000L) != 0L) {
                    return new SimpleEffectiveGlobalPermission(permission);
                }
                int resourceId = Encoding.decodeResourceId(encoded);
                if ((encoded & 0x200000000000000L) != 0L) {
                    return new SimpleEffectiveProjectPermission(resourceId, permission);
                }
                if ((encoded & 0x400000000000000L) != 0L) {
                    return new SimpleEffectiveRepositoryPermission(resourceId, permission);
                }
                if ((encoded & 0x800000000000000L) != 0L) {
                    return null;
                }
                throw new IllegalStateException("Permission type not recognised");
            };
            ENCODED_PERMISSIONS = new int[Permission.values().length];
            DECODED_PERMISSIONS = new HashMap<Integer, Permission>();
            for (Permission permission : Permission.values()) {
                int value = Encoding.encodePermissionInt(permission);
                for (Permission inherited : permission.getInheritedPermissions()) {
                    value |= Encoding.encodePermissionInt(inherited);
                }
                Encoding.ENCODED_PERMISSIONS[permission.ordinal()] = value;
                DECODED_PERMISSIONS.put(value, permission);
            }
        }
    }

    static interface Matcher {
        public boolean matches(long var1);
    }

    public static class Builder {
        private static final long NO_GLOBAL_PERMS = 0x100000000000000L;
        private List<Long> values = new ArrayList<Long>();

        @Nonnull
        public Builder add(@Nonnull ResourcePermission permission) {
            if (permission.isGlobal()) {
                this.values.add(ENCODING.encode(permission.getPermission(), null));
            } else if (permission.isProject()) {
                this.values.add(ENCODING.encode(permission.getPermission(), permission.getProjectId()));
            } else if (permission.isRepository()) {
                this.values.add(ENCODING.encode(permission.getPermission(), permission.getRepositoryId()));
                this.values.add(ENCODING.encode(Permission.PROJECT_VIEW, permission.getRepositoryProjectId()));
            }
            return this;
        }

        @Nonnull
        public Builder add(@Nonnull Permission permission, @Nullable Integer resourceId) {
            this.values.add(ENCODING.encode(permission, resourceId));
            return this;
        }

        @Nonnull
        public Builder addAll(@Nonnull GrantedPermissionVoter other) {
            for (long value : other.values) {
                this.values.add(value);
            }
            return this;
        }

        @Nonnull
        public Builder addResourcePermission(@Nonnull Iterable<ResourcePermission> permissions) {
            for (ResourcePermission permission : permissions) {
                this.add(permission);
            }
            return this;
        }

        @Nonnull
        public GrantedPermissionVoter build() {
            if (this.values.isEmpty()) {
                return NO_PERMS;
            }
            Pair<Long, List<Long>> permsByScope = this.partitionPermsByScope(new ArrayList<Long>(this.values));
            long globalPermissions = (Long)permsByScope.left();
            List<Long> resourcePerms = this.impliesProjectAdmin(globalPermissions) ? Collections.emptyList() : this.reduceResourcePerms(globalPermissions, (List)permsByScope.right());
            long[] v = new long[resourcePerms.size() + (this.isNonEmpty(globalPermissions) ? 1 : 0)];
            int index = 0;
            if (this.isNonEmpty(globalPermissions)) {
                v[index++] = globalPermissions;
            }
            for (Long value : resourcePerms) {
                v[index++] = value;
            }
            return new GrantedPermissionVoter(v);
        }

        @Nonnull
        public Builder clearAllForProject(Project project) {
            return this.clearAllForProject(Objects.requireNonNull(project, "project").getId());
        }

        @Nonnull
        public Builder clearAllForProject(int projectId) {
            long projectMatcher = ENCODING.getProjectMatcher(projectId);
            Iterator<Long> it = this.values.iterator();
            while (it.hasNext()) {
                long value = it.next();
                if ((value & projectMatcher) != projectMatcher || Encoding.decodeResourceId(value) != projectId) continue;
                it.remove();
                break;
            }
            return this;
        }

        private Pair<Long, List<Long>> partitionPermsByScope(List<Long> values) {
            Collections.sort(values);
            int resourcePermIndex = Math.max(0, Iterables.indexOf(values, Encoding::isResourcePermission));
            long result = 0x100000000000000L;
            for (Long permission : values.subList(0, resourcePermIndex)) {
                result |= permission.longValue();
            }
            ArrayList<Long> resourcePerms = new ArrayList<Long>(values.subList(resourcePermIndex, values.size()));
            return Pair.pair((Object)result, resourcePerms);
        }

        private boolean impliesProjectAdmin(long globalPermissions) {
            long projAdminPermission = Encoding.encodePermissionInt(Permission.PROJECT_ADMIN);
            return (globalPermissions & projAdminPermission) == projAdminPermission;
        }

        private boolean isNonEmpty(long globalPermission) {
            return globalPermission != 0x100000000000000L;
        }

        private List<Long> reduceResourcePerms(long globalPermission, List<Long> resourcePerms) {
            boolean hasGlobalPermission = this.isNonEmpty(globalPermission);
            ArrayList<Long> reducedList = new ArrayList<Long>(resourcePerms.size());
            long prev = 0L;
            for (long value : resourcePerms) {
                if (hasGlobalPermission && (globalPermission & Encoding.unmaskPermissionBits(value)) != 0L) continue;
                if (Encoding.isSameCategoryAndResourceId(value, prev)) {
                    int lastIdx = reducedList.size() - 1;
                    reducedList.set(lastIdx, value |= prev);
                } else {
                    reducedList.add(value);
                }
                prev = value;
            }
            return reducedList;
        }
    }
}

