/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.permission;

import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.dmz.permission.EffectivePermission;
import com.atlassian.bitbucket.dmz.permission.EffectivePermissionsChangedEvent;
import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.event.cluster.ClusterNodeRejoinedEvent;
import com.atlassian.bitbucket.event.permission.PermissionEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionEvent;
import com.atlassian.bitbucket.event.user.GroupCleanupEvent;
import com.atlassian.bitbucket.event.user.UserCleanupEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionCheck;
import com.atlassian.bitbucket.permission.PermissionVote;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.permission.PermissionVoterProvider;
import com.atlassian.bitbucket.user.AbstractApplicationUserVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.event.group.GroupMembershipsCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsDeletedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.crowd.event.user.UsersDeletedEvent;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.permission.GrantedPermissionVoter;
import com.atlassian.stash.internal.permission.PermissionCacheStatistics;
import com.atlassian.stash.internal.permission.PermissionCacheStatisticsSummary;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.EffectivePermissionDao;
import com.atlassian.stash.internal.user.InternalUserService;
import com.atlassian.stash.internal.user.InternalUserUtils;
import com.atlassian.stash.internal.user.ProjectPermissionDao;
import com.atlassian.stash.internal.user.ResourcePermission;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timer;
import com.atlassian.util.profiling.Timers;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Pair;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="grantedPermissionVoterProvider")
@Order(value=1)
public class GrantedPermissionVoterProvider
implements PermissionVoterProvider {
    static final String CACHE_NAME_DEFAULT_PERMISSIONS = "bb.internal.defaultPermissions";
    static final String CACHE_NAME_GROUP_MEMBERSHIP = "bb.internal.groupMembership";
    static final String CACHE_NAME_GROUP_PERMISSIONS = "bb.internal.groupPermissions";
    static final String CACHE_NAME_USER_PERMISSIONS = "bb.internal.userPermissions";
    private static final Logger log = LoggerFactory.getLogger(GrantedPermissionVoterProvider.class);
    private static final Timer TIMER_DEFAULT_PERMISSIONS = Timers.timer((String)(GrantedPermissionVoterProvider.class.getSimpleName() + " - load default permissions"));
    private static final Timer TIMER_GROUP_MEMBERSHIPS = Timers.timer((String)(GrantedPermissionVoterProvider.class.getSimpleName() + " - load group memberships"));
    private static final Timer TIMER_GROUP_PERMISSIONS = Timers.timer((String)(GrantedPermissionVoterProvider.class.getSimpleName() + " - load group permissions"));
    private static final Timer TIMER_NORMAL_USER_CALCULATE = Timers.timer((String)(NormalUserPermissionVoterCalculator.class.getSimpleName() + ".calculate()"));
    private static final Timer TIMER_SERVICE_USER_CALCULATE = Timers.timer((String)(ServiceUserPermissionVoterCalculator.class.getSimpleName() + ".calculate()"));
    private static final Timer TIMER_USER_PERMISSIONS = Timers.timer((String)(GrantedPermissionVoterProvider.class.getSimpleName() + " - load user permissions"));
    private final PermissionCacheStatistics defaultPermissionStatistics;
    private final CachedReference<GrantedPermissionVoter> defaultPermissions;
    private final EffectivePermissionDao effectivePermissionDao;
    private final Cache<String, Collection<String>> groupMembership;
    private final PermissionCacheStatistics groupMembershipStatistics;
    private final PermissionCacheStatistics groupPermissionStatistics;
    private final Cache<String, GrantedPermissionVoter> groupPermissions;
    private final ThreadLocal<Map<String, List<ResourcePermission>>> precalculatedGroupPermissions;
    private final ThreadLocal<Map<Integer, List<ResourcePermission>>> precalculatedUserPermissions;
    private final ProjectPermissionDao projectPermissionDao;
    private final TransactionTemplate readOnlyTransaction;
    private final TransactionTemplate requiresNewTransaction;
    private final PermissionCacheStatistics userPermissionStatistics;
    private final Cache<Integer, GrantedPermissionVoter> userPermissions;
    private volatile long cacheVersion;
    private InternalUserService userService;

    @Autowired
    public GrantedPermissionVoterProvider(CacheFactory cacheFactory, PermissionCacheStatisticsSummary cacheStatistics, EffectivePermissionDao effectivePermissionDao, ProjectPermissionDao projectPermissionDao, PlatformTransactionManager transactionManager, @Value(value="${permissions.cache.projectDefaults.ttl}") int defaultCacheTtl, @Value(value="${permissions.cache.groups.max}") int groupCacheMax, @Value(value="${permissions.cache.groups.ttl}") int groupCacheTtl, @Value(value="${permissions.cache.group-membership.max}") int groupMembershipCacheMax, @Value(value="${permissions.cache.group-membership.ttl}") int groupMembershipCacheTtl, @Value(value="${permissions.cache.users.max}") int userCacheMax, @Value(value="${permissions.cache.users.ttl}") int userCacheTtl) {
        this.effectivePermissionDao = effectivePermissionDao;
        this.projectPermissionDao = projectPermissionDao;
        this.defaultPermissions = cacheFactory.getCachedReference(CACHE_NAME_DEFAULT_PERMISSIONS, this::loadDefaultPermissions, new CacheSettingsBuilder().expireAfterWrite((long)defaultCacheTtl, TimeUnit.SECONDS).remote().replicateAsynchronously().replicateViaInvalidation().statisticsEnabled().build());
        this.groupMembership = cacheFactory.getCache(CACHE_NAME_GROUP_MEMBERSHIP, this::loadGroupMembership, new CacheSettingsBuilder().expireAfterWrite((long)groupMembershipCacheTtl, TimeUnit.SECONDS).maxEntries(groupMembershipCacheMax).remote().replicateAsynchronously().replicateViaInvalidation().statisticsEnabled().build());
        this.groupPermissions = cacheFactory.getCache(CACHE_NAME_GROUP_PERMISSIONS, null, new CacheSettingsBuilder().expireAfterWrite((long)groupCacheTtl, TimeUnit.SECONDS).maxEntries(groupCacheMax).remote().replicateAsynchronously().replicateViaInvalidation().statisticsEnabled().build());
        this.userPermissions = cacheFactory.getCache(CACHE_NAME_USER_PERMISSIONS, this::loadUserPermissions, new CacheSettingsBuilder().expireAfterWrite((long)userCacheTtl, TimeUnit.SECONDS).maxEntries(userCacheMax).remote().replicateAsynchronously().replicateViaInvalidation().statisticsEnabled().build());
        this.defaultPermissionStatistics = cacheStatistics.getDefault();
        this.groupPermissionStatistics = cacheStatistics.getGroup();
        this.groupMembershipStatistics = cacheStatistics.getGroupMembership();
        this.userPermissionStatistics = cacheStatistics.getUser();
        this.precalculatedGroupPermissions = new ThreadLocal();
        this.precalculatedUserPermissions = new ThreadLocal();
        this.readOnlyTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)0, (boolean)true));
        this.requiresNewTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    public PermissionVoter create(@Nonnull Authentication authentication) {
        return authentication.getUser().filter(InternalUserUtils::isInternalUser).map(x$0 -> new RecalculatingPermissionVoter((ApplicationUser)x$0)).orElse(null);
    }

    @Nonnull
    public Iterable<EffectivePermission> getEffectivePermissions(@Nonnull ApplicationUser user) {
        if (InternalUserUtils.isInternalUser(user)) {
            return new RecalculatingPermissionVoter(user).getVoter();
        }
        return Collections.emptySet();
    }

    @EventListener
    public void onClusterNodeAdded(ClusterNodeAddedEvent event) {
        if (event.isMaybeNetworkPartitionResolved()) {
            log.debug("Invalidating all permission caches because node {} {}joined the cluster", (Object)event.getAddedNode().getAddress(), (Object)(event instanceof ClusterNodeRejoinedEvent ? "re" : ""));
            this.defaultPermissions.reset();
            this.groupPermissions.removeAll();
            this.groupMembership.removeAll();
            this.userPermissions.removeAll();
            this.markCacheUpdated();
            this.defaultPermissionStatistics.onInvalidation();
            this.groupMembershipStatistics.onInvalidation();
            this.groupPermissionStatistics.onInvalidation();
            this.userPermissionStatistics.onInvalidation();
        }
    }

    @EventListener
    public void onEffectivePermissionsChanged(EffectivePermissionsChangedEvent event) {
        this.markCacheUpdated();
    }

    @EventListener
    public void onGroupCleanup(GroupCleanupEvent event) {
        this.groupPermissions.remove((Object)IdentifierUtils.toLowerCase((String)event.getGroup()));
        this.groupPermissionStatistics.onPartialInvalidation();
        log.debug("Group cleanup event - Invalidating entire group membership cache");
        this.groupMembership.removeAll();
        this.groupMembershipStatistics.onInvalidation();
        this.markCacheUpdated();
    }

    @EventListener
    public void onGroupMembershipsCreated(GroupMembershipsCreatedEvent event) {
        if (event.getMembershipType() == MembershipType.GROUP_USER) {
            event.getEntityNames().stream().distinct().forEach(key -> {
                this.groupMembership.remove(key);
                this.groupMembershipStatistics.onPartialInvalidation();
            });
        } else {
            log.debug("Nested group membership event - Invalidating entire group membership cache");
            this.groupMembership.removeAll();
            this.groupMembershipStatistics.onInvalidation();
        }
    }

    @EventListener
    public void onGroupMembershipsDeleted(GroupMembershipsDeletedEvent event) {
        if (event.getMembershipType() == MembershipType.GROUP_USER) {
            event.getEntityNames().stream().distinct().forEach(key -> {
                this.groupMembership.remove(key);
                this.groupMembershipStatistics.onPartialInvalidation();
            });
        } else {
            log.debug("Nested group membership event - Invalidating entire group membership cache");
            this.groupMembership.removeAll();
            this.groupMembershipStatistics.onInvalidation();
        }
    }

    @EventListener
    public void onUserRenamed(UserRenamedEvent event) {
        this.groupMembership.remove((Object)event.getOldUsername());
        this.groupMembership.remove((Object)event.getUser().getName());
        this.groupMembershipStatistics.onPartialInvalidation();
    }

    @EventListener
    public void onPermissionsChanged(PermissionEvent event) {
        if (event instanceof CancelableEvent) {
            return;
        }
        ApplicationUser user = event.getAffectedUser();
        String group = event.getAffectedGroup();
        if (user != null) {
            this.userPermissions.remove((Object)user.getId());
            this.userPermissionStatistics.onPartialInvalidation();
        } else if (StringUtils.isNotBlank((CharSequence)group)) {
            this.groupPermissions.remove((Object)IdentifierUtils.toLowerCase((String)group));
            this.groupPermissionStatistics.onPartialInvalidation();
        } else if (event instanceof ProjectPermissionEvent) {
            this.defaultPermissions.reset();
            this.defaultPermissionStatistics.onInvalidation();
        }
        this.markCacheUpdated();
    }

    @EventListener
    public void onUserCleanup(UserCleanupEvent event) {
        ApplicationUser deletedUser = event.getDeletedUser();
        if (deletedUser != null) {
            this.userPermissions.remove((Object)deletedUser.getId());
            this.userPermissionStatistics.onPartialInvalidation();
        }
    }

    @EventListener
    public void onUsersDeleted(UsersDeletedEvent event) {
        for (String username : event.getUsernames()) {
            this.groupMembership.remove((Object)username);
            this.groupMembershipStatistics.onPartialInvalidation();
        }
    }

    @Autowired
    public void setUserService(InternalUserService userService) {
        this.userService = userService;
    }

    public void warmCaches() {
        this.readOnlyTransaction.executeWithoutResult(ignored -> this.defaultPermissions.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withPrecalculatedPermissions(Map<Integer, List<ResourcePermission>> userPermissions, Map<String, List<ResourcePermission>> groupPermissions, Operation<Void, Exception> operation) {
        this.precalculatedUserPermissions.set(userPermissions);
        this.precalculatedGroupPermissions.set(groupPermissions);
        try {
            operation.perform();
        }
        catch (Exception e) {
            log.debug("Unable to perform operation with precalculated user permissions", (Throwable)e);
        }
        finally {
            this.precalculatedUserPermissions.remove();
            this.precalculatedGroupPermissions.remove();
            this.markCacheUpdated();
        }
    }

    private boolean cacheInvalidatedSince(long version) {
        return this.cacheVersion != version;
    }

    private GrantedPermissionVoter getDefaultPermissions() {
        return (GrantedPermissionVoter)this.defaultPermissions.get();
    }

    private GrantedPermissionVoter getGroupsPermissions(Iterable<String> groups) {
        GrantedPermissionVoter.Builder builder = new GrantedPermissionVoter.Builder();
        Set groupsToProcess = MoreStreams.streamIterable(groups).filter(Objects::nonNull).map(IdentifierUtils::toLowerCase).collect(Collectors.toSet());
        Map permissions = this.groupPermissions.getBulk(groupsToProcess, this::loadGroupPermissionsBulk);
        permissions.forEach((key, value) -> builder.addAll((GrantedPermissionVoter)value));
        return builder.build();
    }

    private GrantedPermissionVoter getUserPermissions(Integer userId) {
        return (GrantedPermissionVoter)this.userPermissions.get((Object)userId);
    }

    private GrantedPermissionVoter loadDefaultPermissions() {
        try (Ticker ignored = TIMER_DEFAULT_PERMISSIONS.start(new String[0]);){
            GrantedPermissionVoter.Builder builder = new GrantedPermissionVoter.Builder();
            this.projectPermissionDao.getDefaultPermissions().forEach((key, value) -> builder.add((Permission)value, (Integer)key));
            GrantedPermissionVoter grantedPermissionVoter = builder.build();
            return grantedPermissionVoter;
        }
    }

    private Map<String, GrantedPermissionVoter> loadGroupPermissionsBulk(Iterable<String> groups) {
        try (Ticker ignored = TIMER_GROUP_PERMISSIONS.start(new String[0]);){
            Map permissions = this.effectivePermissionDao.findByGroups(groups);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            groups.forEach(group -> builder.put(group, (Object)new GrantedPermissionVoter.Builder().addResourcePermission(permissions.getOrDefault(group, Collections.emptyList())).build()));
            ImmutableMap immutableMap = builder.build();
            return immutableMap;
        }
    }

    public Iterable<String> loadGroupsByUser(ApplicationUser user) {
        Preconditions.checkArgument((user.getType() == UserType.NORMAL ? 1 : 0) != 0, (Object)"only normal users have groups");
        return (Iterable)this.groupMembership.get((Object)user.getName());
    }

    public Collection<String> getCurrentlyCachedGroups() {
        return this.groupPermissions.getKeys();
    }

    private Collection<String> loadGroupMembership(String username) {
        try (Ticker ignored = TIMER_GROUP_MEMBERSHIPS.start(new String[0]);){
            if (TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                ImmutableList immutableList = ImmutableList.copyOf((Iterable)this.userService.getGroupsByUser(username));
                return immutableList;
            }
            Collection collection = (Collection)this.requiresNewTransaction.execute(status -> ImmutableList.copyOf((Iterable)this.userService.getGroupsByUser(username)));
            return collection;
        }
    }

    private GrantedPermissionVoter loadUserPermissions(Integer userId) {
        try (Ticker ignored = TIMER_USER_PERMISSIONS.start(new String[0]);){
            GrantedPermissionVoter grantedPermissionVoter = new GrantedPermissionVoter.Builder().addResourcePermission(this.effectivePermissionDao.findByUserId(userId)).build();
            return grantedPermissionVoter;
        }
    }

    private void markCacheUpdated() {
        ++this.cacheVersion;
    }

    private class RecalculatingPermissionVoter
    implements PermissionVoter {
        private final PermissionVoterCalculator calculator;
        private final ApplicationUser user;
        private volatile Pair<GrantedPermissionVoter, Long> voterAndVersion;

        private RecalculatingPermissionVoter(ApplicationUser user) {
            this.user = user;
            this.calculator = this.newCalculatorForUserType(user);
            this.voterAndVersion = Pair.pair((Object)GrantedPermissionVoter.NO_PERMS, (Object)-1L);
        }

        @Nonnull
        public PermissionVote vote(@Nonnull PermissionCheck check) {
            if (check.getResult() == PermissionVote.GRANT) {
                return PermissionVote.ABSTAIN;
            }
            return this.getVoter().vote(check);
        }

        private GrantedPermissionVoter getVoter() {
            Long version = (Long)this.voterAndVersion.right();
            if (GrantedPermissionVoterProvider.this.cacheInvalidatedSince((Long)this.voterAndVersion.right())) {
                if (version != null && version != -1L) {
                    log.debug("Permission voter for user {} has expired and will be recalculated", (Object)this.user.getName());
                }
                this.voterAndVersion = this.recalculate();
            }
            return (GrantedPermissionVoter)this.voterAndVersion.left();
        }

        private PermissionVoterCalculator newCalculatorForUserType(ApplicationUser stashUser) {
            return (PermissionVoterCalculator)stashUser.accept((ApplicationUserVisitor)new AbstractApplicationUserVisitor<PermissionVoterCalculator>(){

                public PermissionVoterCalculator visit(@Nonnull DetailedUser user) {
                    return this.visit((ApplicationUser)user);
                }

                public PermissionVoterCalculator visit(@Nonnull ServiceUser user) {
                    return new ServiceUserPermissionVoterCalculator(user);
                }

                public PermissionVoterCalculator visit(@Nonnull ApplicationUser user) {
                    return new NormalUserPermissionVoterCalculator(user);
                }
            });
        }

        private Pair<GrantedPermissionVoter, Long> recalculate() {
            long currentVersion = GrantedPermissionVoterProvider.this.cacheVersion;
            return Pair.pair((Object)this.calculator.calculate(), (Object)currentVersion);
        }
    }

    private class NormalUserPermissionVoterCalculator
    implements PermissionVoterCalculator {
        private final ApplicationUser user;

        private NormalUserPermissionVoterCalculator(ApplicationUser user) {
            this.user = user;
        }

        @Override
        public GrantedPermissionVoter calculate() {
            try (Ticker ignored = TIMER_NORMAL_USER_CALCULATE.start(new String[0]);){
                GrantedPermissionVoter.Builder voterBuilder = new GrantedPermissionVoter.Builder().addAll(GrantedPermissionVoterProvider.this.getDefaultPermissions());
                this.addUserPermissions(voterBuilder);
                this.addGroupPermissions(voterBuilder);
                GrantedPermissionVoter grantedPermissionVoter = voterBuilder.build();
                return grantedPermissionVoter;
            }
        }

        private void addGroupPermissions(GrantedPermissionVoter.Builder voterBuilder) {
            Map<String, List<ResourcePermission>> preloadedGroupPermissions = GrantedPermissionVoterProvider.this.precalculatedGroupPermissions.get();
            if (preloadedGroupPermissions == null) {
                GrantedPermissionVoterProvider.this.precalculatedGroupPermissions.remove();
            }
            if (preloadedGroupPermissions != null && !preloadedGroupPermissions.isEmpty()) {
                GrantedPermissionVoterProvider.this.loadGroupsByUser(this.user).forEach(group -> {
                    String lowerGroupName = IdentifierUtils.toLowerCase((String)group);
                    GrantedPermissionVoter groupPermission = (GrantedPermissionVoter)GrantedPermissionVoterProvider.this.groupPermissions.get((Object)lowerGroupName);
                    if (groupPermission != null) {
                        voterBuilder.addAll(groupPermission);
                        return;
                    }
                    List permissions = (List)preloadedGroupPermissions.get(lowerGroupName);
                    if (permissions != null) {
                        voterBuilder.addResourcePermission(permissions);
                    }
                });
            } else {
                voterBuilder.addAll(GrantedPermissionVoterProvider.this.getGroupsPermissions(GrantedPermissionVoterProvider.this.loadGroupsByUser(this.user)));
            }
        }

        private void addUserPermissions(GrantedPermissionVoter.Builder voterBuilder) {
            Map<Integer, List<ResourcePermission>> userPermissions = GrantedPermissionVoterProvider.this.precalculatedUserPermissions.get();
            if (userPermissions == null) {
                GrantedPermissionVoterProvider.this.precalculatedUserPermissions.remove();
            }
            if (userPermissions != null) {
                List<ResourcePermission> permissions = userPermissions.get(this.user.getId());
                if (permissions != null) {
                    voterBuilder.addResourcePermission(permissions);
                }
            } else {
                voterBuilder.addAll(GrantedPermissionVoterProvider.this.getUserPermissions(this.user.getId()));
            }
        }
    }

    private class ServiceUserPermissionVoterCalculator
    implements PermissionVoterCalculator {
        private final ServiceUser user;

        private ServiceUserPermissionVoterCalculator(ServiceUser user) {
            this.user = user;
        }

        @Override
        public GrantedPermissionVoter calculate() {
            try (Ticker ignored = TIMER_SERVICE_USER_CALCULATE.start(new String[0]);){
                GrantedPermissionVoter grantedPermissionVoter = new GrantedPermissionVoter.Builder().addAll(GrantedPermissionVoterProvider.this.getUserPermissions(this.user.getId())).add(Permission.LICENSED_USER, null).build();
                return grantedPermissionVoter;
            }
        }
    }

    private static interface PermissionVoterCalculator {
        public GrantedPermissionVoter calculate();
    }
}

