/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.permission;

import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.permission.PermissionCheck;
import com.atlassian.bitbucket.permission.PermissionVote;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.permission.PermissionVoterProvider;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import jakarta.annotation.Nonnull;

public class LazyPermissionVoter
implements PermissionVoter {
    private final String providerName;
    private final Supplier<PermissionVoter> voterSupplier = Suppliers.memoize(() -> provider.create(authentication));

    LazyPermissionVoter(Authentication authentication, PermissionVoterProvider provider) {
        this.providerName = provider.getClass().getSimpleName();
    }

    @Nonnull
    public PermissionVote vote(@Nonnull PermissionCheck permissionCheck) {
        PermissionVoter voter = (PermissionVoter)this.voterSupplier.get();
        if (voter != null) {
            return voter.vote(permissionCheck);
        }
        return PermissionVote.ABSTAIN;
    }

    public String toString() {
        return "LazyPermissionVoter{voterSupplier=" + this.providerName + "}";
    }
}

