/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.permission;

import com.atlassian.bitbucket.dmz.user.DmzPermissionAdminService;
import com.atlassian.bitbucket.permission.PermissionVoterProviderModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.permission.PermissionCacheStatistics;
import com.atlassian.stash.internal.permission.PermissionCacheStatisticsSummary;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import java.util.function.Predicate;
import org.springframework.stereotype.Component;

@Component
public class PermissionSupportData
extends RootLevelSupportDataAppender {
    private static final String PERMISSIONS = "bitbucket.atst.permissions";
    private static final String CACHE_STATISTICS = "bitbucket.atst.permissions.cache-statistics";
    private static final String CACHE_STATISTICS_DEFAULT = "bitbucket.atst.permissions.cache-statistics.default";
    private static final String CACHE_STATISTICS_GROUP = "bitbucket.atst.permissions.cache-statistics.group";
    private static final String CACHE_STATISTICS_HITS = "bitbucket.atst.permissions.cache-statistics.hits";
    private static final String CACHE_STATISTICS_LOADS = "bitbucket.atst.permissions.cache-statistics.loads";
    private static final String CACHE_STATISTICS_INVALIDATIONS = "bitbucket.atst.permissions.cache-statistics.invalidations";
    private static final String CACHE_STATISTICS_MEMBERSHIP = "bitbucket.atst.permissions.cache-statistics.membership";
    private static final String CACHE_STATISTICS_MISSES = "bitbucket.atst.permissions.cache-statistics.misses";
    private static final String CACHE_STATISTICS_PARTIAL_INVALIDATIONS = "bitbucket.atst.permissions.cache-statistics.partial-invalidations";
    private static final String CACHE_STATISTICS_SIZE = "bitbucket.atst.permissions.cache-statistics.size";
    private static final String CACHE_STATISTICS_TOTAL_LOAD_TIME = "bitbucket.atst.permissions.cache-statistics.total-load-time";
    private static final String CACHE_STATISTICS_USER = "bitbucket.atst.permissions.cache-statistics.user";
    private static final String PERMISSION_COUNTS = "bitbucket.atst.permissions.permission-counts";
    private static final String PERMISSION_COUNTS_GLOBAL = "bitbucket.atst.permissions.permission-counts.global";
    private static final String PERMISSION_COUNTS_GROUP = "bitbucket.atst.permissions.permission-counts.group";
    private static final String PERMISSION_COUNTS_PROJECT = "bitbucket.atst.permissions.permission-counts.project";
    private static final String PERMISSION_COUNTS_REPOSITORY = "bitbucket.atst.permissions.permission-counts.repository";
    private static final String PERMISSION_COUNTS_USER = "bitbucket.atst.permissions.permission-counts.user";
    private static final String VOTER_PROVIDERS = "bitbucket.atst.permissions.voter-providers";
    private static final String VOTER_PROVIDER = "bitbucket.atst.permissions.voter-provider";
    private static final String VOTER_PROVIDER_CLASS = "bitbucket.atst.permissions.voter-provider.class";
    private static final String VOTER_PROVIDER_ENABLED = "bitbucket.atst.permissions.voter-provider.enabled";
    private static final String VOTER_PROVIDER_KEY = "bitbucket.atst.permissions.voter-provider.key";
    private static final String VOTER_PROVIDER_PLUGIN = "bitbucket.atst.permissions.voter-provider.plugin";
    private final DmzPermissionAdminService permissionAdminService;
    private final PermissionCacheStatisticsSummary permissionCacheStatisticsSummary;
    private final PluginAccessor pluginAccessor;

    public PermissionSupportData(DmzPermissionAdminService permissionAdminService, PermissionCacheStatisticsSummary permissionCacheStatisticsSummary, PluginAccessor pluginAccessor) {
        this.permissionAdminService = permissionAdminService;
        this.permissionCacheStatisticsSummary = permissionCacheStatisticsSummary;
        this.pluginAccessor = pluginAccessor;
    }

    protected void addSupportData(SupportDataBuilder supportDataBuilder) {
        SupportDataBuilder permissions = supportDataBuilder.addCategory(PERMISSIONS);
        this.addPermissionCounts(permissions.addCategory(PERMISSION_COUNTS));
        this.addCacheStatisticsSummary(permissions.addCategory(CACHE_STATISTICS));
        this.addVoterProviders(permissions.addCategory(VOTER_PROVIDERS));
    }

    private void addCacheStatistics(PermissionCacheStatistics statistics, SupportDataBuilder builder) {
        builder.addValue(CACHE_STATISTICS_HITS, Long.toString(statistics.getHits()));
        builder.addValue(CACHE_STATISTICS_LOADS, Long.toString(statistics.getLoads()));
        builder.addValue(CACHE_STATISTICS_MISSES, Long.toString(statistics.getMisses()));
        builder.addValue(CACHE_STATISTICS_INVALIDATIONS, Long.toString(statistics.getInvalidations()));
        builder.addValue(CACHE_STATISTICS_PARTIAL_INVALIDATIONS, Long.toString(statistics.getPartialInvalidations()));
        builder.addValue(CACHE_STATISTICS_SIZE, Long.toString(statistics.getSize()));
        builder.addValue(CACHE_STATISTICS_TOTAL_LOAD_TIME, Long.toString(statistics.getTotalLoadTime()));
    }

    private void addCacheStatisticsSummary(SupportDataBuilder builder) {
        this.addCacheStatistics(this.permissionCacheStatisticsSummary.getDefault(), builder.addCategory(CACHE_STATISTICS_DEFAULT));
        this.addCacheStatistics(this.permissionCacheStatisticsSummary.getGroup(), builder.addCategory(CACHE_STATISTICS_GROUP));
        this.addCacheStatistics(this.permissionCacheStatisticsSummary.getGroupMembership(), builder.addCategory(CACHE_STATISTICS_MEMBERSHIP));
        this.addCacheStatistics(this.permissionCacheStatisticsSummary.getUser(), builder.addCategory(CACHE_STATISTICS_USER));
    }

    private void addPermissionCounts(SupportDataBuilder builder) {
        this.addPermissionCounts(this.permissionAdminService.countGlobalPermissionsForAllUsers(), this.permissionAdminService.countGlobalPermissionsForAllGroups(), builder.addCategory(PERMISSION_COUNTS_GLOBAL));
        this.addPermissionCounts(this.permissionAdminService.countProjectPermissionsForAllUsers(), this.permissionAdminService.countProjectPermissionsForAllGroups(), builder.addCategory(PERMISSION_COUNTS_PROJECT));
        this.addPermissionCounts(this.permissionAdminService.countRepositoryPermissionsForAllUsers(), this.permissionAdminService.countRepositoryPermissionsForAllGroups(), builder.addCategory(PERMISSION_COUNTS_REPOSITORY));
    }

    private void addPermissionCounts(long user, long group, SupportDataBuilder builder) {
        builder.addValue(PERMISSION_COUNTS_USER, String.valueOf(user));
        builder.addValue(PERMISSION_COUNTS_GROUP, String.valueOf(group));
    }

    private void addVoterProviders(SupportDataBuilder providers) {
        Predicate<ModuleDescriptor> predicate = PermissionVoterProviderModuleDescriptor.class::isInstance;
        for (ModuleDescriptor descriptor : this.pluginAccessor.getModuleDescriptors(predicate)) {
            SupportDataBuilder provider = providers.addCategory(VOTER_PROVIDER).addValue(VOTER_PROVIDER_PLUGIN, descriptor.getPluginKey()).addValue(VOTER_PROVIDER_KEY, descriptor.getKey());
            if (descriptor.getModuleClass() != null) {
                provider.addValue(VOTER_PROVIDER_CLASS, descriptor.getModuleClass().getName());
            }
            provider.addValue(VOTER_PROVIDER_ENABLED, String.valueOf(descriptor.isEnabled()));
        }
    }
}

