/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.permission;

import com.atlassian.bitbucket.permission.PermissionCheck;
import com.atlassian.bitbucket.permission.PermissionVote;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.stash.internal.repository.RepositoryDao;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.springframework.transaction.support.TransactionTemplate;

class PublicAccessPermissionVoter
implements PermissionVoter {
    private final FeatureManager featureManager;
    private final RepositoryDao repositoryDao;
    private final TransactionTemplate transactionTemplate;

    PublicAccessPermissionVoter(FeatureManager featureManager, RepositoryDao repositoryDao, TransactionTemplate transactionTemplate) {
        this.featureManager = featureManager;
        this.repositoryDao = repositoryDao;
        this.transactionTemplate = transactionTemplate;
    }

    @Nonnull
    public PermissionVote vote(@Nonnull PermissionCheck check) {
        if (check.getResult() != PermissionVote.ABSTAIN || !this.featureManager.isEnabled((Feature)StandardFeature.PUBLIC_ACCESS)) {
            return PermissionVote.ABSTAIN;
        }
        switch (check.getPermission()) {
            case PROJECT_VIEW: {
                return this.getResourceAs(Project.class, check).filter(this::isProjectAccessible).map(project -> PermissionVote.GRANT).orElse(PermissionVote.ABSTAIN);
            }
            case REPO_READ: {
                return this.getResourceAs(Repository.class, check).filter(repo -> repo.isPublic() || repo.getProject().isPublic()).map(repo -> PermissionVote.GRANT).orElse(PermissionVote.ABSTAIN);
            }
        }
        return PermissionVote.ABSTAIN;
    }

    private <T> Optional<T> getResourceAs(Class<T> clazz, PermissionCheck check) {
        return check.getResource().filter(resource -> clazz.isAssignableFrom(resource.getClass())).map(clazz::cast);
    }

    private boolean isProjectAccessible(Project project) {
        if (project.isPublic()) {
            return true;
        }
        return (Boolean)this.transactionTemplate.execute(tx -> this.repositoryDao.countPublicByProject(project.getId()) > 0L);
    }
}

