/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.permission;

import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.permission.PermissionVoterProvider;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.permission.PublicAccessPermissionVoter;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import jakarta.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component
@Order(value=3)
public class PublicAccessPermissionVoterProvider
implements PermissionVoterProvider {
    private final FeatureManager featureManager;
    private final PublicAccessPermissionVoter voter;

    @Autowired
    public PublicAccessPermissionVoterProvider(FeatureManager featureManager, RepositoryDao repositoryDao, PlatformTransactionManager transactionManager) {
        this.featureManager = featureManager;
        TransactionTemplate inReadOnlyTx = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)0, (boolean)true));
        this.voter = new PublicAccessPermissionVoter(featureManager, repositoryDao, inReadOnlyTx);
    }

    public PermissionVoter create(@Nonnull Authentication authentication) {
        boolean activeUser = authentication.getUser().map(ApplicationUser::isActive).orElse(false);
        if (activeUser && this.featureManager.isEnabled((Feature)StandardFeature.PUBLIC_ACCESS)) {
            return this.voter;
        }
        return null;
    }
}

