/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.permission;

import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.dmz.crowd.BitbucketResourceType;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionCheck;
import com.atlassian.bitbucket.permission.PermissionVote;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class ServiceAccountPermissionVoter
implements PermissionVoter {
    private final Authentication authentication;

    public ServiceAccountPermissionVoter(Authentication authentication) {
        this.authentication = authentication;
    }

    @Nonnull
    public PermissionVote vote(@Nonnull PermissionCheck permissionCheck) {
        Permission permission = permissionCheck.getPermission();
        if (this.isPermissionImplied(permission) || !this.hasServiceAccountWithResourceRestrictions()) {
            return PermissionVote.ABSTAIN;
        }
        if (permissionCheck.getResource().isEmpty()) {
            return PermissionVote.VETO;
        }
        Object entity = permissionCheck.getResource().get();
        if (entity instanceof Project) {
            Project project = (Project)entity;
            if (this.getProtectedResourceIds(BitbucketResourceType.PROJECT).contains(project.getId())) {
                return PermissionVote.ABSTAIN;
            }
        } else if (entity instanceof Repository) {
            Repository repository = (Repository)entity;
            if (this.getProtectedResourceIds(BitbucketResourceType.REPOSITORY).contains(repository.getId())) {
                return PermissionVote.ABSTAIN;
            }
            if (this.getProtectedResourceIds(BitbucketResourceType.PROJECT).contains(repository.getProject().getId())) {
                return PermissionVote.ABSTAIN;
            }
        }
        return PermissionVote.VETO;
    }

    private Set<Integer> getProtectedResourceIds(@Nonnull BitbucketResourceType resourceType) {
        Set<Integer> resourceRestrictions = (Set<Integer>)this.authentication.getProperties().get(resourceType.name() + "-restrictions");
        return resourceRestrictions != null ? resourceRestrictions : Set.of();
    }

    private boolean hasServiceAccountWithResourceRestrictions() {
        Map properties = this.authentication.getProperties();
        if (!properties.containsKey("bbs.auth.service-account.id")) {
            return false;
        }
        return Arrays.stream(BitbucketResourceType.values()).anyMatch(resourceType -> properties.containsKey(resourceType.name() + "-restrictions"));
    }

    private boolean isPermissionImplied(Permission permission) {
        if (permission == Permission.LICENSED_USER) {
            return true;
        }
        if (permission == Permission.PROJECT_VIEW) {
            if (!this.hasServiceAccountWithResourceRestrictions()) {
                return true;
            }
            Set<Integer> projectIds = this.getProtectedResourceIds(BitbucketResourceType.PROJECT);
            return projectIds.isEmpty();
        }
        return false;
    }
}

