/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.permission;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionCheck;
import com.atlassian.bitbucket.permission.PermissionVote;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class SimplePermissionCheck
implements PermissionCheck {
    private final Permission permission;
    private final Object resource;
    private volatile PermissionVote result;

    private SimplePermissionCheck(Builder builder) {
        this.permission = builder.permission;
        this.resource = builder.resource;
        this.result = (PermissionVote)MoreObjects.firstNonNull((Object)builder.result, (Object)PermissionVote.ABSTAIN);
    }

    public static Builder builder(@Nonnull Permission permission) {
        return new Builder(permission);
    }

    @Nonnull
    public Permission getPermission() {
        return this.permission;
    }

    @Nonnull
    public Optional<Object> getResource() {
        return Optional.ofNullable(this.resource);
    }

    @Nonnull
    public PermissionVote getResult() {
        return this.result;
    }

    void addVote(PermissionVote vote) {
        this.result = PermissionVote.resultOf((PermissionVote[])new PermissionVote[]{this.result, vote});
    }

    public static class Builder {
        private final Permission permission;
        private Object resource;
        private PermissionVote result;

        public Builder(@Nonnull Permission permission) {
            this.permission = Objects.requireNonNull(permission, "permission");
        }

        @Nonnull
        public SimplePermissionCheck build() {
            return new SimplePermissionCheck(this);
        }

        @Nonnull
        public Builder resource(@Nullable Object resource) {
            if (resource instanceof Integer) {
                throw new IllegalArgumentException("Resource can not be an integer");
            }
            this.resource = resource;
            return this;
        }

        @Nonnull
        public Builder result(@Nullable PermissionVote value) {
            this.result = value;
            return this;
        }
    }
}

