/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.permission;

import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionCheck;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionVote;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.permission.PermissionVoterProvider;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import jakarta.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=4)
class UserAdminVoterProvider
implements PermissionVoterProvider {
    private final PermissionService permissionService;

    @Autowired
    UserAdminVoterProvider(@Lazy PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public PermissionVoter create(@Nonnull Authentication authentication) {
        return authentication.getUser().filter(ApplicationUser::isActive).map(x$0 -> new UserAdminVoter((ApplicationUser)x$0)).orElse(null);
    }

    private class UserAdminVoter
    implements PermissionVoter {
        private final Supplier<Permission> highestGlobalPermission;
        private final ApplicationUser requestingUser;

        private UserAdminVoter(ApplicationUser requestingUser) {
            this.requestingUser = requestingUser;
            this.highestGlobalPermission = Suppliers.memoize(() -> UserAdminVoterProvider.this.permissionService.getHighestGlobalPermission(requestingUser));
        }

        @Nonnull
        public PermissionVote vote(@Nonnull PermissionCheck check) {
            if (check.getPermission() != Permission.USER_ADMIN || check.getResult() != PermissionVote.ABSTAIN) {
                return PermissionVote.ABSTAIN;
            }
            ApplicationUser targetUser = check.getResource().filter(resource -> resource instanceof ApplicationUser).map(ApplicationUser.class::cast).orElse(null);
            if (targetUser == null) {
                return this.isSysadmin() ? PermissionVote.GRANT : PermissionVote.ABSTAIN;
            }
            if (targetUser.getId() == this.requestingUser.getId()) {
                return PermissionVote.GRANT;
            }
            if (this.isSysadmin()) {
                return PermissionVote.GRANT;
            }
            if (this.isAdmin() && !UserAdminVoterProvider.this.permissionService.hasGlobalPermission(targetUser, Permission.SYS_ADMIN)) {
                return PermissionVote.GRANT;
            }
            return PermissionVote.ABSTAIN;
        }

        private boolean isAdmin() {
            Permission permission = (Permission)this.highestGlobalPermission.get();
            return permission != null && (permission == Permission.ADMIN || permission.getInheritedPermissions().contains(Permission.ADMIN));
        }

        private boolean isSysadmin() {
            Permission permission = (Permission)this.highestGlobalPermission.get();
            return permission != null && (permission == Permission.SYS_ADMIN || permission.getInheritedPermissions().contains(Permission.SYS_ADMIN));
        }
    }
}

