/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.ui.ContextualFormFragment;
import com.atlassian.bitbucket.ui.PluginFormFragments;
import com.atlassian.bitbucket.ui.PluginFormFragmentsFactory;
import com.atlassian.bitbucket.ui.ValidationErrors;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.view.ViewStreamIOException;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.web.Condition;
import com.atlassian.stash.internal.plugin.FormFragmentModuleDescriptor;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=PluginFormFragmentsFactory.class)
@Component(value="pluginFormFragmentsFactory")
public class PluginFormFragmentsFactoryImpl
implements PluginFormFragmentsFactory {
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginFormFragmentsFactoryImpl(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public boolean existsForKey(@Nonnull String formKey) {
        Objects.requireNonNull(formKey, "formKey");
        return this.getFormFragmentDescriptors().stream().map(FormFragmentModuleDescriptor::getLocation).anyMatch(formKey::equals);
    }

    @Nonnull
    public PluginFormFragments forKey(@Nonnull String formKey, @Nonnull Map<String, Object> context) {
        Objects.requireNonNull(formKey, "formKey");
        Objects.requireNonNull(context, "context");
        Stream<FormFragmentModuleDescriptor> descriptors = this.getFormFragmentDescriptors().stream().filter(descriptor -> {
            if (formKey.equals(descriptor.getLocation())) {
                Condition condition = descriptor.getCondition();
                return condition == null || condition.shouldDisplay(Collections.unmodifiableMap(context));
            }
            return false;
        });
        return new PluginFormFragmentsImpl((Iterable)ModuleDescriptorUtils.toSortedModules(descriptors).collect(MoreCollectors.toImmutableList()), context);
    }

    private List<FormFragmentModuleDescriptor> getFormFragmentDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(FormFragmentModuleDescriptor.class);
    }

    private static class PluginFormFragmentsImpl
    implements PluginFormFragments {
        private final Map<String, Object> context;
        private final Iterable<ContextualFormFragment> formFragments;

        private PluginFormFragmentsImpl(Iterable<ContextualFormFragment> formFragments, Map<String, Object> context) {
            this.context = context;
            this.formFragments = formFragments;
        }

        public void execute(@Nonnull Map<String, String[]> requestParams) {
            this.formFragments.forEach(fragment -> fragment.execute(requestParams, this.newContext()));
        }

        @Nonnull
        public String getErrorHtml(@Nonnull Map<String, String[]> requestParams, @Nonnull Map<String, Collection<String>> fieldErrors) {
            StringBuilder fieldsHtml = new StringBuilder();
            for (ContextualFormFragment fragment : this.formFragments) {
                try {
                    fragment.doError((Appendable)fieldsHtml, requestParams, fieldErrors, this.newContext());
                }
                catch (IOException e) {
                    throw new ViewStreamIOException("Failed to render FormFragment doError: " + String.valueOf(fragment), (Throwable)e);
                }
            }
            return fieldsHtml.toString();
        }

        @Nonnull
        public String getViewHtml() {
            StringBuilder fieldsHtml = new StringBuilder();
            for (ContextualFormFragment fragment : this.formFragments) {
                try {
                    fragment.doView((Appendable)fieldsHtml, this.newContext());
                }
                catch (IOException e) {
                    throw new ViewStreamIOException("Failed to render FormFragment doView: " + String.valueOf(fragment), (Throwable)e);
                }
            }
            return fieldsHtml.toString();
        }

        public void validate(@Nonnull Map<String, String[]> requestParams, @Nonnull ValidationErrors errors) {
            this.formFragments.forEach(fragment -> fragment.validate(requestParams, errors, this.newContext()));
        }

        private Map<String, Object> newContext() {
            return new HashMap<String, Object>(this.context);
        }
    }
}

