/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.policy;

import com.atlassian.bitbucket.dmz.policy.DmzPolicyService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=DmzPolicyService.class)
@Service(value="policyService")
public class DefaultPolicyService
implements DmzPolicyService {
    private I18nService i18nService;
    private PermissionValidationService permissionValidationService;
    private InternalApplicationPropertiesService propertiesService;
    private List<Permission> repoManagementPermissions = ImmutableList.of((Object)Permission.SYS_ADMIN, (Object)Permission.ADMIN, (Object)Permission.PROJECT_ADMIN, (Object)Permission.REPO_ADMIN);

    @Autowired
    public DefaultPolicyService(PermissionValidationService permissionValidationService, InternalApplicationPropertiesService propertiesService, I18nService i18nService) {
        this.i18nService = i18nService;
        this.propertiesService = propertiesService;
        this.permissionValidationService = permissionValidationService;
    }

    @Nonnull
    public Permission getRepositoryArchivePolicy() {
        this.permissionValidationService.validateForGlobal(Permission.LICENSED_USER);
        return this.propertiesService.getRepositoryArchivePolicy();
    }

    @Nonnull
    public Permission getRepositoryDeletePolicy() {
        this.permissionValidationService.validateForGlobal(Permission.LICENSED_USER);
        return this.propertiesService.getRepositoryDeletePolicy();
    }

    public void setRepositoryArchivePolicy(@Nonnull Permission permission) {
        Objects.requireNonNull(permission, "permission");
        this.setPolicy(permission, "bitbucket.rest.policies.invalid.repo.archive.permission", p -> this.propertiesService.setRepositoryArchivePolicy(p));
    }

    public void setRepositoryDeletePolicy(@Nonnull Permission permission) {
        Objects.requireNonNull(permission, "permission");
        this.setPolicy(permission, "bitbucket.rest.policies.invalid.repo.delete.permission", p -> this.propertiesService.setRepositoryDeletePolicy(p));
    }

    private void setPolicy(Permission permission, String i18nErrorMessage, Consumer<Permission> consumer) {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        if (!this.repoManagementPermissions.contains(permission)) {
            throw new IllegalArgumentException(this.i18nService.getMessage(i18nErrorMessage, new Object[0]));
        }
        consumer.accept(permission);
    }
}

