/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.project;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.avatar.AvatarSupplier;
import com.atlassian.bitbucket.avatar.CacheableAvatarSupplier;
import com.atlassian.bitbucket.event.permission.ProjectPermissionGrantedEvent;
import com.atlassian.bitbucket.event.project.ProjectAvatarUpdatedEvent;
import com.atlassian.bitbucket.event.project.ProjectCreatedEvent;
import com.atlassian.bitbucket.event.project.ProjectCreationRequestedEvent;
import com.atlassian.bitbucket.event.project.ProjectDeletedEvent;
import com.atlassian.bitbucket.event.project.ProjectDeletionRequestedEvent;
import com.atlassian.bitbucket.event.project.ProjectImportedEvent;
import com.atlassian.bitbucket.event.project.ProjectModificationRequestedEvent;
import com.atlassian.bitbucket.event.project.ProjectModifiedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionPredicateFactory;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.AbstractVoidProjectVisitor;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectCreateRequest;
import com.atlassian.bitbucket.project.ProjectCreationCanceledException;
import com.atlassian.bitbucket.project.ProjectDeletionCanceledException;
import com.atlassian.bitbucket.project.ProjectModificationCanceledException;
import com.atlassian.bitbucket.project.ProjectMovedException;
import com.atlassian.bitbucket.project.ProjectSearchRequest;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.project.ProjectSupplier;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.project.ProjectUpdateRequest;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.CancelState;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.SimpleCancelState;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.bitbucket.validation.groups.Create;
import com.atlassian.bitbucket.validation.groups.TrustedCreate;
import com.atlassian.bitbucket.validation.groups.TrustedUpdate;
import com.atlassian.bitbucket.validation.groups.Update;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.avatar.DataUriAvatarMetaSupplier;
import com.atlassian.stash.internal.avatar.InternalAvatarService;
import com.atlassian.stash.internal.project.InternalNormalProject;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.project.InternalProjectAlias;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.project.ProjectAliasDao;
import com.atlassian.stash.internal.project.ProjectDao;
import com.atlassian.stash.internal.repository.RepositoryAliasDao;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.ApplicationUserDao;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalProjectPermission;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.atlassian.stash.internal.user.ProjectPermissionDao;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.validation.Validator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(interfaces={ProjectService.class, ProjectSupplier.class})
@Service(value="projectService")
public class DefaultProjectService
extends AbstractService
implements InternalProjectService {
    private static final Logger log = LoggerFactory.getLogger(DefaultProjectService.class);
    private final AuthenticationContext authenticationContext;
    private final InternalAvatarService avatarService;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final ApplicationMode mode;
    private final ProjectPermissionDao permissionDao;
    private final PermissionService permissionService;
    private final PermissionPredicateFactory predicateFactory;
    private final ProjectAliasDao projectAliasDao;
    private final ProjectDao projectDao;
    private final RepositoryAliasDao repositoryAliasDao;
    private final SecurityService securityService;
    private final TransactionTemplate transactionTemplate;
    private final ApplicationUserDao userDao;
    private final UserService userService;
    private final Validator validator;
    private int maxProjects;

    @Autowired
    public DefaultProjectService(AuthenticationContext authenticationContext, InternalAvatarService avatarService, EventPublisher eventPublisher, I18nService i18nService, @Value(value="#{applicationPropertiesService.mode}") ApplicationMode mode, PermissionService permissionService, ProjectPermissionDao permissionDao, PermissionPredicateFactory predicateFactory, ProjectAliasDao projectAliasDao, ProjectDao projectDao, RepositoryAliasDao repositoryAliasDao, SecurityService securityService, PlatformTransactionManager transactionManager, ApplicationUserDao userDao, UserService userService, Validator validator) {
        this.mode = mode;
        this.authenticationContext = authenticationContext;
        this.avatarService = avatarService;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionDao = permissionDao;
        this.permissionService = permissionService;
        this.predicateFactory = predicateFactory;
        this.projectDao = projectDao;
        this.projectAliasDao = projectAliasDao;
        this.repositoryAliasDao = repositoryAliasDao;
        this.securityService = securityService;
        this.userDao = userDao;
        this.userService = userService;
        this.validator = validator;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('PROJECT_CREATE')")
    @Transactional
    public InternalProject create(@Nonnull ProjectCreateRequest request) {
        Objects.requireNonNull(request, "request");
        InternalProject project = this.validateProjectCreationRequest(request);
        this.fireProjectCreationRequested((Project)project);
        InternalProject created = this.internalCreateProject(project, this.getAvatarSupplier(request));
        this.grantProjectAdmin(project, this.authenticationContext.getCurrentUser());
        this.fireProjectCreated((Project)project);
        return created;
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    @Transactional
    public boolean delete(Project project) {
        InternalProject internalProject = (InternalProject)this.projectDao.getById((Object)project.getId());
        if (internalProject == null) {
            return false;
        }
        if (project.getType() == ProjectType.PERSONAL) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.project.personal.notdeletable", new Object[0]));
        }
        if (this.projectDao.hasRepositories(internalProject.getId())) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.project.notempty", new Object[]{internalProject.getKey()});
            throw new IntegrityException(message);
        }
        this.fireProjectDeletionRequested(project);
        this.projectDao.delete((Object)internalProject);
        this.eventPublisher.publish((Object)new ProjectDeletedEvent((Object)this, project));
        return true;
    }

    @Nonnull
    @Secured(value="Secured using a project accessible predicate")
    public Page<Project> findAll(@Nonnull PageRequest pageRequest) {
        PageRequest restrictedPageRequest = pageRequest.buildRestrictedPageRequest(this.maxProjects);
        return PageUtils.asPageOf(Project.class, (Page)this.projectDao.findAll(restrictedPageRequest, this.predicateFactory.createProjectAccessiblePredicate()));
    }

    @Nonnull
    @Secured(value="Secured using a predicate")
    public List<String> findAllKeys() {
        Predicate predicate = this.predicateFactory.createProjectAccessiblePredicate();
        return this.projectDao.findAllKeys(predicate);
    }

    @Nonnull
    @PostAuthorize(value="isProjectAccessible(#projectId)")
    public CacheableAvatarSupplier getAvatar(int projectId, int size) {
        InternalProject project = this.getProjectOrFail(projectId);
        return this.avatarService.getForProject((Project)project, size);
    }

    @PostAuthorize(value="isProjectAccessible(returnObject)")
    public InternalProject getById(int id) {
        return (InternalProject)this.projectDao.getById((Object)id);
    }

    @PostAuthorize(value="isProjectAccessible(returnObject)")
    @Transactional(readOnly=true, noRollbackFor={ProjectMovedException.class})
    public InternalProject getByKey(@Nonnull String key) {
        InternalProjectAlias alias;
        Objects.requireNonNull(key, "key");
        InternalProject project = this.projectDao.getByKey(key);
        if (project == null && (alias = this.projectAliasDao.getByKey(key)) != null && this.permissionService.isProjectAccessible((Project)alias.getProject())) {
            throw new ProjectMovedException((Project)alias.getProject(), alias.getKey(), this.i18nService.createKeyedMessage("bitbucket.project.moved", new Object[]{alias.getProject().getKey()}));
        }
        if (this.mode == ApplicationMode.MIRROR || !this.authenticationContext.isAuthenticated()) {
            return project;
        }
        if (project != null) {
            project.accept((ProjectVisitor)new AbstractVoidProjectVisitor(){

                protected void doVisit(@Nonnull PersonalProject personalProject) {
                    if (DefaultProjectService.this.isOwnerAndMissingAdmin(personalProject)) {
                        log.debug("User {} does not have {} for their personal project; restoring", (Object)personalProject.getOwner().getName(), (Object)Permission.PROJECT_ADMIN);
                        DefaultProjectService.this.transactionTemplate.execute(status -> {
                            DefaultProjectService.this.grantProjectAdminToOwner((InternalPersonalProject)personalProject);
                            return null;
                        });
                    }
                }
            });
            return project;
        }
        String slug = InternalPersonalProject.getPersonalProjectOwner((String)key);
        if (slug == null) {
            return null;
        }
        ApplicationUser user = this.userService.getUserBySlug(slug);
        if (user == null) {
            return null;
        }
        return (InternalProject)this.transactionTemplate.execute(status -> this.getOrCreatePersonalProject(user, true));
    }

    @PostAuthorize(value="isProjectAccessible(returnObject)")
    public InternalProject getByName(@Nonnull String name) {
        Objects.requireNonNull(name, "name");
        return this.projectDao.getByName(name);
    }

    @Unsecured(value="Internal service method, this method is also exposed via JMX")
    public long getCount() {
        return this.projectDao.countAll();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    @Transactional
    public InternalPersonalProject getPersonalProject() {
        return this.getPersonalProject(true);
    }

    @Nonnull
    @PostAuthorize(value="hasGlobalPermission('LICENSED_USER') or isProjectAccessible(returnObject)")
    @Transactional
    public InternalPersonalProject getPersonalProject(@Nonnull ApplicationUser user) {
        return this.getOrCreatePersonalProject(Objects.requireNonNull(user, "user"), true);
    }

    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    @Transactional
    public InternalPersonalProject getPersonalProject(boolean create) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.project.personal.anonymous", new Object[0]));
        }
        return this.getOrCreatePersonalProject(currentUser, create);
    }

    @Nonnull
    @Transactional
    @Unsecured(value="This is an internal method")
    public InternalProject importProject(@Nonnull ProjectCreateRequest request) {
        Objects.requireNonNull(request, "request");
        InternalProject project = this.validateProjectCreationRequest(request);
        InternalProject created = this.internalCreateProject(project, this.getAvatarSupplier(request));
        this.fireProjectImported((Project)project);
        return created;
    }

    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public boolean isPersonalProject(@Nonnull String projectKey) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        return currentUser != null && currentUser.getName().equalsIgnoreCase(InternalPersonalProject.getPersonalProjectOwner((String)projectKey));
    }

    @Nonnull
    @Secured(value="Secured using a predicate for (at least) project accessible checks")
    public Page<Project> search(@Nonnull ProjectSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(searchRequest, "searchRequest");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxProjects);
        Predicate permissionPredicate = searchRequest.hasPermission() ? this.predicateFactory.createProjectPermissionPredicate(searchRequest.getPermission()) : this.predicateFactory.createProjectAccessiblePredicate();
        return PageUtils.asPageOf(Project.class, (Page)this.projectDao.search(searchRequest, pageRequest, permissionPredicate));
    }

    @Value(value="${page.max.projects}")
    public void setMaxProjects(int maxProjects) {
        this.maxProjects = maxProjects;
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasProjectPermission(#request.id, 'PROJECT_ADMIN')")
    public InternalProject update(@Nonnull ProjectUpdateRequest request) {
        Objects.requireNonNull(request, "request");
        InternalNormalProject project = (InternalNormalProject)HibernateUtils.tryCast((Object)this.getProjectOrFail(request.getId()), InternalNormalProject.class);
        if (project == null) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.project.personal.detailsunmodifiable", new Object[0]));
        }
        InternalNormalProject current = project.copy().build();
        InternalNormalProject updated = current.copy().description(request.getDescription()).key(request.getKey()).name(request.getName()).publiclyAccessible(request.isPublic()).build();
        ValidationUtils.validate((Validator)this.validator, (Object)updated, (Class[])new Class[]{this.isMirrorMode() ? TrustedUpdate.class : Update.class});
        this.fireProjectModificationRequested((Project)current, (Project)updated);
        updated = (InternalProject)this.projectDao.update((Object)updated);
        if (!StringUtils.equalsIgnoreCase((CharSequence)current.getKey(), (CharSequence)updated.getKey()) && !InternalPersonalProject.isPersonalProjectKey((String)updated.getKey())) {
            this.projectAliasDao.create((Object)new InternalProjectAlias.Builder((InternalProject)updated).key(current.getKey()).build());
            this.repositoryAliasDao.createAllForProject((InternalProject)updated, current.getKey());
        }
        this.eventPublisher.publish((Object)new ProjectModifiedEvent((Object)this, (Project)current, (Project)updated));
        return updated;
    }

    @PreAuthorize(value="hasProjectPermission(#projectId, 'PROJECT_ADMIN')")
    public void updateAvatar(int projectId, @Nonnull AvatarSupplier supplier) {
        Objects.requireNonNull(supplier, "supplier");
        this.doUpdateAvatar(projectId, () -> supplier);
    }

    @PreAuthorize(value="hasProjectPermission(#projectId, 'PROJECT_ADMIN')")
    public void updateAvatar(int projectId, @Nonnull String uri) {
        Preconditions.checkArgument((!Objects.requireNonNull(uri, "uri").trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank data URI is required");
        this.doUpdateAvatar(projectId, new DataUriAvatarMetaSupplier(this.avatarService, uri));
    }

    @Transactional
    @Unsecured(value="This is an internal method")
    public void updatePersonalProject(@Nonnull ApplicationUser user) {
        Objects.requireNonNull(user, "user");
        InternalPersonalProject project = this.projectDao.getByOwner(user.getId());
        if (project != null) {
            InternalNormalUser projectOwner = project.getOwner();
            InternalPersonalProject current = project.copy().build();
            InternalPersonalProject updated = current.copy().owner(projectOwner).build();
            if (!current.getKey().equals(updated.getKey())) {
                updated = (InternalProject)this.projectDao.update((Object)updated);
                this.eventPublisher.publish((Object)new ProjectModifiedEvent((Object)this, (Project)current, (Project)updated));
            }
        }
    }

    private void doUpdateAvatar(int projectId, Supplier<AvatarSupplier> metaSupplier) {
        InternalProject project = this.getProjectOrFail(projectId);
        if (project.getType() == ProjectType.PERSONAL) {
            if (this.avatarService.isEnabled()) {
                throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.project.personal.avatarunmodifiable.usegravatar", new Object[]{Product.NAME}));
            }
            throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.project.personal.avatarunmodifiable", new Object[0]));
        }
        this.avatarService.saveForProject((Project)project, metaSupplier.get());
        this.eventPublisher.publish((Object)new ProjectAvatarUpdatedEvent((Object)this, (Project)project));
    }

    private void fireProjectCreated(Project project) {
        this.eventPublisher.publish((Object)new ProjectCreatedEvent((Object)this, project));
    }

    private void fireProjectCreationRequested(Project project) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new ProjectCreationRequestedEvent((Object)this, project, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.project.creationcanceled", new Object[0]);
            throw new ProjectCreationCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireProjectDeletionRequested(Project project) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new ProjectDeletionRequestedEvent((Object)this, project, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.project.deletioncanceled", new Object[0]);
            throw new ProjectDeletionCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireProjectImported(Project project) {
        this.eventPublisher.publish((Object)new ProjectImportedEvent((Object)this, project));
    }

    private void fireProjectModificationRequested(Project current, Project updated) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new ProjectModificationRequestedEvent((Object)this, current, updated, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.project.updatedcanceled", new Object[0]);
            throw new ProjectModificationCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private Supplier<AvatarSupplier> getAvatarSupplier(ProjectCreateRequest request) {
        if (request.getAvatar() != null) {
            return () -> ((ProjectCreateRequest)request).getAvatar();
        }
        if (StringUtils.isNotBlank((CharSequence)request.getAvatarUri())) {
            return new DataUriAvatarMetaSupplier(this.avatarService, request.getAvatarUri());
        }
        return () -> null;
    }

    private InternalPersonalProject getOrCreatePersonalProject(ApplicationUser user, boolean create) {
        InternalPersonalProject project = this.projectDao.getByOwner(user.getId());
        if (project == null) {
            if (create) {
                project = new InternalPersonalProject.Builder().owner((InternalNormalUser)InternalConverter.convertToInternalUser((ApplicationUser)user).accept((InternalStashUserVisitor)InternalNormalUser.TO_NORMAL_USER)).build();
                project = this.projectDao.createPersonal(project);
                log.debug("Created personal project {}", (Object)project.getKey());
                this.grantProjectAdminToOwner(project);
                this.fireProjectCreated((Project)project);
            } else {
                log.debug("User {} does not yet have a personal project, and one has not been created", (Object)user.getName());
            }
        } else if (this.isOwnerAndMissingAdmin((PersonalProject)project)) {
            log.debug("User {} does not have {} for their personal project; restoring", (Object)user.getName(), (Object)Permission.PROJECT_ADMIN);
            this.grantProjectAdminToOwner(project);
        }
        return project;
    }

    @Nonnull
    private InternalProject getProjectOrFail(int projectId) {
        InternalProject project = this.getById(projectId);
        if (project == null) {
            throw new NoSuchProjectException(this.i18nService.createKeyedMessage("bitbucket.service.project.nosuchid", new Object[]{projectId}));
        }
        return project;
    }

    private void grantProjectAdmin(InternalProject project, ApplicationUser user) {
        InternalProjectPermission permission = ((InternalProjectPermission.Builder)((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(Permission.PROJECT_ADMIN)).project(project).user(InternalConverter.convertToInternalUser((ApplicationUser)user))).build();
        this.permissionDao.create((Object)permission);
        this.eventPublisher.publish((Object)new ProjectPermissionGrantedEvent((Object)this, Permission.PROJECT_ADMIN, (Project)project, null, user));
        log.debug("Granted {} to {} for project {}", new Object[]{Permission.PROJECT_ADMIN, user.getName(), project.getKey()});
    }

    private void grantProjectAdminToOwner(InternalPersonalProject project) {
        this.grantProjectAdmin((InternalProject)project, (ApplicationUser)project.getOwner());
    }

    @Nonnull
    private InternalProject internalCreateProject(@Nonnull InternalProject project, @Nonnull Supplier<AvatarSupplier> metaSupplier) {
        InternalProject created = (InternalProject)this.projectDao.create((Object)project);
        this.projectAliasDao.deleteByKey(project.getKey());
        log.info("Created new project: ({}) {}", (Object)project.getKey(), (Object)project.getName());
        this.securityService.withPermission(Permission.PROJECT_ADMIN, "Creating project with avatar").call(() -> {
            AvatarSupplier supplier = (AvatarSupplier)metaSupplier.get();
            if (supplier != null) {
                this.avatarService.saveForProject((Project)created, supplier);
            }
            return null;
        });
        return created;
    }

    private boolean isMirrorMode() {
        return this.mode == ApplicationMode.MIRROR;
    }

    private boolean isOwnerAndMissingAdmin(PersonalProject project) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null) {
            return false;
        }
        ApplicationUser owner = project.getOwner();
        return currentUser.equals((Object)owner) && !this.permissionDao.isGrantedToUser(owner.getId(), project.getId(), Permission.PROJECT_ADMIN);
    }

    private InternalProject validateProjectCreationRequest(@Nonnull ProjectCreateRequest request) {
        InternalNormalProject project = new InternalNormalProject.Builder().description(request.getDescription()).key(request.getKey()).name(request.getName()).publiclyAccessible(request.isPublic()).build();
        ValidationUtils.validate((Validator)this.validator, (Object)project, (Class[])new Class[]{this.isMirrorMode() ? TrustedCreate.class : Create.class});
        return project;
    }
}

