/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.project;

import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.stash.internal.atst.SupportDataConstraints;
import com.atlassian.stash.internal.atst.SupportDataHelper;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.repository.InternalRepositoryService;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import com.atlassian.troubleshooting.spi.SupportDataDetail;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="projectSupportData")
public class ProjectSupportData
extends RootLevelSupportDataAppender {
    public static final String PROJECT = "bitbucket.atst.project";
    public static final String PROJECT_KEY = "bitbucket.atst.project.key";
    private static final String COUNT = "bitbucket.atst.count";
    private static final String PROJECT_DESCRIPTION = "bitbucket.atst.project.description";
    private static final String PROJECT_ID = "bitbucket.atst.project.id";
    private static final String PROJECT_IS_PUBLIC = "bitbucket.atst.project.is.public";
    private static final String PROJECT_MARKED_AS_PUBLIC = "bitbucket.atst.project.marked.public";
    private static final String PROJECT_NAME = "bitbucket.atst.project.name";
    private static final String PROJECT_SKIPPED = "bitbucket.atst.skipped";
    private static final String PROJECTS = "bitbucket.atst.projects";
    private final PermissionService permissionService;
    private final InternalProjectService projectService;
    private final InternalRepositoryService repositoryService;
    private final SupportDataHelper supportDataHelper;

    @Autowired
    public ProjectSupportData(PermissionService permissionService, InternalProjectService projectService, InternalRepositoryService repositoryService, SupportDataHelper supportDataHelper) {
        this.permissionService = permissionService;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
        this.supportDataHelper = supportDataHelper;
    }

    protected void addSupportData(SupportDataBuilder supportDataBuilder) {
        if (supportDataBuilder.getBuilderContext().getRequestDetail() == SupportDataDetail.FULL) {
            this.addProjectSummary(supportDataBuilder);
            this.addProjects(supportDataBuilder);
        } else {
            this.addProjectSummary(supportDataBuilder);
        }
    }

    private void addProjectSummary(SupportDataBuilder builder) {
        long projects = this.projectService.getCount();
        long repositories = this.repositoryService.getCount();
        builder.addCategory(PROJECTS).addValue(COUNT, Long.toString(projects));
        builder.addCategory("bitbucket.atst.repositories").addValue(COUNT, Long.toString(repositories));
    }

    private void addProjects(SupportDataBuilder builder) {
        SupportDataConstraints constraints = this.supportDataHelper.getConstraints(builder.getBuilderContext());
        for (Project project : new PagedIterable(arg_0 -> ((InternalProjectService)this.projectService).findAll(arg_0), 500)) {
            SupportDataBuilder projectBuilder = builder.addCategory(PROJECT).addValue(PROJECT_ID, Integer.toString(project.getId())).addValue(PROJECT_KEY, project.getKey());
            if (constraints.addProject()) {
                projectBuilder.addValue(PROJECT_NAME, project.getName()).addValue(PROJECT_DESCRIPTION, project.getDescription()).addValue(PROJECT_MARKED_AS_PUBLIC, Boolean.toString(project.isPublic())).addValue(PROJECT_IS_PUBLIC, Boolean.toString(this.permissionService.isPubliclyAccessible(project))).addContext((Object)project);
                continue;
            }
            projectBuilder.addValue(PROJECT_SKIPPED, Boolean.TRUE.toString());
        }
    }
}

