/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.dmz.event.pull.DmzPullRequestMergedEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@AsynchronousPreferred
@EventName(value="stash.pullrequest.merged")
public class AnalyticsPullRequestMergedEvent
extends DmzPullRequestMergedEvent {
    private final Duration duration;

    public AnalyticsPullRequestMergedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest) {
        super(source, pullRequest);
        this.duration = null;
    }

    public AnalyticsPullRequestMergedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nullable MinimalCommit commit, @Nullable String message, @Nullable String strategyId, boolean autoMerge, boolean queuedMerge, @Nonnull Duration duration) {
        super(source, pullRequest, commit, message, strategyId, autoMerge, queuedMerge);
        this.duration = Objects.requireNonNull(duration, "duration");
    }

    public int getCustomMessageLength() {
        String message = this.getMessage();
        return message == null ? 0 : message.length();
    }

    public Optional<Long> getDuration() {
        return this.duration == null ? Optional.empty() : Optional.of(this.duration.toMillis());
    }
}

