/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.hook.repository.SimplePullRequestMergeHookRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeOutcome;
import com.atlassian.bitbucket.pull.PullRequestMergeResult;
import com.atlassian.bitbucket.pull.PullRequestMergeVeto;
import com.atlassian.bitbucket.pull.PullRequestMergeability;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.pull.MergeRequestCheckService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.pull.InternalMergeRequest;
import com.atlassian.stash.internal.pull.InternalMergeRequestCheckService;
import com.atlassian.stash.internal.pull.PullRequestEnricher;
import com.atlassian.stash.internal.pull.SimpleMergeRequest;
import com.atlassian.stash.internal.pull.SimplePullRequestMergeVeto;
import com.atlassian.stash.internal.pull.SimplePullRequestMergeability;
import com.atlassian.stash.internal.pull.automerge.AutoMergeRequestDao;
import com.atlassian.stash.internal.pull.automerge.InternalAutoMergeRequest;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=MergeRequestCheckService.class)
@Service(value="mergeRequestCheckService")
@Transactional(readOnly=true)
public class DefaultMergeRequestCheckService
implements InternalMergeRequestCheckService {
    private final AutoMergeRequestDao autoMergeRequestDao;
    private final PullRequestEnricher enricher;
    private final RepositoryHookService repositoryHookService;
    private final ScmService scmService;

    @Autowired
    public DefaultMergeRequestCheckService(PullRequestEnricher enricher, RepositoryHookService repositoryHookService, ScmService scmService, AutoMergeRequestDao autoMergeRequestDao) {
        this.autoMergeRequestDao = autoMergeRequestDao;
        this.enricher = enricher;
        this.repositoryHookService = repositoryHookService;
        this.scmService = scmService;
    }

    @Nonnull
    public Collection<PullRequestMergeVeto> check(@Nonnull PullRequest pullRequest) {
        return this.doCheck(new SimpleMergeRequest.Builder(pullRequest).build());
    }

    @Nonnull
    public PullRequestMergeability checkMergeability(@Nonnull InternalMergeRequest mergeRequest) {
        Collection<PullRequestMergeVeto> vetoes = this.doCheck(mergeRequest);
        PullRequestMergeOutcome outcome = Optional.ofNullable(this.tryMerge(mergeRequest.getPullRequest())).map(PullRequestMergeResult::getOutcome).orElse(PullRequestMergeOutcome.UNKNOWN);
        return this.enricher.enrich(InternalConverter.convertToInternalPullRequest((PullRequest)mergeRequest.getPullRequest()), new SimplePullRequestMergeability(outcome, vetoes));
    }

    private Collection<PullRequestMergeVeto> doCheck(InternalMergeRequest mergeRequest) {
        InternalAutoMergeRequest autoMergeRequest = this.autoMergeRequestDao.getByPullRequest(InternalConverter.convertToInternalPullRequest((PullRequest)mergeRequest.getPullRequest()));
        SimplePullRequestMergeHookRequest hookRequest = ((SimplePullRequestMergeHookRequest.Builder)new SimplePullRequestMergeHookRequest.Builder(mergeRequest.getPullRequest(), mergeRequest.isAbortOnFirstVeto()).autoMerge(autoMergeRequest != null).dryRun(mergeRequest.isDryRun())).message(mergeRequest.getMessage()).build();
        RepositoryHookResult result = this.repositoryHookService.preUpdate((RepositoryHookRequest)hookRequest);
        return (Collection)result.getVetoes().stream().map(veto -> new SimplePullRequestMergeVeto(veto.getSummaryMessage(), veto.getDetailedMessage())).collect(MoreCollectors.toImmutableList());
    }

    private PullRequestMergeResult tryMerge(PullRequest pullRequest) {
        return (PullRequestMergeResult)this.scmService.getPullRequestCommandFactory(pullRequest).tryMerge(pullRequest).call();
    }
}

