/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.dmz.pull.DmzPullRequestCommitMessageTemplateRenderer;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.pull.PullRequestCommitMessageTemplateVariable;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.pull.PullRequestCommitMessageTemplateVariableSubstitutor;
import com.atlassian.stash.internal.pull.SimplePullRequestCommitMessageTemplate;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=DmzPullRequestCommitMessageTemplateRenderer.class)
@Service(value="pullRequestCommitMessageTemplateRenderer")
public class DefaultPullRequestCommitMessageTemplateRenderer
implements DmzPullRequestCommitMessageTemplateRenderer {
    private static final PullRequestCommitMessageTemplate DEFAULT_COMMIT_MESSAGE_TEMPLATE = new SimplePullRequestCommitMessageTemplate.Builder(String.format("Pull request #%s: %s", PullRequestCommitMessageTemplateVariable.ID, PullRequestCommitMessageTemplateVariable.TITLE)).body(String.format("Merge in %s/%s from %s%s to %s", PullRequestCommitMessageTemplateVariable.TO_PROJECT_KEY, PullRequestCommitMessageTemplateVariable.TO_REPO_SLUG, PullRequestCommitMessageTemplateVariable.CROSS_REPO_PR_REPO, PullRequestCommitMessageTemplateVariable.FROM_REF_NAME, PullRequestCommitMessageTemplateVariable.TO_REF_NAME)).build();
    private final PullRequestCommitMessageTemplateVariableSubstitutor variableSubstitutor;

    public DefaultPullRequestCommitMessageTemplateRenderer(PullRequestCommitMessageTemplateVariableSubstitutor pullRequestCommitMessageTemplateVariableSubstitutor) {
        this.variableSubstitutor = pullRequestCommitMessageTemplateVariableSubstitutor;
    }

    @Nonnull
    public PullRequestCommitMessageTemplate getDefaultCommitMessageTemplate() {
        return DEFAULT_COMMIT_MESSAGE_TEMPLATE;
    }

    @Nonnull
    public String renderBody(@Nonnull PullRequestCommitMessageTemplate template, @Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(template, "template");
        Objects.requireNonNull(pullRequest, "pullRequest");
        return this.variableSubstitutor.substituteVariables(template.getBody(), pullRequest);
    }

    @Nonnull
    public String renderTitle(@Nonnull PullRequestCommitMessageTemplate template, @Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(template, "template");
        Objects.requireNonNull(pullRequest, "pullRequest");
        return this.variableSubstitutor.substituteVariables(template.getTitle(), pullRequest);
    }
}

