/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.dmz.pull.PullRequestMergeConfigRestrictionEnricher;
import com.atlassian.bitbucket.dmz.pull.RestrictedPullRequestMergeConfig;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionState;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.PullRequestMergeConfig;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionService;
import com.atlassian.bitbucket.settingsrestriction.RestrictionProcessedState;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.pull.SimpleRestrictedPullRequestMergeConfig;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=PullRequestMergeConfigRestrictionEnricher.class)
@Component(value="pullRequestMergeConfigRestrictionEnricher")
public class DefaultPullRequestMergeConfigRestrictionEnricher
implements PullRequestMergeConfigRestrictionEnricher {
    private final ProjectSettingsRestrictionService projectSettingsRestrictionService;

    @Autowired
    public DefaultPullRequestMergeConfigRestrictionEnricher(ProjectSettingsRestrictionService projectSettingsRestrictionService) {
        this.projectSettingsRestrictionService = projectSettingsRestrictionService;
    }

    public RestrictedPullRequestMergeConfig enrich(@Nonnull PullRequestMergeConfig mergeConfig, @Nonnull Project project) {
        Objects.requireNonNull(mergeConfig, "mergeConfig");
        Objects.requireNonNull(project, "project");
        ProjectSettingsRestrictionState restrictionState = this.projectSettingsRestrictionService.get(project, ProjectSettingsRestrictionKeys.MERGE_STRATEGIES).map(restriction -> ProjectSettingsRestrictionState.fromProcessedState((RestrictionProcessedState)restriction.getProcessedState())).orElse(ProjectSettingsRestrictionState.NONE);
        return new SimpleRestrictedPullRequestMergeConfig(mergeConfig, restrictionState);
    }
}

