/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.IllegalEntityStateException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.comment.AddCommentRequest;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentSearchRequest;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThread;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.comment.NoSuchCommentException;
import com.atlassian.bitbucket.commit.AbstractCommitCallback;
import com.atlassian.bitbucket.commit.BatchingCommitCallback;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommonAncestorRequest;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.commit.SimpleMinimalCommit;
import com.atlassian.bitbucket.commit.graph.CommitGraphContext;
import com.atlassian.bitbucket.commit.graph.CommitGraphNode;
import com.atlassian.bitbucket.commit.graph.SimpleCommitGraphNode;
import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ChangeContext;
import com.atlassian.bitbucket.content.ChangeSummary;
import com.atlassian.bitbucket.content.ChangesRequest;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffContentFilter;
import com.atlassian.bitbucket.content.DiffRequest;
import com.atlassian.bitbucket.content.DiffStatsSummary;
import com.atlassian.bitbucket.content.DiffStatsSummaryRequest;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.dmz.pull.PreparedPullRequestMerge;
import com.atlassian.bitbucket.dmz.pull.PullRequestCommitAuthor;
import com.atlassian.bitbucket.dmz.pull.PullRequestSummary;
import com.atlassian.bitbucket.dmz.pull.PullRequestSummaryRequest;
import com.atlassian.bitbucket.dmz.pull.SimplePreparedPullRequestMerge;
import com.atlassian.bitbucket.event.branch.BranchCreatedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestActivityEvent;
import com.atlassian.bitbucket.event.pull.PullRequestDeclinedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestDeletedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestDeletionRequestedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestMergeActivityEvent;
import com.atlassian.bitbucket.event.pull.PullRequestOpenRequestedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReopenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestRescopeActivityEvent;
import com.atlassian.bitbucket.event.pull.PullRequestRescopedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReviewDiscardedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReviewFinishedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.hook.repository.RepositoryHookVetoedException;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.io.TypeAwareOutputSupplier;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionPredicateFactory;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.pull.AbstractPullRequestRequest;
import com.atlassian.bitbucket.pull.DeletePullRequestMergeConfigRequest;
import com.atlassian.bitbucket.pull.DuplicatePullRequestException;
import com.atlassian.bitbucket.pull.EmptyPullRequestException;
import com.atlassian.bitbucket.pull.GetPullRequestMergeConfigRequest;
import com.atlassian.bitbucket.pull.IllegalPullRequestSearchRequestException;
import com.atlassian.bitbucket.pull.IllegalPullRequestStateException;
import com.atlassian.bitbucket.pull.InvalidPullRequestTargetException;
import com.atlassian.bitbucket.pull.NoSuchPullRequestException;
import com.atlassian.bitbucket.pull.NoSuchPullRequestReviewException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestActivityPage;
import com.atlassian.bitbucket.pull.PullRequestActivityPropertyMode;
import com.atlassian.bitbucket.pull.PullRequestActivitySearchRequest;
import com.atlassian.bitbucket.pull.PullRequestChangeScope;
import com.atlassian.bitbucket.pull.PullRequestChangesRequest;
import com.atlassian.bitbucket.pull.PullRequestCommitSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestCommitsRequest;
import com.atlassian.bitbucket.pull.PullRequestCreateRequest;
import com.atlassian.bitbucket.pull.PullRequestDeclineRequest;
import com.atlassian.bitbucket.pull.PullRequestDeleteRequest;
import com.atlassian.bitbucket.pull.PullRequestDeletionCanceledException;
import com.atlassian.bitbucket.pull.PullRequestDeletionDisabledException;
import com.atlassian.bitbucket.pull.PullRequestDiffRequest;
import com.atlassian.bitbucket.pull.PullRequestDiffStatsSummaryRequest;
import com.atlassian.bitbucket.pull.PullRequestDiscardReviewRequest;
import com.atlassian.bitbucket.pull.PullRequestEntityType;
import com.atlassian.bitbucket.pull.PullRequestFinishReviewRequest;
import com.atlassian.bitbucket.pull.PullRequestGetRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeActivity;
import com.atlassian.bitbucket.pull.PullRequestMergeConfig;
import com.atlassian.bitbucket.pull.PullRequestMergeConfigType;
import com.atlassian.bitbucket.pull.PullRequestMergeRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeStrategy;
import com.atlassian.bitbucket.pull.PullRequestMergeVetoedException;
import com.atlassian.bitbucket.pull.PullRequestMergeability;
import com.atlassian.bitbucket.pull.PullRequestOpenCanceledException;
import com.atlassian.bitbucket.pull.PullRequestOrder;
import com.atlassian.bitbucket.pull.PullRequestOutOfDateException;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipantSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatusRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.pull.PullRequestRescopeActivity;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.pull.PullRequestSupplier;
import com.atlassian.bitbucket.pull.PullRequestUpdateRequest;
import com.atlassian.bitbucket.pull.RescopeDetails;
import com.atlassian.bitbucket.pull.SetPullRequestMergeConfigRequest;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryArchivedException;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.ResolveRefsRequest;
import com.atlassian.bitbucket.repository.SimpleBranch;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.MergeException;
import com.atlassian.bitbucket.scm.PluginMergeStrategy;
import com.atlassian.bitbucket.scm.ScmFeature;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.scm.pull.PullRequestAcceptMergeCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestChangesCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestCommitsCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestDeleteCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestDiffCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestDiffStatsSummaryCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.scm.pull.PullRequestMergeCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestPrepareMergeCommandParameters;
import com.atlassian.bitbucket.scm.pull.UpdatePullRequestRefsCommandParameters;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserEquality;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.CancelState;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.bitbucket.util.SimpleCancelState;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.WatcherSearchRequest;
import com.atlassian.bitbucket.watcher.WatcherService;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.comment.CommentCountChangeCallback;
import com.atlassian.stash.internal.comment.InternalCommentService;
import com.atlassian.stash.internal.commit.InternalCommitService;
import com.atlassian.stash.internal.content.DiffContentCallbackFilter;
import com.atlassian.stash.internal.merge.MergeConfig;
import com.atlassian.stash.internal.merge.MergeConfigHelper;
import com.atlassian.stash.internal.pull.AnalyticsPullRequestMergedEvent;
import com.atlassian.stash.internal.pull.AnalyticsPullRequestOpenedEvent;
import com.atlassian.stash.internal.pull.AnalyticsPullRequestUpdatedEvent;
import com.atlassian.stash.internal.pull.DefaultPullRequestSupplier;
import com.atlassian.stash.internal.pull.InternalMergeRequest;
import com.atlassian.stash.internal.pull.InternalMergeRequestCheckService;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestCommitEnricher;
import com.atlassian.stash.internal.pull.InternalPullRequestCommitHelper;
import com.atlassian.stash.internal.pull.InternalPullRequestMergeActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipantHelper;
import com.atlassian.stash.internal.pull.InternalPullRequestPhase;
import com.atlassian.stash.internal.pull.InternalPullRequestPhaseActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRef;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeCommit;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.pull.PullRequestActivityEnricher;
import com.atlassian.stash.internal.pull.PullRequestActivitySearchCriteria;
import com.atlassian.stash.internal.pull.PullRequestDao;
import com.atlassian.stash.internal.pull.PullRequestDeletionRole;
import com.atlassian.stash.internal.pull.PullRequestEnricher;
import com.atlassian.stash.internal.pull.PullRequestImportRequest;
import com.atlassian.stash.internal.pull.PullRequestMergeConfigDeletedEvent;
import com.atlassian.stash.internal.pull.PullRequestMergeConfigUpdatedEvent;
import com.atlassian.stash.internal.pull.PullRequestParticipantCriteria;
import com.atlassian.stash.internal.pull.PullRequestRefCleanupRequest;
import com.atlassian.stash.internal.pull.PullRequestRescopeCommitAction;
import com.atlassian.stash.internal.pull.PullRequestSearchCriteria;
import com.atlassian.stash.internal.pull.ScmPullRequestMergeStrategy;
import com.atlassian.stash.internal.pull.SimpleMergeRequest;
import com.atlassian.stash.internal.pull.SimplePullRequestMergeConfig;
import com.atlassian.stash.internal.pull.SimplePullRequestMergeVeto;
import com.atlassian.stash.internal.pull.comment.CommentUpdateProcessor;
import com.atlassian.stash.internal.pull.rescope.DeclineOutcome;
import com.atlassian.stash.internal.pull.rescope.MergeOutcome;
import com.atlassian.stash.internal.pull.rescope.RescopeOutcome;
import com.atlassian.stash.internal.pull.rescope.RescopeOutcomeVisitor;
import com.atlassian.stash.internal.pull.rescope.RescopeProcessor;
import com.atlassian.stash.internal.pull.rescope.SimplePullRequestRescope;
import com.atlassian.stash.internal.pull.rescope.UpdateOutcome;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Validator;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(interfaces={PullRequestService.class, PullRequestSupplier.class, DmzPullRequestService.class})
@DependsOn(value={"migrateMergeConfigUpgradeTask"})
@Service(value="pullRequestService")
public class DefaultPullRequestService
extends DefaultPullRequestSupplier
implements InternalPullRequestService {
    private static final int MAX_QUERY_LENGTH = 255;
    private static final int MAX_PR_IDS = 100;
    private static final String SUBJECT_PREFIX = "Merge pull request #%1$d in %3$s/%4$s from ";
    private static final String SUBJECT_INTER_REPOSITORY = "Merge pull request #%1$d in %3$s/%4$s from %6$s/%7$s:%8$s to %5$s";
    private static final String SUBJECT_INTRA_REPOSITORY = "Merge pull request #%1$d in %3$s/%4$s from %8$s to %5$s";
    private static final Logger log = LoggerFactory.getLogger(DefaultPullRequestService.class);
    private final PullRequestActivityDao activityDao;
    private final List<PullRequestActivityEnricher> activityEnrichers;
    private final AuthenticationContext authenticationContext;
    private final InternalCommentService commentService;
    private final CommentUpdateProcessor commentUpdateProcessor;
    private final InternalPullRequestCommitEnricher commitEnricher;
    private final InternalCommitService commitService;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final InternalMergeRequestCheckService mergeRequestCheckService;
    private final MergeConfigHelper mergeConfigHelper;
    private final InternalPullRequestParticipantHelper participantHelper;
    private final PermissionService permissionService;
    private final PermissionPredicateFactory predicateFactory;
    private final InternalPullRequestCommitHelper pullRequestCommitHelper;
    private final PullRequestEnricher pullRequestEnricher;
    private final PullRequestCommitAuthor pullRequestMergeAuthor;
    private final RefService refService;
    private final RescopeProcessor rescopeProcessor;
    private final InternalScmService scmService;
    private final SecurityService securityService;
    private final TransactionSynchronizer transactionSynchronizer;
    private final UserService userService;
    private final Validator validator;
    private final WatcherService watcherService;
    private final TransactionTemplate withNewTransaction;
    private final RepositoryService repositoryService;
    private final ScheduledExecutorService scheduledExecutorService;
    @Value(value="${pullrequest.deletion.role}")
    private PullRequestDeletionRole deletionRole;
    @Value(value="${pullrequest.diff.context}")
    private int diffContext;
    @Value(value="${page.max.pullrequest.activities}")
    private int maxActivities;
    @Value(value="${page.max.changes}")
    private int maxChanges;
    @Value(value="${page.max.commits}")
    private int maxCommits;
    @Value(value="${page.max.diff.lines}")
    private int maxDiffLines;
    @Value(value="${commit.message.max}")
    private int maxMessageLength;
    @Value(value="${page.max.source.length}")
    private int maxLineLength;
    @Value(value="${page.max.pullrequests}")
    private int maxPullRequests;
    @DurationUnit(value=ChronoUnit.SECONDS)
    @Value(value="${pullrequest.merge.timeout}")
    private Duration mergeTimeout;
    @Value(value="${pullrequest.ref.cleanup.max.attempts}")
    private int refCleanupMaxAttempts;
    @DurationUnit(value=ChronoUnit.SECONDS)
    @Value(value="${pullrequest.ref.cleanup.retry.interval}")
    private Duration refCleanupRetryInterval;

    @Autowired
    public DefaultPullRequestService(PullRequestDao pullRequestDao, PullRequestActivityDao activityDao, List<PullRequestActivityEnricher> activityEnrichers, AuthenticationContext authenticationContext, @Lazy InternalCommentService commentService, @Lazy CommentUpdateProcessor commentUpdateProcessor, InternalPullRequestCommitEnricher commitEnricher, InternalCommitService commitService, EventPublisher eventPublisher, FeatureManager featureManager, I18nService i18nService, MergeConfigHelper mergeConfigHelper, InternalMergeRequestCheckService mergeRequestCheckService, InternalPullRequestParticipantHelper participantHelper, PermissionService permissionService, PermissionPredicateFactory predicateFactory, InternalPullRequestCommitHelper pullRequestCommitHelper, PullRequestEnricher pullRequestEnricher, @Value(value="${pullrequest.merge.commit-author}") String pullRequestMergeAuthor, RefService refService, RescopeProcessor rescopeProcessor, InternalScmService scmService, SecurityService securityService, PlatformTransactionManager transactionManager, TransactionSynchronizer transactionSynchronizer, UserService userService, Validator validator, WatcherService watcherService, @Qualifier(value="scheduledExecutorService") ScheduledExecutorService scheduledExecutorService, RepositoryService repositoryService) {
        super(featureManager, pullRequestDao);
        this.activityDao = activityDao;
        this.activityEnrichers = activityEnrichers;
        this.authenticationContext = authenticationContext;
        this.commentService = commentService;
        this.commentUpdateProcessor = commentUpdateProcessor;
        this.commitEnricher = commitEnricher;
        this.commitService = commitService;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.mergeConfigHelper = mergeConfigHelper;
        this.mergeRequestCheckService = mergeRequestCheckService;
        this.participantHelper = participantHelper;
        this.permissionService = permissionService;
        this.predicateFactory = predicateFactory;
        this.pullRequestCommitHelper = pullRequestCommitHelper;
        this.pullRequestEnricher = pullRequestEnricher;
        this.pullRequestMergeAuthor = PullRequestCommitAuthor.fromName((String)pullRequestMergeAuthor).orElse(PullRequestCommitAuthor.AUTHOR);
        this.refService = refService;
        this.rescopeProcessor = rescopeProcessor;
        this.scmService = scmService;
        this.scheduledExecutorService = scheduledExecutorService;
        this.securityService = securityService;
        this.transactionSynchronizer = transactionSynchronizer;
        this.userService = userService;
        this.validator = validator;
        this.watcherService = watcherService;
        this.withNewTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.repositoryService = repositoryService;
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#pullRequest.toRef.repository, 'REPO_WRITE')")
    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    public PullRequest acceptMerge(@Nonnull PullRequest pullRequest, @Nonnull PreparedPullRequestMerge preparedPullRequestMerge) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(preparedPullRequestMerge, "preparedMergeBranch");
        String mergeHash = preparedPullRequestMerge.getBranch().getLatestCommit();
        String expectedTargetHash = preparedPullRequestMerge.getExpectedTargetCommit();
        InternalPullRequest internalPullRequest = InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest);
        Date now = new Date();
        Instant startTime = Instant.now();
        new AcceptMergePullRequestOperation(now, expectedTargetHash, mergeHash, internalPullRequest).perform();
        this.pullRequestDao.refresh((Object)internalPullRequest);
        this.participantHelper.makeCurrentUserParticipantAndWatcher(internalPullRequest);
        this.logMergeActivity(internalPullRequest, now, mergeHash, false);
        Duration duration = Duration.between(startTime, Instant.now());
        this.eventPublisher.publish((Object)new AnalyticsPullRequestMergedEvent(this, pullRequest, (MinimalCommit)(mergeHash == null ? null : new SimpleMinimalCommit.Builder(mergeHash).build()), preparedPullRequestMerge.getMergeMessage(), preparedPullRequestMerge.getMergeStrategyId(), false, true, duration));
        if (mergeHash != null) {
            internalPullRequest.setProperties(new PropertyMap.Builder().property("mergeCommit", (Object)ImmutableMap.of((Object)"displayId", (Object)mergeHash.substring(0, 11), (Object)"id", (Object)mergeHash)).build());
        }
        this.internalUpdateRefsInScm((PullRequest)internalPullRequest);
        return internalPullRequest;
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public PullRequestParticipant addReviewer(int repositoryId, long pullRequestId, @Nonnull String username) {
        this.validateCanUpdateReviewer(repositoryId, username);
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.checkRepositoryNotArchived((Repository)pullRequest.getScopeRepository());
        return this.participantHelper.addReviewer(pullRequest, (ApplicationUser)InternalConverter.convertToInternalUser((ApplicationUser)this.getUserOrFail(username)));
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_WRITE')")
    @Transactional
    public PullRequest autoMerge(@Nonnull PullRequestMergeRequest request) {
        return this.merge(request, true);
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public boolean canDelete(int repositoryId, long pullRequestId) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        return this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_DELETION) && pullRequest.getState() != PullRequestState.MERGED && this.canDelete(pullRequest);
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public PullRequestMergeability canMerge(int repositoryId, long pullRequestId) {
        return this.canMerge(repositoryId, pullRequestId, false);
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public PullRequestMergeability canMerge(int repositoryId, long pullRequestId, boolean abortOnFirstVeto) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.checkIsOpen(pullRequest);
        return this.mergeRequestCheckService.checkMergeability((InternalMergeRequest)new SimpleMergeRequest.Builder((PullRequest)pullRequest).abortOnFirstVeto(abortOnFirstVeto).build());
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public long countCommits(int repositoryId, long pullRequestId) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        InternalPullRequestRef fromRef = pullRequest.getFromRef();
        InternalPullRequestRef toRef = pullRequest.getToRef();
        CountingCommitCallback countingCallback = new CountingCommitCallback();
        this.streamCommitsBetween((Repository)fromRef.getRepository(), fromRef.getLatestCommit(), (Repository)toRef.getRepository(), toRef.getLatestCommit(), (CommitCallback)countingCallback);
        return countingCallback.getCount();
    }

    @PreAuthorize(value="isAuthenticated()")
    public long count(@Nonnull PullRequestSearchRequest request) {
        try {
            return this.pullRequestDao.countMatching(this.toCriteria(request));
        }
        catch (IllegalArgumentException e) {
            return 0L;
        }
    }

    @Secured(value="Permission checks done internally")
    public long countByCommit(@Nonnull PullRequestCommitSearchRequest request) {
        return this.pullRequestCommitHelper.countByCommit(request);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request.fromRepository, 'REPO_READ') and hasRepositoryPermission(#request.toRepository, 'REPO_READ')")
    @Transactional
    public InternalPullRequest create(@Nonnull PullRequestCreateRequest request) {
        Repository fromRepository = Objects.requireNonNull(request, "request").getFromRepository();
        String fromRefId = request.getFromRefId();
        Repository toRepository = request.getToRepository();
        this.checkRepositoryNotArchived(toRepository);
        String toBranchId = request.getToBranchId();
        if (!Objects.equals(fromRepository.getHierarchyId(), toRepository.getHierarchyId())) {
            throw new InvalidPullRequestTargetException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.notsamehierarchy", new Object[0]));
        }
        this.checkNotSameRefs(PullRequestState.OPEN, fromRepository, fromRefId, toRepository, toBranchId);
        Instant startTime = Instant.now();
        Ref fromRef = this.resolveRefOrFail(fromRepository, fromRefId, null);
        Ref toRef = this.resolveRefOrFail(toRepository, toBranchId, (RefType)StandardRefType.BRANCH);
        InternalPullRequestRef fromPullRef = this.createPullRequestRef(fromRepository, fromRef);
        InternalPullRequestRef toPullRef = this.createPullRequestRef(toRepository, toRef);
        this.checkUniquePullRequest(fromPullRef, toPullRef);
        Date now = new Date();
        InternalPullRequest pullRequest = new InternalPullRequest.Builder().title(request.getTitle()).description((String)request.getDescription().orElse(null)).draft(request.isDraft() && this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_DRAFTS)).fromRef(fromPullRef).toRef(toPullRef).createdDate(now).rescopedDate(now).updatedDate(now).state(PullRequestState.OPEN).build();
        ValidationUtils.validate((Validator)this.validator, (Object)pullRequest, (Class[])new Class[0]);
        InternalApplicationUser author = this.getCurrentUser();
        Set<ApplicationUser> resolvedReviewers = this.participantHelper.resolveReviewers((Set)request.getReviewers().stream().filter(reviewer -> !reviewer.equals(author.getName())).collect(MoreCollectors.toImmutableSet()), toRepository);
        this.fireOpenRequested((PullRequest)pullRequest, resolvedReviewers);
        pullRequest = (InternalPullRequest)this.pullRequestDao.create((Object)pullRequest);
        if (!this.pullRequestCommitHelper.reindex(pullRequest)) {
            this.throwEmptyPullRequestException((PullRequestRef)fromPullRef, (PullRequestRef)toPullRef);
        }
        this.participantHelper.createInitialParticipants(pullRequest, (ApplicationUser)author, resolvedReviewers);
        this.logActivity(pullRequest, PullRequestAction.OPENED);
        log.trace("{}#{}: Resolved from-ref: {}, to-ref: {}", new Object[]{pullRequest.getScopeRepository(), pullRequest.getId(), pullRequest.getFromRef().getLatestCommit(), pullRequest.getToRef().getLatestCommit()});
        this.internalUpdateRefsInScm((PullRequest)pullRequest);
        Duration duration = Duration.between(startTime, Instant.now());
        this.eventPublisher.publish((Object)new AnalyticsPullRequestOpenedEvent(this, (PullRequest)pullRequest, duration));
        return pullRequest;
    }

    @Nonnull
    @Unsecured(value="Internal interface method")
    public Page<PullRequestActivity> exportActivities(long globalId, @Nonnull PageRequest pageRequest) {
        return PageUtils.asPageOf(PullRequestActivity.class, (Page)this.activityDao.exportActivities(globalId, pageRequest.buildRestrictedPageRequest(this.maxActivities)));
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request.getRepositoryId(), 'REPO_READ')")
    @Transactional
    public PullRequest decline(@Nonnull PullRequestDeclineRequest request) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail((AbstractPullRequestRequest)Objects.requireNonNull(request, "request"));
        InternalPullRequest result = this.internalDecline(pullRequest, request.getVersion(), null, request.getComment(), false);
        this.internalUpdateRefsInScm((PullRequest)result);
        return result;
    }

    @Secured(value="Secured internally by an explicit permission check")
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void delete(@Nonnull PullRequestDeleteRequest request) {
        final InternalPullRequest pullRequest = this.getPullRequestOrFail((AbstractPullRequestRequest)Objects.requireNonNull(request, "request"), request.getVersion());
        this.checkRepositoryNotArchived((Repository)pullRequest.getScopeRepository());
        if (!this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_DELETION)) {
            throw new PullRequestDeletionDisabledException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.deletiondisabled", new Object[0]), (PullRequest)pullRequest);
        }
        if (pullRequest.getState() == PullRequestState.MERGED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.delete.merged", new Object[0]));
        }
        if (!this.canDelete(pullRequest)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.delete.permissions.insufficient", new Object[0]));
        }
        this.fireDeleteRequested((PullRequest)pullRequest);
        Set watchers = PageUtils.toStream(pageRequest -> this.watcherService.search(new WatcherSearchRequest.Builder((Watchable)pullRequest).build(), pageRequest), (int)25).collect(Collectors.toSet());
        this.pullRequestDao.delete((Object)pullRequest);
        this.eventPublisher.publish((Object)new PullRequestDeletedEvent((Object)this, (PullRequest)pullRequest, watchers));
        final ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        this.transactionSynchronizer.register(new TransactionSynchronization(){

            public void afterCommit() {
                InternalRepository repository = pullRequest.getToRef().getRepository();
                DefaultPullRequestService.this.internalDeletePullRequestInScm((Repository)repository, new PullRequestRefCleanupRequest(repository.getId(), pullRequest.getScopedId(), currentUser));
            }
        });
    }

    @Secured(value="Permissions are checked internally based on the level where the merge config is being deleted")
    @Transactional
    public void deleteMergeConfig(@Nonnull DeletePullRequestMergeConfigRequest request) {
        Repository repository = Objects.requireNonNull(request, "request").getRepository().orElse(null);
        if (repository == null) {
            String scmId = (String)request.getScmId().orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.mergeconfig.set.nolevel", new Object[0])));
            Project project = request.getProject().orElse(null);
            if (project == null) {
                if (!this.permissionService.hasGlobalPermission(Permission.ADMIN)) {
                    throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.mergeconfig.set.notadmin", new Object[0]));
                }
                this.mergeConfigHelper.deleteForScm(scmId);
                this.eventPublisher.publish((Object)new PullRequestMergeConfigDeletedEvent((Object)this, scmId));
            } else {
                if (!this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
                    throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.mergeconfig.set.projnotadmin", new Object[0]));
                }
                this.mergeConfigHelper.deleteForProjectAndScm(project, scmId);
                this.eventPublisher.publish((Object)new PullRequestMergeConfigDeletedEvent(this, scmId, project));
            }
        } else {
            if (!this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN)) {
                throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.mergeconfig.set.reponotadmin", new Object[0]));
            }
            this.mergeConfigHelper.deleteForRepository(repository);
            this.eventPublisher.publish((Object)new PullRequestMergeConfigDeletedEvent((Object)this, repository));
        }
    }

    @PreAuthorize(value="hasRepositoryPermission(#request?.repositoryId, 'REPO_READ')")
    @Transactional
    public void discardReview(@Nonnull PullRequestDiscardReviewRequest request) {
        Objects.requireNonNull(request, "request");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId());
        this.commentService.deletePendingComments((PullRequest)pullRequest);
        this.eventPublisher.publish((Object)new PullRequestReviewDiscardedEvent((Object)this, (PullRequest)pullRequest));
    }

    @Unsecured(value="Internal interface method")
    public void ensureUpToDate(@Nonnull PullRequest pullRequest) {
        this.scmService.getPullRequestCommandFactory(pullRequest).effectiveDiff().call();
    }

    @Nonnull
    @Unsecured(value="Internal interface method")
    public Page<PullRequest> findByHierarchyId(@Nonnull String hierarchyId, @Nonnull PageRequest pageRequest) {
        Page page = this.pullRequestDao.findByRepositoryHierarchyId(Objects.requireNonNull(hierarchyId, "hierarchyId"), Objects.requireNonNull(pageRequest, "pageRequest"));
        return PageUtils.asPageOf(PullRequest.class, (Page)page);
    }

    @PreAuthorize(value="hasRepositoryPermission(#request?.pullRequest.toRef.repository, 'REPO_READ')")
    @Transactional
    public int finishReview(@Nonnull PullRequestFinishReviewRequest request) {
        String commentText;
        boolean addedComment;
        Objects.requireNonNull(request, "request");
        PullRequest pullRequest = request.getPullRequest();
        this.checkRepositoryNotArchived(pullRequest.getToRef().getRepository());
        int publishedCommentCount = this.commentService.publishPendingComments(pullRequest);
        if (publishedCommentCount < 1) {
            throw new NoSuchPullRequestReviewException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.nosuchreview", new Object[0]));
        }
        PullRequestParticipantStatus participantStatus = request.getParticipantStatus();
        if (!this.isCurrentUser(pullRequest.getAuthor().getUser())) {
            InternalPullRequest internalPullRequest = InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest);
            if (participantStatus == null) {
                this.participantHelper.makeCurrentUserParticipantAndWatcher(internalPullRequest);
            } else {
                this.checkIfPullRequestNeedsRescoping(internalPullRequest);
                this.participantHelper.addReviewer(internalPullRequest, this.authenticationContext.getCurrentUser());
                this.participantHelper.setStatus(internalPullRequest, participantStatus, request.getLastReviewedCommit());
            }
        }
        if (addedComment = StringUtils.isNotBlank((CharSequence)(commentText = request.getCommentText()))) {
            this.commentService.addComment(new AddCommentRequest.Builder((Commentable)pullRequest, commentText).build());
        }
        this.eventPublisher.publish((Object)new PullRequestReviewFinishedEvent((Object)this, publishedCommentCount, pullRequest, addedComment, participantStatus));
        return publishedCommentCount;
    }

    @Nullable
    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_READ')")
    @Transactional(readOnly=true)
    public PullRequest get(PullRequestGetRequest request) {
        InternalPullRequest pullRequest = this.getById(request.getRepositoryId(), request.getPullRequestId());
        if (pullRequest != null && request.isWithProperties()) {
            pullRequest = (InternalPullRequest)Iterables.getOnlyElement(this.pullRequestEnricher.enrich(List.of(pullRequest)));
        }
        return pullRequest;
    }

    @Transactional
    @Unsecured(value="Internal interface method")
    public void forceDecline(@Nonnull PullRequestDeclineRequest request) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail((AbstractPullRequestRequest)Objects.requireNonNull(request, "request"));
        int version = pullRequest.getVersion();
        InternalPullRequest updated = this.internalDecline(pullRequest, pullRequest.getVersion(), new Date(), request.getComment(), true);
        if (updated.getVersion() > version) {
            this.internalUpdateRefsInScm((PullRequest)updated);
        }
    }

    @Transactional
    @Unsecured(value="Internal interface method")
    public void forceReopen(int repositoryId, long pullRequestId) {
        this.internalReopen(this.getPullRequestOrFail(repositoryId, pullRequestId), true);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Collection<InternalPullRequest> getByIds(int repositoryId, @Nonnull Set<Long> pullRequestIds) {
        if (Objects.requireNonNull(pullRequestIds, "pullRequestIds").size() >= 100) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.find.prids.toomany", new Object[]{100}));
        }
        return this.pullRequestDao.findByRepositoryScopedIds(repositoryId, pullRequestIds);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Page<PullRequestActivity> getActivities(int repositoryId, long pullRequestId, @Nonnull PageRequest pageRequest) {
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxActivities);
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.commentUpdateProcessor.maybeProcess(pullRequest);
        Page page = this.activityDao.findByPullRequest(pullRequest.getGlobalId(), pageRequest);
        this.enrichActivities(pullRequest, (Page<InternalPullRequestActivity>)page, PullRequestActivityPropertyMode.ACTIVITY_ONLY);
        return PageUtils.asPageOf(PullRequestActivity.class, (Page)page);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public PullRequestActivityPage<PullRequestActivity> getActivitiesStartingAt(int repositoryId, long pullRequestId, @Nonnull PullRequestEntityType fromType, long fromId, @Nonnull PageRequest pageRequest) {
        InternalPullRequestActivity activity;
        Objects.requireNonNull(fromType, "fromType");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxActivities);
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.commentUpdateProcessor.maybeProcess(pullRequest);
        switch (fromType) {
            case ACTIVITY: {
                activity = this.getActivityOrFail(pullRequest, fromId);
                break;
            }
            case COMMENT: {
                Comment rootComment = this.commentService.getComment(fromId).map(comment -> comment.getThread().getRootComment()).orElseThrow(() -> new NoSuchCommentException(this.i18nService.createKeyedMessage("bitbucket.service.comment.error.nosuchcomment", new Object[]{fromId})));
                activity = this.activityDao.findByComment(pullRequest.getGlobalId(), rootComment.getId());
                if (activity != null) break;
                throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.activities.noneforcomment", new Object[]{fromId}));
            }
            default: {
                throw new IllegalArgumentException("Unexpected entity type " + String.valueOf(fromType));
            }
        }
        PullRequestActivityPage page = this.activityDao.findPageStartingAt(pullRequest.getGlobalId(), activity.getId(), pageRequest);
        this.enrichActivities(pullRequest, (Page<InternalPullRequestActivity>)page, PullRequestActivityPropertyMode.ACTIVITY_ONLY);
        return (PullRequestActivityPage)PageUtils.asPageOf(PullRequestActivity.class, (Page)page);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Set<PullRequestActivity> getActivitiesById(int repositoryId, long pullRequestId, Set<Long> activityIds) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.commentUpdateProcessor.maybeProcess(pullRequest);
        List activities = this.activityDao.getByIds(activityIds);
        if (activities.isEmpty()) {
            return ImmutableSet.of();
        }
        for (PullRequestActivity activity : activities) {
            this.checkActivityBelongsToPullRequest(activity, pullRequest);
        }
        this.enrichActivities(pullRequest, activities, PullRequestActivityPropertyMode.ACTIVITY_ONLY);
        return ImmutableSet.copyOf((Collection)activities);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_READ')")
    public Page<Commit> getCommits(@Nonnull PullRequestCommitsRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxCommits);
        InternalPullRequest pullRequest = this.getPullRequestOrFail((AbstractPullRequestRequest)request);
        InternalPullRequestRef fromRef = pullRequest.getFromRef();
        InternalPullRequestRef toRef = pullRequest.getToRef();
        Page commits = (Page)this.scmService.getCommandFactory((Repository)toRef.getRepository()).commits(new CommitsCommandParameters.Builder().exclude(toRef.getLatestCommit(), new String[0]).include(fromRef.getLatestCommit(), new String[0]).maxMessageLength(this.restrictMessageLength(request.getMaxMessageLength())).secondaryRepository((Repository)(pullRequest.isCrossRepository() ? fromRef.getRepository() : null)).build(), pageRequest).call();
        return this.commitEnricher.enrichPage((PullRequest)pullRequest, commits, request.getPropertyKeys());
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_READ')")
    public DiffStatsSummary getDiffStatsSummary(@Nonnull PullRequestDiffStatsSummaryRequest request) {
        Objects.requireNonNull(request, "request");
        InternalPullRequest pullRequest = this.getPullRequestOrFail((AbstractPullRequestRequest)request);
        if (request.getUntilId() != null) {
            return this.commitService.getDiffStatsSummary(new DiffStatsSummaryRequest.Builder((Repository)pullRequest.getScopeRepository(), request.getUntilId()).autoSrcPath(false).path(request.getPath()).sinceId(request.getSinceId()).whitespace(request.getWhitespace()).build());
        }
        return (DiffStatsSummary)this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest).diffStatsSummary(((PullRequestDiffStatsSummaryCommandParameters.Builder)((PullRequestDiffStatsSummaryCommandParameters.Builder)new PullRequestDiffStatsSummaryCommandParameters.Builder().paths(request.getPath(), new String[]{request.getSrcPath()})).whitespace(request.getWhitespace())).build()).call();
    }

    public Map<PullRequestState, Long> getCountsByState() {
        return this.pullRequestDao.countAllByState();
    }

    public Map<PullRequestState, Long> getCountsByState(int repositoryId) {
        return this.pullRequestDao.countByState(repositoryId);
    }

    @Nonnull
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public PullRequestEffectiveDiff getEffectiveDiff(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        PullRequestEffectiveDiff effectiveDiff = (PullRequestEffectiveDiff)this.scmService.getPullRequestCommandFactory(pullRequest).effectiveDiff().call();
        if (effectiveDiff == null) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.noeffectivediff", new Object[]{pullRequest.getId()}));
        }
        return effectiveDiff;
    }

    @Nonnull
    @Unsecured(value="Internal method")
    @Transactional
    public InternalPullRequest importPullRequest(@Nonnull PullRequestImportRequest request) {
        Objects.requireNonNull(request, "request");
        InternalRepository fromRepository = InternalConverter.convertToInternalRepository((Repository)request.getFromRepository());
        String fromRefId = request.getFromRefId();
        InternalRepository toRepository = InternalConverter.convertToInternalRepository((Repository)request.getToRepository());
        String toBranchId = request.getToBranchId();
        if (!Objects.equals(fromRepository.getHierarchyId(), toRepository.getHierarchyId())) {
            throw new InvalidPullRequestTargetException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.notsamehierarchy", new Object[0]));
        }
        this.checkNotSameRefs(request.getState(), (Repository)fromRepository, fromRefId, (Repository)toRepository, toBranchId);
        InternalPullRequestRef fromPullRef = new InternalPullRequestRef.Builder().repository(fromRepository).id(fromRefId).displayId(request.getFromRefDisplayId()).hash(request.getFromRefLatestCommit()).build();
        InternalPullRequestRef toPullRef = new InternalPullRequestRef.Builder().repository(toRepository).id(toBranchId).displayId(request.getToBranchDisplayId()).hash(request.getToBranchLatestCommit()).build();
        if (request.getState() == PullRequestState.OPEN) {
            this.checkUniquePullRequest(fromPullRef, toPullRef);
        }
        InternalPullRequest pullRequest = new InternalPullRequest.Builder().closedDate((Date)request.getClosedDate().map(Date::from).orElse(null)).createdDate(Date.from(request.getCreatedDate())).draft(request.isDraft()).description((String)request.getDescription().orElse(null)).fromRef(fromPullRef).rescopedDate(Date.from(request.getRescopedDate())).scopedId(request.getScopedId()).state(request.getState()).title(request.getTitle()).toRef(toPullRef).updatedDate(Date.from(request.getUpdatedDate())).version(request.getVersion()).build();
        pullRequest = (InternalPullRequest)this.pullRequestDao.create((Object)pullRequest);
        ApplicationUser author = this.participantHelper.resolveAuthorForImport(request.getAuthor(), (Repository)toRepository);
        Set<ApplicationUser> reviewers = this.participantHelper.resolveReviewersForImport(request.getReviewers(), (Repository)toRepository);
        Set<ApplicationUser> otherParticipants = this.participantHelper.resolveOtherParticipantsForImport(request.getOtherParticipants(), (Repository)toRepository);
        this.participantHelper.importParticipants(pullRequest, author, reviewers, otherParticipants, request.getStatusesByParticipant(), request.getLastReviewCommitsByParticipant());
        this.internalUpdateRefsInScm((PullRequest)pullRequest);
        return pullRequest;
    }

    @Transactional(readOnly=true)
    public boolean needsRescoping(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        if (pullRequest.isClosed()) {
            throw new IllegalStateException("Pull request is not open, cannot check the refs in SCM");
        }
        HashMap<String, Ref> scmRefs = new HashMap<String, Ref>();
        PullRequestRef fromRef = pullRequest.getFromRef();
        PullRequestRef toRef = pullRequest.getToRef();
        String fromRefId = fromRef.getId();
        String toRefId = toRef.getId();
        if (pullRequest.isCrossRepository()) {
            scmRefs.put(fromRefId, this.refService.resolveRef(new ResolveRefRequest.Builder(fromRef.getRepository()).refId(fromRefId).build()));
            scmRefs.put(toRefId, this.refService.resolveRef(new ResolveRefRequest.Builder(toRef.getRepository()).refId(toRefId).build()));
        } else {
            scmRefs.putAll(this.refService.resolveRefs(new ResolveRefsRequest.Builder(toRef.getRepository()).refId(fromRefId).refId(toRefId).build()));
        }
        Map<String, String> scmRefHashes = scmRefs.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() == null ? null : ((Ref)e.getValue()).getLatestCommit()));
        return !Objects.equals(scmRefHashes.get(fromRefId), fromRef.getLatestCommit()) || !Objects.equals(scmRefHashes.get(toRefId), toRef.getLatestCommit());
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Optional<Commit> getMergeBase(int repositoryId, long pullRequestId) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        InternalRepository repository = pullRequest.getScopeRepository();
        CommonAncestorRequest commonAncestorRequest = new CommonAncestorRequest.Builder((Repository)repository).commitId(pullRequest.getFromRef().getLatestCommit(), new String[0]).commitId(pullRequest.getToRef().getLatestCommit(), new String[0]).build();
        return this.commitService.getCommonAncestor(commonAncestorRequest).map(minimalCommit -> {
            CommitRequest commitRequest = new CommitRequest.Builder((Repository)repository, minimalCommit.getId()).build();
            return this.commitService.getCommit(commitRequest);
        });
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public PullRequestMergeConfig getMergeConfig(@Nonnull GetPullRequestMergeConfigRequest request) {
        MergeConfig config = Objects.requireNonNull(request, "request").getRepository().map(repository -> {
            if (this.permissionService.hasRepositoryPermission(repository, Permission.REPO_READ)) {
                return this.mergeConfigHelper.getForRepository((Repository)repository);
            }
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.mergeconfig.get.reponoaccess", new Object[0]));
        }).orElseGet(() -> request.getScmId().map(scmId -> request.getProject().map(project -> {
            if (this.permissionService.hasProjectPermission(project, Permission.PROJECT_READ)) {
                return this.mergeConfigHelper.getForProjectAndScm((Project)project, (String)scmId);
            }
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.mergeconfig.get.projnoaccess", new Object[0]));
        }).orElseGet(() -> this.mergeConfigHelper.getForScm((String)scmId))).orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.mergeconfig.get.nolevel", new Object[0]))));
        Map strategiesById = config.getAvailableStrategies().stream().collect(Collectors.toMap(PluginMergeStrategy::getId, strategy -> new ScmPullRequestMergeStrategy.Builder(this.i18nService, (PluginMergeStrategy)strategy).enabled(config.isEnabled(strategy.getId())).build(), (key, value) -> {
            throw new IllegalStateException("Multiple strategies are using [" + String.valueOf(key) + "] as their ID.");
        }, LinkedHashMap::new));
        return new SimplePullRequestMergeConfig.Builder().commitSummaries(config.getCommitSummaries()).defaultStrategy((PullRequestMergeStrategy)strategiesById.get(config.getDefaultStrategyId())).strategies(strategiesById.values()).type(config.getType()).commitMessageTemplate(config.getCommitMessageTemplate().orElse(null)).build();
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Page<PullRequestParticipant> getParticipants(int repositoryId, long pullRequestId, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        return PageUtils.asPageOf(PullRequestParticipant.class, this.participantHelper.getParticipants(this.getPullRequestOrFail(repositoryId, pullRequestId), pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Page<CommentThread> getReviewThreads(int repositoryId, long pullRequestId, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        return this.commentService.searchThreadsWithPending(new CommentSearchRequest.Builder((Commentable)pullRequest).state(CommentState.PENDING).build(), pageRequest);
    }

    @Nonnull
    @Unsecured(value="DMZ API: Intended for batch processing, so permissions are not checked")
    public Page<PullRequestSummary> getSummaries(@Nonnull PullRequestSummaryRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        return PageUtils.asPageOf(PullRequestSummary.class, (Page)this.pullRequestDao.summarize(request, pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_WRITE')")
    @Transactional
    public PullRequest merge(@Nonnull PullRequestMergeRequest request) {
        return this.merge(request, false);
    }

    @EventListener
    public void onRepositoryDeleteRequested(RepositoryDeletionRequestedEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Repository repository = event.getRepository();
        try {
            this.cleanup(repository.getId());
        }
        catch (RuntimeException e) {
            log.error("{}: Pull requests could not be cleaned up on repository deletion", (Object)repository, (Object)e);
            event.cancel(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.cleanupfailed", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        }
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request?.repositoryId, 'REPO_WRITE')")
    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    public PreparedPullRequestMerge prepareMerge(@Nonnull PullRequestMergeRequest request, @Nonnull String temporaryBranchName) {
        String mergeHash;
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(temporaryBranchName, "temporaryBranchName");
        ApplicationUser committer = this.validateCurrentUser();
        InternalPullRequest pullRequest = this.validatePullRequestState(request);
        InternalRepository repository = pullRequest.getToRef().getRepository();
        MergeConfig mergeConfig = this.mergeConfigHelper.getForRepository((Repository)repository);
        String strategyId = this.checkEnabledMergeStrategy((Repository)repository, mergeConfig, request.getStrategyId());
        Date now = new Date();
        try {
            mergeHash = new PrepareMergePullRequestOperation(pullRequest, committer, now, request.isAutoSubject(), request.getMessage(), mergeConfig.getCommitSummaries(), strategyId, temporaryBranchName).perform();
        }
        catch (MergeException e) {
            if (e.isConflicted()) {
                throw new PullRequestMergeVetoedException(this.buildMergeabilityMessage(true, false), Collections.emptyList(), true);
            }
            throw e;
        }
        catch (RepositoryHookVetoedException e) {
            Collection vetoes = (Collection)e.getVetoes().stream().map(veto -> new SimplePullRequestMergeVeto(veto.getSummaryMessage(), veto.getDetailedMessage())).collect(MoreCollectors.toImmutableList());
            throw new PullRequestMergeVetoedException(this.buildMergeabilityMessage(false, !vetoes.isEmpty()), vetoes, false);
        }
        SimpleBranch branch = ((SimpleBranch.Builder)((SimpleBranch.Builder)((SimpleBranch.Builder)new SimpleBranch.Builder().id(GitRefPattern.HEADS.qualify(temporaryBranchName))).displayId(temporaryBranchName)).latestCommit(mergeHash)).build();
        this.eventPublisher.publish((Object)new BranchCreatedEvent((Object)this, (Repository)repository, (Branch)branch));
        return new SimplePreparedPullRequestMerge.Builder((Branch)branch, pullRequest.getToRef().getLatestCommit()).mergeMessage(request.getMessage()).mergeStrategyId(request.getStrategyId()).build();
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public void removeReviewer(int repositoryId, long pullRequestId, @Nonnull String username) {
        this.validateCanUpdateReviewer(repositoryId, username);
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.checkRepositoryNotArchived((Repository)pullRequest.getScopeRepository());
        this.participantHelper.removeReviewer(pullRequest, this.getUserOrFail(username));
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public PullRequest reopen(int repositoryId, long pullRequestId, int version) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId, version);
        this.checkRepositoryNotArchived((Repository)pullRequest.getScopeRepository());
        return this.internalReopen(pullRequest, false);
    }

    @Nonnull
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Unsecured(value="Only called by internal code")
    public InternalPullRequest rescope(long globalId, int expectedVersion, @Nonnull List<SimplePullRequestRescope> rescopes) {
        SimplePullRequestRescope first;
        InternalPullRequest current = this.getPullRequestOrFail(globalId);
        if (rescopes.isEmpty()) {
            return current;
        }
        if (current.isLocked()) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.merging", new Object[0]));
        }
        String oldFromHash = current.getFromRef().getLatestCommit();
        String oldToHash = current.getToRef().getLatestCommit();
        int version = current.getVersion();
        if (!(version == expectedVersion || ShaUtils.hashesMatch((String)oldFromHash, (String)(first = rescopes.get(0)).getOldFromHash()) && ShaUtils.hashesMatch((String)oldToHash, (String)first.getOldToHash()))) {
            throw new PullRequestOutOfDateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.outofdate", new Object[0]), (PullRequest)current, expectedVersion);
        }
        log.debug("{}#{}: rescoping {}", new Object[]{current.getScopeRepository(), current.getId(), rescopes});
        HashSet<ApplicationUser> contributors = new HashSet<ApplicationUser>();
        for (SimplePullRequestRescope rescope : rescopes) {
            if (current.isClosed()) {
                log.info("{}#{}: Skipping rescope {} because the pull request is already closed", new Object[]{current.getScopeRepository(), current.getId(), rescope});
                continue;
            }
            ApplicationUser rescopeUser = rescope.getUser();
            InternalPullRequest pullRequest = current;
            current = (InternalPullRequest)this.securityService.impersonating(rescopeUser, "rescoping").call(() -> this.internalRescope(pullRequest, version, rescope));
            if (!rescope.isFromRefUpdated()) continue;
            contributors.add(rescopeUser);
        }
        InternalPullRequest rescoped = current.isOpen() ? (InternalPullRequest)this.pullRequestDao.update((Object)current) : current;
        contributors.forEach(contributor -> this.participantHelper.makeParticipantAndWatcher(rescoped, (ApplicationUser)contributor));
        if (!oldFromHash.equals(rescoped.getFromRef().getLatestCommit()) || !oldToHash.equals(rescoped.getToRef().getLatestCommit())) {
            this.commentUpdateProcessor.process(rescoped, oldFromHash, oldToHash);
        }
        return rescoped;
    }

    @Secured(value="Internal service method for PR imports")
    @Transactional
    public void resyncNextId(@Nonnull Repository repository) {
        this.pullRequestDao.resyncNextId(Objects.requireNonNull(repository, "repository").getId());
    }

    @Nonnull
    @Secured(value="Secured internally by a predicate")
    public Page<PullRequest> search(@Nonnull PullRequestSearchRequest request, @Nonnull PageRequest pageRequest) {
        try {
            List orders = request.getOrders();
            if (orders.contains(PullRequestOrder.PARTICIPANT_STATUS) && request.getParticipants().size() != 1) {
                throw new IllegalPullRequestSearchRequestException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.search.participants.order", new Object[]{PullRequestOrder.PARTICIPANT_STATUS}));
            }
            if (orders.contains(PullRequestOrder.NEWEST) && orders.contains(PullRequestOrder.OLDEST)) {
                throw new IllegalPullRequestSearchRequestException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.search.invalid.order", new Object[0]));
            }
            if (StringUtils.length((CharSequence)request.getFilterText()) > 255) {
                throw new IllegalPullRequestSearchRequestException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.search.filter.text.size", new Object[]{255}));
            }
            return this.search(this.toCriteria(request), pageRequest, request.isWithProperties());
        }
        catch (IllegalArgumentException e) {
            log.warn("An exception occurred while attempting to search for pull requests.", (Throwable)e);
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_READ')")
    public Page<PullRequestActivity> searchActivities(@Nonnull PullRequestActivitySearchRequest request, @Nonnull PageRequest pageRequest) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId());
        Page page = this.activityDao.search(new PullRequestActivitySearchCriteria.Builder(pullRequest, request).build(), pageRequest.buildRestrictedPageRequest(this.maxActivities));
        this.enrichActivities(pullRequest, (Page<InternalPullRequestActivity>)page, request.getPropertyMode());
        return PageUtils.asPageOf(PullRequestActivity.class, (Page)page);
    }

    @Nonnull
    @Secured(value="Permission checks done internally")
    public Page<PullRequest> searchByCommit(@Nonnull PullRequestCommitSearchRequest request, @Nonnull PageRequest pageRequest) {
        return this.pullRequestCommitHelper.searchByCommit(request, pageRequest);
    }

    @Nonnull
    @Secured(value="Permission checks done internally")
    public Page<ApplicationUser> searchUsers(@Nonnull PullRequestParticipantSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        return this.participantHelper.searchUsers(searchRequest, pageRequest);
    }

    @Secured(value="Permissions are checked internally based on the level where the merge config is being applied")
    @Transactional
    public void setMergeConfig(@Nonnull SetPullRequestMergeConfigRequest request) {
        Repository repository = Objects.requireNonNull(request, "request").getRepository().orElse(null);
        if (repository == null) {
            String scmId = (String)request.getScmId().orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.mergeconfig.set.nolevel", new Object[0])));
            Project project = request.getProject().orElse(null);
            if (project == null) {
                if (!this.permissionService.hasGlobalPermission(Permission.ADMIN)) {
                    throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.mergeconfig.set.notadmin", new Object[0]));
                }
                MergeConfig oldConfig = this.mergeConfigHelper.getForScm(scmId);
                PullRequestMergeConfigType oldType = PullRequestMergeConfigType.valueOf((String)oldConfig.getType().name());
                this.mergeConfigHelper.setForScm(scmId, request.getCommitSummaries(), request.getDefaultStrategyId(), request.getEnabledStrategyIds());
                this.eventPublisher.publish((Object)new PullRequestMergeConfigUpdatedEvent(this, scmId, request.getCommitSummaries(), request.getDefaultStrategyId(), request.getEnabledStrategyIds(), oldConfig.getCommitSummaries(), oldConfig.getDefaultStrategyId(), oldConfig.getEnabledStrategyIds(), oldType));
            } else {
                if (!this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
                    throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.mergeconfig.set.projnotadmin", new Object[0]));
                }
                MergeConfig oldConfig = this.mergeConfigHelper.getForProjectAndScm(project, scmId);
                PullRequestMergeConfigType oldType = PullRequestMergeConfigType.valueOf((String)oldConfig.getType().name());
                this.mergeConfigHelper.setForProjectAndScm(project, scmId, request.getCommitSummaries(), request.getDefaultStrategyId(), request.getEnabledStrategyIds(), request.getCommitMessageTemplate().orElse(null), request.isUpdateCommitMessageTemplate());
                this.eventPublisher.publish((Object)new PullRequestMergeConfigUpdatedEvent(this, scmId, project, request.getCommitSummaries(), request.getDefaultStrategyId(), request.getEnabledStrategyIds(), oldConfig.getCommitSummaries(), oldConfig.getDefaultStrategyId(), oldConfig.getEnabledStrategyIds(), oldType, oldConfig.getCommitMessageTemplate().orElse(null), request.getCommitMessageTemplate().orElse(null)));
            }
        } else {
            if (!this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN)) {
                throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.mergeconfig.set.reponotadmin", new Object[0]));
            }
            MergeConfig oldConfig = this.mergeConfigHelper.getForRepository(repository);
            PullRequestMergeConfigType oldType = PullRequestMergeConfigType.valueOf((String)oldConfig.getType().name());
            this.mergeConfigHelper.setForRepository(repository, request.getCommitSummaries(), request.getDefaultStrategyId(), request.getEnabledStrategyIds(), request.getCommitMessageTemplate().orElse(null), request.isUpdateCommitMessageTemplate());
            this.eventPublisher.publish((Object)new PullRequestMergeConfigUpdatedEvent(this, repository, request.getCommitSummaries(), request.getDefaultStrategyId(), request.getEnabledStrategyIds(), oldConfig.getCommitSummaries(), oldConfig.getDefaultStrategyId(), oldConfig.getEnabledStrategyIds(), oldType, oldConfig.getCommitMessageTemplate().orElse(null), request.getCommitMessageTemplate().orElse(null)));
        }
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated() and hasRepositoryPermission(#request.repositoryId, 'REPO_READ')")
    @Transactional
    public PullRequestParticipant setReviewerStatus(@Nonnull PullRequestParticipantStatusRequest request) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId());
        this.checkRepositoryNotArchived((Repository)pullRequest.getScopeRepository());
        this.checkIfPullRequestNeedsRescoping(pullRequest);
        return this.participantHelper.setStatus(pullRequest, request.getStatus(), request.getLastReviewedCommit());
    }

    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_READ')")
    public void streamChanges(@Nonnull PullRequestChangesRequest request, @Nonnull ChangeCallback callback) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(callback, "callback");
        this.checkScope(request.getChangeScope(), request.getUntilId());
        InternalPullRequest pullRequest = this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId());
        this.commentUpdateProcessor.maybeProcess(pullRequest);
        switch (request.getChangeScope()) {
            case UNREVIEWED: {
                this.streamUnreviewedChanges(pullRequest, request, callback);
                break;
            }
            case RANGE: {
                this.streamChanges(pullRequest, request.getSinceId(), request.getUntilId(), callback, request.isWithComments());
                break;
            }
            default: {
                this.streamAllChanges(pullRequest, request, callback);
            }
        }
    }

    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_READ')")
    public void streamCommits(final @Nonnull PullRequestCommitsRequest request, @Nonnull CommitCallback callback) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(callback, "callback");
        final InternalPullRequest pullRequest = this.getPullRequestOrFail((AbstractPullRequestRequest)request);
        this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest).commits(new PullRequestCommitsCommandParameters.Builder().maxMessageLength(this.restrictMessageLength(request.getMaxMessageLength())).build(), (CommitCallback)new BatchingCommitCallback(callback, 25){

            protected boolean onCommits(@Nonnull Iterable<Commit> commits) throws IOException {
                commits = DefaultPullRequestService.this.commitEnricher.enrichAll((PullRequest)pullRequest, commits, request.getPropertyKeys());
                return super.onCommits(commits);
            }
        }).call();
    }

    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_READ')")
    public void streamDiff(@Nonnull PullRequestDiffRequest request, @Nonnull DiffContentCallback callback) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(callback, "callback");
        CommentThreadDiffAnchorType diffType = request.getDiffType() == null ? CommentThreadDiffAnchorType.EFFECTIVE : request.getDiffType();
        this.checkDiff(diffType, request.getUntilId());
        InternalPullRequest pullRequest = this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId());
        this.commentUpdateProcessor.maybeProcess(pullRequest);
        if (request.isWithComments()) {
            try {
                CommentSearchRequest searchRequest = new CommentSearchRequest.Builder((Commentable)pullRequest).diffType(diffType).fromHash(request.getSinceId()).path(request.getPath()).toHash(request.getUntilId()).build();
                callback.offerThreads(this.commentService.searchThreads(searchRequest).stream().map(CommentThread.class::cast));
            }
            catch (IOException e) {
                log.error("Failed to provide the diff content callback with comment threads", (Throwable)e);
            }
        }
        if (diffType == CommentThreadDiffAnchorType.EFFECTIVE) {
            this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest).diff(((PullRequestDiffCommandParameters.Builder)((PullRequestDiffCommandParameters.Builder)((PullRequestDiffCommandParameters.Builder)((PullRequestDiffCommandParameters.Builder)((PullRequestDiffCommandParameters.Builder)new PullRequestDiffCommandParameters.Builder().contextLines(request.hasContextLines() ? request.getContextLines() : this.diffContext)).maxLineLength(this.maxLineLength)).maxLines(this.maxDiffLines)).paths(request.getPath(), new String[]{request.getSrcPath()})).whitespace(request.getWhitespace())).build(), DiffContentCallbackFilter.filter((DiffContentCallback)callback, (DiffContentFilter)request.getFilter())).call();
        } else {
            this.commitService.streamDiff(((DiffRequest.Builder)new DiffRequest.Builder((Repository)pullRequest.getScopeRepository(), request.getUntilId()).autoSrcPath(false).contextLines(request.getContextLines()).filter(request.getFilter())).paths(request.getPath(), new String[]{request.getSrcPath()}).sinceId(request.getSinceId()).whitespace(request.getWhitespace()).withComments(false).build(), callback);
        }
    }

    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_READ')")
    public void streamDiff(@Nonnull PullRequestDiffRequest request, @Nonnull TypeAwareOutputSupplier outputSupplier) {
        String untilId;
        String sinceId;
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(outputSupplier, "outputSupplier");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId());
        if (request.getUntilId() == null) {
            PullRequestEffectiveDiff effectiveDiff = this.getEffectiveDiff((PullRequest)pullRequest);
            sinceId = effectiveDiff.getSinceId();
            untilId = effectiveDiff.getUntilId();
        } else {
            sinceId = request.getSinceId();
            untilId = request.getUntilId();
        }
        this.commitService.streamDiff(new DiffRequest.Builder((Repository)pullRequest.getToRef().getRepository(), untilId).contextLines(request.getContextLines()).paths(request.getPath(), new String[]{request.getSrcPath()}).secondaryRepository((Repository)pullRequest.getFromRef().getRepository()).sinceId(sinceId).whitespace(request.getWhitespace()).withComments(false).build(), outputSupplier);
    }

    @Nonnull
    @Secured(value="Permissions checks done internally")
    @Transactional
    public PullRequest update(@Nonnull PullRequestUpdateRequest request) {
        boolean changingToRef;
        Objects.requireNonNull(request, "request");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId(), request.getVersion());
        if (!this.currentUserCanEdit(pullRequest)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.update.permissions.insufficient", new Object[0]));
        }
        this.checkRepositoryNotArchived((Repository)pullRequest.getScopeRepository());
        this.checkIsNotMerged(pullRequest.getState());
        InternalPullRequestRef toPullRef = pullRequest.getToRef();
        boolean bl = changingToRef = request.getToBranchId() != null && !request.getToBranchId().equals(pullRequest.getToRef().getId());
        if (changingToRef) {
            if (pullRequest.isLocked()) {
                throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.update.toref.merging", new Object[0]));
            }
            InternalPullRequestRef fromPullRef = pullRequest.getFromRef();
            InternalRepository toRepository = pullRequest.getToRef().getRepository();
            this.checkNotSameRefs(pullRequest.getState(), (Repository)fromPullRef.getRepository(), fromPullRef.getId(), (Repository)toRepository, request.getToBranchId());
            toPullRef = this.createPullRequestRef((Repository)toRepository, this.resolveRefOrFail((Repository)toRepository, request.getToBranchId(), (RefType)StandardRefType.BRANCH));
            this.checkUniquePullRequest(fromPullRef, toPullRef);
            this.checkHasCommits((PullRequestRef)fromPullRef, (PullRequestRef)toPullRef);
            if (!pullRequest.getToRef().getLatestCommit().equals(toPullRef.getLatestCommit())) {
                this.participantHelper.resetLastReviewedCommit(pullRequest);
            }
        }
        String previousDescription = pullRequest.getDescription();
        boolean previousIsDraft = pullRequest.isDraft();
        String previousTitle = pullRequest.getTitle();
        InternalPullRequestRef previousToBranch = new InternalPullRequestRef.Builder(pullRequest.getToRef()).build();
        boolean isDraft = (Boolean)MoreObjects.firstNonNull((Object)request.isDraft(), (Object)previousIsDraft);
        boolean draftStatusUpdated = isDraft != previousIsDraft;
        boolean draftFeature = this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_DRAFTS);
        if (draftFeature && draftStatusUpdated && pullRequest.getState() == PullRequestState.DECLINED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.draft.declined", new Object[0]));
        }
        Date now = new Date();
        pullRequest = (InternalPullRequest)this.pullRequestDao.update((Object)new InternalPullRequest.Builder(pullRequest).description(this.trimRightToNull(request.getDescription())).draft(draftFeature ? isDraft : previousIsDraft).title(request.getTitle()).toRef(toPullRef).updatedDate(now).build());
        this.logActivity(pullRequest, PullRequestAction.UPDATED, now);
        if (draftStatusUpdated) {
            this.logPhaseActivity(pullRequest, now);
        }
        this.eventPublisher.publish((Object)new AnalyticsPullRequestUpdatedEvent(this, (PullRequest)pullRequest, previousTitle, previousDescription, (Ref)(changingToRef ? previousToBranch : null), previousIsDraft));
        this.participantHelper.setReviewers(pullRequest, request.getReviewers());
        if (changingToRef) {
            String previousFromHash = pullRequest.getFromRef().getLatestCommit();
            String previousToHash = previousToBranch.getLatestCommit();
            this.logRescopeActivity(pullRequest, now, previousFromHash, previousToHash);
            this.commentUpdateProcessor.process(pullRequest, previousFromHash, previousToHash);
            this.eventPublisher.publish((Object)new PullRequestRescopedEvent((Object)this, (PullRequest)pullRequest, previousFromHash, previousToHash));
            this.pullRequestCommitHelper.updateOrDeleteCommits(pullRequest, null, null);
            this.internalUpdateRefsInScm((PullRequest)pullRequest);
        }
        return draftFeature ? pullRequest : this.getById(request.getRepositoryId(), pullRequest.getId());
    }

    @Nonnull
    @Secured(value="Permissions checks done internally")
    @Transactional
    public PullRequest updateDraftStatus(@Nonnull PullRequest pullRequest, boolean draft) {
        if (this.featureManager.isDisabled((Feature)StandardFeature.PULL_REQUEST_DRAFTS)) {
            return pullRequest;
        }
        int repositoryId = pullRequest.getToRef().getRepository().getId();
        long pullRequestId = pullRequest.getId();
        InternalPullRequest internalPullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        return this.update(new PullRequestUpdateRequest.Builder((PullRequest)internalPullRequest, internalPullRequest.getVersion()).title(internalPullRequest.getTitle()).description(pullRequest.getDescription()).draft(Boolean.valueOf(draft)).reviewers(this.extractReviewerUsernames(pullRequest.getReviewers())).toBranchId(pullRequest.getToRef().getId()).build());
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_READ')")
    @Transactional(readOnly=true)
    public InternalPullRequest validateMergeRequest(@Nonnull PullRequestMergeRequest request) {
        Objects.requireNonNull(request, "request");
        this.validateCurrentUser();
        InternalPullRequest pullRequest = this.validatePullRequestState(request);
        InternalRepository repository = pullRequest.getToRef().getRepository();
        MergeConfig mergeConfig = this.mergeConfigHelper.getForRepository((Repository)repository);
        this.checkEnabledMergeStrategy((Repository)repository, mergeConfig, request.getStrategyId());
        return pullRequest;
    }

    private static Map<String, Object> buildChangeProperties(PullRequestChangeScope changeScope, Boolean includesMerge, Integer unreviewedCommits) {
        ImmutableMap.Builder changeProperties = ImmutableMap.builder();
        changeProperties.put((Object)"changeScope", (Object)changeScope);
        if (includesMerge != null) {
            changeProperties.put((Object)"includesMerge", (Object)includesMerge);
        }
        if (unreviewedCommits != null) {
            changeProperties.put((Object)"unreviewedCommits", (Object)unreviewedCommits);
        }
        return changeProperties.build();
    }

    private static String getMergeStrategyNames(MergeConfig mergeConfig) {
        return Joiner.on((char)',').join(mergeConfig.getEnabledStrategyIds());
    }

    private KeyedMessage buildMergeabilityMessage(boolean conflicted, boolean vetoed) {
        Preconditions.checkArgument((conflicted || vetoed ? 1 : 0) != 0);
        if (conflicted) {
            if (vetoed) {
                return this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.vetoedandconflicted", new Object[0]);
            }
            return this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.conflicted", new Object[0]);
        }
        return this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.vetoed", new Object[0]);
    }

    private boolean canDelete(InternalPullRequest pullRequest) {
        return this.permissionService.hasRepositoryPermission((Repository)pullRequest.getScopeRepository(), this.deletionRole.toPermission(this.isCurrentUser(pullRequest.getAuthor().getUser())));
    }

    private void checkActivityBelongsToPullRequest(PullRequestActivity activity, InternalPullRequest pullRequest) {
        if (!activity.getPullRequest().equals((Object)pullRequest)) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.activity.nosuchactivityforrequest", new Object[]{activity.getId()}));
        }
    }

    private void checkDiff(CommentThreadDiffAnchorType diffType, String untilId) {
        if (diffType != CommentThreadDiffAnchorType.EFFECTIVE && untilId == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.diff.untilid.required", new Object[]{EnumSet.of(CommentThreadDiffAnchorType.COMMIT, CommentThreadDiffAnchorType.RANGE)}));
        }
    }

    private String checkEnabledMergeStrategy(Repository repository, MergeConfig mergeConfig, String strategyId) {
        if (!this.scmService.isSupported(repository, ScmFeature.MERGE_STRATEGIES)) {
            if (strategyId == null) {
                return null;
            }
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.mergestrategy.unsupported", new Object[]{repository.getScmId()}));
        }
        if (strategyId == null) {
            return mergeConfig.getDefaultStrategyId();
        }
        if (mergeConfig.isEnabled(strategyId)) {
            return strategyId;
        }
        if (mergeConfig.isAvailable(strategyId)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.mergestrategy.notenabled", new Object[]{strategyId, repository.getProject().getKey(), repository.getSlug(), DefaultPullRequestService.getMergeStrategyNames(mergeConfig)}));
        }
        throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.mergestrategy.unavailable", new Object[]{strategyId, repository.getProject().getKey(), repository.getSlug(), DefaultPullRequestService.getMergeStrategyNames(mergeConfig), repository.getScmId()}));
    }

    private void checkHasCommits(PullRequestRef fromRef, PullRequestRef toRef) {
        if (this.isMerged(fromRef.getRepository(), fromRef.getLatestCommit(), toRef.getRepository(), toRef.getLatestCommit())) {
            this.throwEmptyPullRequestException(fromRef, toRef);
        }
    }

    private void checkIfPullRequestNeedsRescoping(InternalPullRequest pullRequest) {
        InternalPullRequestRef fromRef = pullRequest.getFromRef();
        Ref scmRef = (Ref)this.securityService.withPermission(Permission.REPO_READ, "Reading latest source commit").call(() -> this.lambda$checkIfPullRequestNeedsRescoping$20((PullRequestRef)fromRef));
        if (scmRef != null && !Objects.equals(scmRef.getLatestCommit(), fromRef.getLatestCommit())) {
            log.debug("Unable to set reviewer status. Pull request needs re-scoping. Pull request:{}, fromRef={}", (Object)pullRequest.getTitle(), (Object)pullRequest.getFromRef().getLatestCommit());
            throw new PullRequestOutOfDateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.outofdate", new Object[0]), (PullRequest)pullRequest, pullRequest.getVersion());
        }
    }

    private void checkIsNotDeclined(PullRequestState state) {
        if (state == PullRequestState.DECLINED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.declined", new Object[0]));
        }
    }

    private void checkIsNotDraft(InternalPullRequest internalPullRequest) {
        if (this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_DRAFTS) && internalPullRequest.isDraft()) {
            throw new IllegalEntityStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.draft", new Object[0]));
        }
    }

    private void checkIsNotMerged(PullRequestState state) {
        if (state == PullRequestState.MERGED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.merged", new Object[0]));
        }
    }

    private void checkIsOpen(InternalPullRequest pullRequest) {
        PullRequestState state = pullRequest.getState();
        this.checkIsNotDeclined(state);
        this.checkIsNotMerged(state);
    }

    private void checkNotSameRefs(PullRequestState state, Repository fromRepository, String fromRef, Repository toRepository, String toBranch) {
        if (state == PullRequestState.OPEN && fromRepository.getId() == toRepository.getId() && Objects.equals(fromRef, toBranch)) {
            throw new InvalidPullRequestTargetException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.samebranch", new Object[0]));
        }
    }

    private void checkPullRequestVersion(int version, InternalPullRequest pullRequest) {
        if (pullRequest.getVersion() != version) {
            throw new PullRequestOutOfDateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.outofdate", new Object[0]), (PullRequest)pullRequest, version);
        }
    }

    private Ref checkRefExistsForReopen(InternalPullRequestRef ref, RefType type) {
        Ref resolvedRef = this.refService.resolveRef(new ResolveRefRequest.Builder((Repository)ref.getRepository()).refId(ref.getId()).type(type).build());
        if (resolvedRef == null) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.refdeleted", new Object[]{ref.getDisplayId()}));
        }
        return resolvedRef;
    }

    private void checkRepositoryNotArchived(Repository repo) {
        if (repo.isArchived()) {
            throw new RepositoryArchivedException(this.i18nService.getKeyedText(new I18nKey("bitbucket.service.pullrequest.error.repoarchived", new Object[0])));
        }
    }

    private void checkScope(PullRequestChangeScope changeScope, String untilId) {
        if (changeScope == PullRequestChangeScope.RANGE && untilId == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.changes.untilid.required", new Object[]{PullRequestChangeScope.RANGE}));
        }
    }

    private void checkUniquePullRequest(InternalPullRequestRef fromRef, InternalPullRequestRef toRef) {
        Page pullRequests = this.pullRequestDao.findByRefs(fromRef, toRef, PageUtils.newRequest((int)0, (int)50));
        if (pullRequests.getSize() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Matching open pull requests have been found: {}", (Object)pullRequests.stream().map(PullRequest::toString).collect(Collectors.joining(", ")));
            }
            throw new DuplicatePullRequestException((PullRequest)pullRequests.stream().findFirst().get(), this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.duplicate", new Object[0]));
        }
    }

    private void cleanup(int repositoryId) {
        int count = this.pullRequestDao.deleteByToRepository(repositoryId);
        log.debug("Deleted {} pull request(s) TO repository {}", (Object)count, (Object)repositoryId);
        PagedIterable unmerged = new PagedIterable(request -> this.pullRequestDao.findUnmergedByFromRepository(repositoryId, request), PageUtils.newRequest((int)0, (int)50));
        for (InternalPullRequest pullRequest : unmerged) {
            InternalRepository repository = pullRequest.getScopeRepository();
            this.securityService.escalate("Update effective diff with the TO repository").withPermission((Object)repository, Permission.REPO_READ).call(() -> this.lambda$cleanup$22(pullRequest, (Repository)repository));
        }
        count = this.pullRequestDao.declineByFromRepository(repositoryId);
        log.debug("Declined {} open pull request(s) FROM repository {}", (Object)count, (Object)repositoryId);
        count = this.pullRequestDao.overwriteFromRepository(repositoryId);
        log.debug("Updated {} pull request(s) FROM repository {} to be intra-repository", (Object)count, (Object)repositoryId);
    }

    private InternalPullRequestRef createPullRequestRef(Repository fromRepository, Ref fromRef) {
        return new InternalPullRequestRef.Builder().repository(InternalConverter.convertToInternalRepository((Repository)fromRepository)).ref(fromRef).build();
    }

    private boolean currentUserCanEdit(InternalPullRequest pullRequest) {
        InternalRepository repository = pullRequest.getScopeRepository();
        return this.isCurrentUser(pullRequest.getAuthor().getUser()) && this.permissionService.hasRepositoryPermission((Repository)repository, Permission.REPO_READ) || this.permissionService.hasRepositoryPermission((Repository)repository, Permission.REPO_WRITE);
    }

    private void enrichActivities(InternalPullRequest pullRequest, Page<InternalPullRequestActivity> page, PullRequestActivityPropertyMode propertyMode) {
        if (page.getSize() > 0) {
            this.enrichActivities(pullRequest, page.getValues(), propertyMode);
        }
    }

    private void enrichActivities(InternalPullRequest pullRequest, Iterable<InternalPullRequestActivity> activities, PullRequestActivityPropertyMode propertyMode) {
        if (propertyMode.includesActivities()) {
            for (PullRequestActivityEnricher enricher : this.activityEnrichers) {
                enricher.enrich(pullRequest, activities);
            }
        }
        if (propertyMode.includesPullRequests()) {
            Set pullRequests = Chainable.chain(activities).transform(InternalPullRequestActivity::getPullRequest).toSet();
            this.pullRequestEnricher.enrich(pullRequests);
        }
    }

    private Set<String> extractReviewerUsernames(Collection<PullRequestParticipant> reviewers) {
        return reviewers.stream().map(reviewer -> reviewer.getUser().getName()).collect(Collectors.toSet());
    }

    private void fireDeleteRequested(PullRequest pullRequest) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new PullRequestDeletionRequestedEvent((Object)this, pullRequest, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.deletioncanceled", new Object[0]);
            throw new PullRequestDeletionCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireOpenRequested(PullRequest pullRequest, Set<ApplicationUser> reviewers) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new PullRequestOpenRequestedEvent((Object)this, pullRequest, reviewers, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.creationcanceled", new Object[0]);
            throw new PullRequestOpenCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private InternalPullRequestActivity getActivityOrFail(InternalPullRequest pullRequest, long activityId) {
        InternalPullRequestActivity activity = (InternalPullRequestActivity)this.activityDao.getById((Object)activityId);
        if (activity == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.activity.nosuchactivity", new Object[]{activityId}));
        }
        this.checkActivityBelongsToPullRequest((PullRequestActivity)activity, pullRequest);
        return activity;
    }

    private InternalApplicationUser getCurrentUser() {
        return InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser());
    }

    private List<PullRequestOrder> getPullRequestOrders(PullRequestSearchRequest request) {
        HashSet uniqueOrders = new HashSet();
        return request.getOrders().stream().filter(order -> {
            if (!uniqueOrders.add(order)) {
                throw new IllegalPullRequestSearchRequestException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.search.duplicate.order", new Object[]{order}));
            }
            if (this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_DRAFTS)) {
                return true;
            }
            return !order.equals((Object)PullRequestOrder.DRAFT_STATUS);
        }).collect(Collectors.toList());
    }

    private InternalPullRequest getPullRequestOrFail(AbstractPullRequestRequest request) {
        return this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId());
    }

    private InternalPullRequest getPullRequestOrFail(AbstractPullRequestRequest request, int version) {
        return this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId(), version);
    }

    private InternalPullRequest getPullRequestOrFail(int repositoryId, long pullRequestId) {
        InternalPullRequest pullRequest = this.pullRequestDao.findByRepositoryScopedId(repositoryId, pullRequestId);
        if (pullRequest == null) {
            throw new NoSuchPullRequestException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.repository.nosuchrequest", new Object[]{pullRequestId, repositoryId}));
        }
        return pullRequest;
    }

    private InternalPullRequest getPullRequestOrFail(int repositoryId, long pullRequestId, int version) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.checkPullRequestVersion(version, pullRequest);
        return pullRequest;
    }

    private InternalPullRequest getPullRequestOrFail(long globalPullRequestId) {
        InternalPullRequest pullRequest = (InternalPullRequest)this.pullRequestDao.getById((Object)globalPullRequestId);
        if (pullRequest == null) {
            throw new NoSuchPullRequestException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.global.nosuchrequest", new Object[]{globalPullRequestId}));
        }
        return pullRequest;
    }

    private ApplicationUser getUserOrFail(String username) {
        ApplicationUser user = this.userService.getUserByName(username);
        if (user == null) {
            throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.nosuchuser", new Object[]{username}), username);
        }
        return user;
    }

    private InternalPullRequest internalCloseMerged(InternalPullRequest pullRequest, int version, Date date) {
        if (pullRequest.getState() == PullRequestState.MERGED) {
            return pullRequest;
        }
        this.checkPullRequestVersion(version, pullRequest);
        InternalPullRequest updated = (InternalPullRequest)this.pullRequestDao.update((Object)new InternalPullRequest.Builder(pullRequest).state(PullRequestState.MERGED).closedDate(date).build());
        this.logMergeActivity(updated, date, null);
        this.eventPublisher.publish((Object)new AnalyticsPullRequestMergedEvent(this, (PullRequest)updated));
        return updated;
    }

    private InternalPullRequest internalDecline(InternalPullRequest pullRequest, int version, Date date, String commentText, boolean force) {
        if (force) {
            if (pullRequest.getState() == PullRequestState.DECLINED) {
                log.debug("{}: Pull request #{} has already been declined", (Object)pullRequest.getToRef().getRepository(), (Object)pullRequest.getId());
                return pullRequest;
            }
        } else {
            if (pullRequest.getState() == PullRequestState.DECLINED) {
                throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.decline.declined", new Object[0]));
            }
            if (pullRequest.getState() == PullRequestState.MERGED) {
                throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.decline.merged", new Object[0]));
            }
            if (pullRequest.isLocked()) {
                throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.decline.merging", new Object[0]));
            }
            this.checkPullRequestVersion(version, pullRequest);
        }
        if (commentText != null) {
            this.commentService.addComment(new AddCommentRequest.Builder((Commentable)pullRequest, commentText).build());
        }
        Date declineDate = date == null ? new Date() : date;
        pullRequest = (InternalPullRequest)this.pullRequestDao.update((Object)new InternalPullRequest.Builder(pullRequest).state(PullRequestState.DECLINED).closedDate(declineDate).updatedDate(declineDate).build());
        this.logActivity(pullRequest, PullRequestAction.DECLINED, declineDate);
        this.participantHelper.makeCurrentUserParticipantAndWatcher(pullRequest);
        this.eventPublisher.publish((Object)new PullRequestDeclinedEvent((Object)this, (PullRequest)pullRequest));
        return pullRequest;
    }

    private void internalDeletePullRequestInScm(PullRequestRefCleanupRequest request) {
        Repository repository = this.repositoryService.getById(request.getRepositoryId());
        if (repository == null) {
            log.debug("Repository with ID {} is not found, so no need to delete the pull request with ID {} by the SCM", (Object)request.getRepositoryId(), (Object)request.getPullRequestId());
            return;
        }
        this.internalDeletePullRequestInScm(repository, request);
    }

    private void internalDeletePullRequestInScm(Repository repository, PullRequestRefCleanupRequest refCleanupRequest) {
        try {
            this.securityService.impersonating(refCleanupRequest.getUser(), "Deleting pull request in SCM as the authenticated user").call(() -> {
                this.scmService.delete(repository, refCleanupRequest.getPullRequestId(), new PullRequestDeleteCommandParameters.Builder().build());
                return null;
            });
        }
        catch (RuntimeException e) {
            if (this.mayBeRetry(refCleanupRequest)) {
                log.debug("{}: Pull request {} could not be deleted by the SCM after {} attempts, will retry in {} seconds", new Object[]{repository, refCleanupRequest.getPullRequestId(), refCleanupRequest.getAttempts(), log.isTraceEnabled() ? e : null});
            }
            log.warn("{}: Pull request {} could not be deleted by the SCM after {} attempts", new Object[]{repository, refCleanupRequest.getPullRequestId(), this.refCleanupMaxAttempts, e});
        }
    }

    private void internalDoUpdateRefsInScm(PullRequestRefCleanupRequest refCleanupRequest, PullRequest pullRequest) {
        try {
            this.securityService.impersonating(refCleanupRequest.getUser(), "Updating refs as the authenticated user").call(() -> {
                this.scmService.updatePullRequestRefs(new UpdatePullRequestRefsCommandParameters.Builder().pullRequests(pullRequest, new PullRequest[0]).build());
                return null;
            });
        }
        catch (RuntimeException e) {
            if (this.mayBeRetry(refCleanupRequest)) {
                log.debug("[{}] Failed to update public pull request refs for #{} after {} attempts; will retry in {} seconds", new Object[]{pullRequest.getToRef().getRepository(), pullRequest.getId(), this.refCleanupMaxAttempts, this.refCleanupRetryInterval.getSeconds(), e});
            }
            log.warn("[{}] Failed to update public pull request refs for #{} after {} attempts; won't retry", new Object[]{pullRequest.getToRef().getRepository(), pullRequest.getId(), this.refCleanupMaxAttempts, e});
        }
    }

    @Nonnull
    private PullRequest internalReopen(@Nonnull InternalPullRequest pullRequest, boolean force) {
        if (force) {
            if (pullRequest.getState() == PullRequestState.OPEN) {
                return pullRequest;
            }
        } else {
            if (pullRequest.getState() == PullRequestState.OPEN) {
                throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.reopen.opened", new Object[0]));
            }
            if (pullRequest.getState() == PullRequestState.MERGED) {
                throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.reopen.merged", new Object[0]));
            }
        }
        this.checkUniquePullRequest(Objects.requireNonNull(pullRequest, "pullRequest").getFromRef(), pullRequest.getToRef());
        Ref resolvedFromRef = this.checkRefExistsForReopen(pullRequest.getFromRef(), null);
        Ref resolvedToRef = this.checkRefExistsForReopen(pullRequest.getToRef(), (RefType)StandardRefType.BRANCH);
        InternalPullRequestRef originalFromRef = pullRequest.getFromRef();
        String originalFromHash = originalFromRef.getLatestCommit();
        InternalPullRequestRef originalToRef = pullRequest.getToRef();
        String originalToHash = originalToRef.getLatestCommit();
        pullRequest = this.rescopeOnReopen(pullRequest, resolvedFromRef, resolvedToRef);
        Date now = new Date();
        pullRequest = (InternalPullRequest)this.pullRequestDao.update((Object)new InternalPullRequest.Builder(pullRequest).state(PullRequestState.OPEN).closedDate(null).updatedDate(now).build());
        this.logActivity(pullRequest, PullRequestAction.REOPENED, now);
        this.participantHelper.makeCurrentUserParticipantAndWatcher(pullRequest);
        this.eventPublisher.publish((Object)new PullRequestReopenedEvent((Object)this, (PullRequest)pullRequest, originalFromHash, originalToHash));
        this.internalUpdateRefsInScm((PullRequest)pullRequest);
        return pullRequest;
    }

    private InternalPullRequest internalRescope(final InternalPullRequest pullRequest, final int version, final SimplePullRequestRescope rescope) {
        if (rescope.getOutcome() == null) {
            if (rescope.getNewToHash() == null || rescope.getNewFromHash() == null) {
                rescope.setOutcome((RescopeOutcome)new DeclineOutcome());
            } else {
                return this.internalUpdateScope(pullRequest, rescope, null, null);
            }
        }
        return (InternalPullRequest)rescope.getOutcome().accept((RescopeOutcomeVisitor)new RescopeOutcomeVisitor<InternalPullRequest>(){

            public InternalPullRequest visit(@Nonnull DeclineOutcome declineOutcome) {
                return DefaultPullRequestService.this.internalDecline(pullRequest, version, rescope.getDate(), null, false);
            }

            public InternalPullRequest visit(@Nonnull MergeOutcome mergeOutcome) {
                return DefaultPullRequestService.this.internalCloseMerged(pullRequest, version, rescope.getDate());
            }

            public InternalPullRequest visit(@Nonnull UpdateOutcome updateOutcome) {
                return DefaultPullRequestService.this.internalUpdateScope(pullRequest, rescope, updateOutcome.getAddedCommits(), updateOutcome.getRemovedCommits());
            }
        });
    }

    private void internalUpdateRefsInScm(final PullRequest pullRequest) {
        this.transactionSynchronizer.register(new TransactionSynchronization(){
            private final ApplicationUser currentUser;
            {
                this.currentUser = DefaultPullRequestService.this.authenticationContext.getCurrentUser();
            }

            public void afterCommit() {
                PullRequestRefCleanupRequest refCleanupRequest = new PullRequestRefCleanupRequest(pullRequest.getToRef().getRepository().getId(), pullRequest.getId(), this.currentUser);
                DefaultPullRequestService.this.internalDoUpdateRefsInScm(refCleanupRequest, pullRequest);
            }
        });
    }

    private InternalPullRequest internalUpdateScope(InternalPullRequest pullRequest, SimplePullRequestRescope rescope, RescopeDetails addedCommits, RescopeDetails removedCommits) {
        this.logRescopeActivity(pullRequest, rescope, addedCommits, removedCommits);
        InternalPullRequest.Builder builder = new InternalPullRequest.Builder(pullRequest).fromRef(new InternalPullRequestRef.Builder(pullRequest.getFromRef()).hash(rescope.getNewFromHash()).build()).toRef(new InternalPullRequestRef.Builder(pullRequest.getToRef()).hash(rescope.getNewToHash()).build()).rescopedDate(rescope.getDate());
        if (!ShaUtils.hashesMatch((String)rescope.getOldFromHash(), (String)rescope.getNewFromHash())) {
            builder.updatedDate(rescope.getDate());
        }
        InternalPullRequest updated = builder.build();
        this.eventPublisher.publish((Object)new PullRequestRescopedEvent((Object)this, (PullRequest)updated, rescope.getOldFromHash(), rescope.getOldToHash(), addedCommits, removedCommits));
        this.pullRequestCommitHelper.updateOrDeleteCommits(updated, addedCommits, removedCommits);
        return updated;
    }

    private boolean isCurrentUser(ApplicationUser user) {
        return ApplicationUserEquality.equals((ApplicationUser)this.authenticationContext.getCurrentUser(), (Object)user);
    }

    private boolean isMerged(Repository fromRepository, String fromHash, Repository toRepository, String toHash) {
        IsEmptyCommitCallback callback = new IsEmptyCommitCallback();
        this.streamCommitsBetween(fromRepository, fromHash, toRepository, toHash, (CommitCallback)callback);
        return callback.isEmpty();
    }

    private void logActivity(InternalPullRequest pullRequest, PullRequestAction action) {
        this.logActivity(pullRequest, action, new Date());
    }

    private void logActivity(InternalPullRequest pullRequest, PullRequestAction action, Date when) {
        InternalPullRequestActivity activity = ((InternalPullRequestActivity.Builder)((InternalPullRequestActivity.Builder)((InternalPullRequestActivity.Builder)new InternalPullRequestActivity.Builder(pullRequest).action(action)).createdDate(when)).user(this.getCurrentUser())).build();
        this.activityDao.create((Object)activity);
        this.eventPublisher.publish((Object)new PullRequestActivityEvent((Object)this, (PullRequestActivity)activity));
    }

    private void logMergeActivity(InternalPullRequest pullRequest, Date when, String hash) {
        this.logMergeActivity(pullRequest, when, hash, false);
    }

    private void logMergeActivity(InternalPullRequest pullRequest, Date when, String hash, boolean autoMerge) {
        InternalPullRequestMergeActivity activity = ((InternalPullRequestMergeActivity.Builder)((InternalPullRequestMergeActivity.Builder)new InternalPullRequestMergeActivity.Builder(pullRequest).createdDate(when)).hash(hash).autoMerge(autoMerge).user(this.getCurrentUser())).build();
        this.activityDao.create((Object)activity);
        this.eventPublisher.publish((Object)new PullRequestMergeActivityEvent((Object)this, (PullRequestMergeActivity)activity));
    }

    private void logPhaseActivity(InternalPullRequest pullRequest, Date when) {
        InternalPullRequestPhaseActivity activity = ((InternalPullRequestPhaseActivity.Builder)((InternalPullRequestPhaseActivity.Builder)new InternalPullRequestPhaseActivity.Builder(pullRequest).createdDate(when)).phase(pullRequest.isDraft() ? InternalPullRequestPhase.DRAFT : InternalPullRequestPhase.PUBLISHED).user(this.getCurrentUser())).build();
        this.activityDao.create((Object)activity);
        this.eventPublisher.publish((Object)new PullRequestActivityEvent((Object)this, (PullRequestActivity)activity));
    }

    private void logRescopeActivity(InternalPullRequest pullRequest, Date when, String previousFromHash, String previousToHash) {
        InternalPullRequestRescopeActivity activity = ((InternalPullRequestRescopeActivity.Builder)((InternalPullRequestRescopeActivity.Builder)new InternalPullRequestRescopeActivity.Builder(pullRequest).createdDate(when)).fromHash(pullRequest.getFromRef().getLatestCommit()).previousFromHash(previousFromHash).previousToHash(previousToHash).toHash(pullRequest.getToRef().getLatestCommit()).user(this.getCurrentUser())).build();
        this.activityDao.create((Object)activity);
        this.eventPublisher.publish((Object)new PullRequestRescopeActivityEvent((Object)this, (PullRequestRescopeActivity)activity));
        this.rescopeProcessor.queue(activity);
    }

    private void logRescopeActivity(InternalPullRequest pullRequest, SimplePullRequestRescope rescope, RescopeDetails addedCommits, RescopeDetails removedCommits) {
        if (addedCommits != null && removedCommits != null && addedCommits.getTotal() == 0 && removedCommits.getTotal() == 0) {
            return;
        }
        InternalPullRequestRescopeActivity.Builder builder = (InternalPullRequestRescopeActivity.Builder)((InternalPullRequestRescopeActivity.Builder)new InternalPullRequestRescopeActivity.Builder(pullRequest).createdDate(rescope.getDate())).fromHash(rescope.getNewFromHash()).previousFromHash(rescope.getOldFromHash()).previousToHash(rescope.getOldToHash()).toHash(rescope.getNewToHash()).user(InternalConverter.convertToInternalUser((ApplicationUser)rescope.getUser()));
        if (addedCommits != null) {
            builder.totalAdded(addedCommits.getTotal());
            addedCommits.getCommits().forEach(commit -> builder.commit(new InternalPullRequestRescopeCommit.Builder().commitId(commit.getId()).action(PullRequestRescopeCommitAction.ADDED).build()));
        }
        if (removedCommits != null) {
            builder.totalRemoved(removedCommits.getTotal());
            removedCommits.getCommits().forEach(commit -> builder.commit(new InternalPullRequestRescopeCommit.Builder().commitId(commit.getId()).action(PullRequestRescopeCommitAction.REMOVED).build()));
        }
        InternalPullRequestRescopeActivity activity = builder.build();
        this.activityDao.create((Object)activity);
        this.eventPublisher.publish((Object)new PullRequestRescopeActivityEvent((Object)this, (PullRequestRescopeActivity)activity));
        if (addedCommits == null || removedCommits == null) {
            this.rescopeProcessor.queue(activity);
        }
    }

    private boolean mayBeRetry(PullRequestRefCleanupRequest refCleanupRequest) {
        if (refCleanupRequest.incrementAttempts() < this.refCleanupMaxAttempts) {
            this.scheduledExecutorService.schedule(new PullRequestRefCleanupTask(refCleanupRequest), this.refCleanupRetryInterval.toMillis(), TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    private PullRequest merge(@Nonnull PullRequestMergeRequest request, boolean autoMerge) {
        String mergeHash;
        Objects.requireNonNull(request, "request");
        Instant startTime = Instant.now();
        ApplicationUser committer = this.validateCurrentUser();
        InternalPullRequest pullRequest = this.validatePullRequestState(request);
        InternalRepository repository = pullRequest.getToRef().getRepository();
        MergeConfig mergeConfig = this.mergeConfigHelper.getForRepository((Repository)repository);
        String strategyId = this.checkEnabledMergeStrategy((Repository)repository, mergeConfig, request.getStrategyId());
        Date now = new Date();
        try {
            mergeHash = new MergePullRequestOperation(pullRequest, committer, now, request.isAutoSubject(), request.getMessage(), mergeConfig.getCommitSummaries(), strategyId, autoMerge).perform();
        }
        catch (MergeException e) {
            if (e.isConflicted()) {
                throw new PullRequestMergeVetoedException(this.buildMergeabilityMessage(true, false), Collections.emptyList(), true);
            }
            throw e;
        }
        catch (RepositoryHookVetoedException e) {
            Collection vetoes = (Collection)e.getVetoes().stream().map(veto -> new SimplePullRequestMergeVeto(veto.getSummaryMessage(), veto.getDetailedMessage())).collect(MoreCollectors.toImmutableList());
            throw new PullRequestMergeVetoedException(this.buildMergeabilityMessage(false, !vetoes.isEmpty()), vetoes, false);
        }
        this.pullRequestDao.refresh((Object)pullRequest);
        this.participantHelper.makeCurrentUserParticipantAndWatcher(pullRequest);
        this.logMergeActivity(pullRequest, now, mergeHash, autoMerge);
        Duration duration = Duration.between(startTime, Instant.now());
        this.eventPublisher.publish((Object)new AnalyticsPullRequestMergedEvent(this, (PullRequest)pullRequest, (MinimalCommit)(mergeHash == null ? null : new SimpleMinimalCommit.Builder(mergeHash).build()), request.getMessage(), strategyId, autoMerge, false, duration));
        if (mergeHash != null) {
            pullRequest.setProperties(new PropertyMap.Builder().property("mergeCommit", (Object)ImmutableMap.of((Object)"displayId", (Object)mergeHash.substring(0, 11), (Object)"id", (Object)mergeHash)).build());
        }
        this.internalUpdateRefsInScm((PullRequest)pullRequest);
        return pullRequest;
    }

    private InternalPullRequest rescopeOnReopen(@Nonnull InternalPullRequest pullRequest, @Nonnull Ref resolvedFromRef, @Nonnull Ref resolvedToRef) {
        InternalPullRequestRef oldFromRef = pullRequest.getFromRef();
        InternalPullRequestRef oldToRef = pullRequest.getToRef();
        String oldFromHash = oldFromRef.getLatestCommit();
        String oldToHash = oldToRef.getLatestCommit();
        String newFromHash = resolvedFromRef.getLatestCommit();
        String newToHash = resolvedToRef.getLatestCommit();
        boolean fromUnchanged = oldFromHash.equals(newFromHash);
        boolean toUnchanged = oldToHash.equals(newToHash);
        if (fromUnchanged && toUnchanged) {
            return pullRequest;
        }
        if (this.isMerged((Repository)oldFromRef.getRepository(), newFromHash, (Repository)oldToRef.getRepository(), newToHash)) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.reopen.empty", new Object[0]));
        }
        Date now = new Date();
        InternalPullRequest.Builder builder = new InternalPullRequest.Builder(pullRequest).fromRef(new InternalPullRequestRef.Builder(oldFromRef).hash(newFromHash).build()).toRef(new InternalPullRequestRef.Builder(oldToRef).hash(newToHash).build()).rescopedDate(now);
        if (!fromUnchanged) {
            builder.updatedDate(now);
        }
        InternalPullRequest updated = (InternalPullRequest)this.pullRequestDao.update((Object)builder.build());
        this.logRescopeActivity(updated, now, oldFromHash, oldToHash);
        if (!fromUnchanged) {
            this.participantHelper.makeCurrentUserParticipantAndWatcher(updated);
        }
        this.commentUpdateProcessor.process(updated, oldFromHash, oldToHash);
        this.eventPublisher.publish((Object)new PullRequestRescopedEvent((Object)this, (PullRequest)updated, oldFromHash, oldToHash));
        this.pullRequestCommitHelper.updateOrDeleteCommits(pullRequest, null, null);
        return updated;
    }

    private Ref resolveRefOrFail(Repository repository, String refId, RefType type) {
        Ref ref = this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(refId).type(type).build());
        if (ref == null) {
            throw new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.nosuchref", new Object[]{repository.getSlug(), repository.getProject().getKey(), refId}), refId);
        }
        return ref;
    }

    private int restrictMessageLength(int length) {
        if (length < 0 || length > this.maxMessageLength) {
            return this.maxMessageLength;
        }
        return length;
    }

    private Page<PullRequest> search(PullRequestSearchCriteria criteria, PageRequest pageRequest, boolean enrich) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        Page<InternalPullRequest> page = this.pullRequestDao.search(criteria, pageRequest.buildRestrictedPageRequest(this.maxPullRequests), this.predicateFactory.createPullRequestPermissionPredicate(Permission.REPO_READ));
        if (page.getSize() > 0) {
            Boolean draftFeature = this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_DRAFTS);
            boolean withDescription = criteria.isWithDescription();
            if (!withDescription || !draftFeature.booleanValue()) {
                page = page.transform(pr -> {
                    InternalPullRequest.Builder builder = new InternalPullRequest.Builder(pr);
                    if (!withDescription) {
                        builder.description(null);
                    }
                    if (!draftFeature.booleanValue()) {
                        builder.draft(false);
                    }
                    return builder.build();
                });
            }
            if (enrich) {
                page = this.pullRequestEnricher.enrich(page);
            }
        }
        return PageUtils.asPageOf(PullRequest.class, (Page)page);
    }

    private void streamAllChanges(InternalPullRequest pullRequest, PullRequestChangesRequest request, ChangeCallback callback) {
        Map commentCounts;
        if (request.isWithComments() && !(commentCounts = this.commentService.countCommentsByLocation(new CommentSearchRequest.Builder((Commentable)pullRequest).diffType(CommentThreadDiffAnchorType.EFFECTIVE).build())).isEmpty()) {
            callback = new CommentCountChangeCallback(callback, commentCounts);
        }
        callback = new ScopedChangeCallback(callback, DefaultPullRequestService.buildChangeProperties(PullRequestChangeScope.ALL, null, null));
        this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest).changes(((PullRequestChangesCommandParameters.Builder)new PullRequestChangesCommandParameters.Builder().maxChanges(this.maxChanges)).build(), callback).call();
    }

    private void streamChanges(InternalPullRequest pullRequest, String sinceId, String untilId, ChangeCallback callback, boolean withComments) {
        if (withComments) {
            Map commentCounts;
            CommentSearchRequest.Builder builder = new CommentSearchRequest.Builder((Commentable)pullRequest).diffType(CommentThreadDiffAnchorType.COMMIT).fromHash(sinceId).toHash(untilId);
            if (sinceId != null) {
                builder.diffType(CommentThreadDiffAnchorType.RANGE);
            }
            if (!(commentCounts = this.commentService.countCommentsByLocation(builder.build())).isEmpty()) {
                callback = new CommentCountChangeCallback(callback, commentCounts);
            }
        }
        this.commitService.streamChanges(new ChangesRequest.Builder((Repository)pullRequest.getScopeRepository(), untilId).sinceId(sinceId).withComments(false).build(), callback);
    }

    private void streamCommitsBetween(Repository fromRepository, String fromHash, Repository toRepository, String toHash, CommitCallback callback) {
        this.scmService.getCommandFactory(toRepository).commits(new CommitsCommandParameters.Builder().exclude(toHash, new String[0]).ignoreMissing(false).include(fromHash, new String[0]).secondaryRepository(fromRepository).withMessages(false).build(), callback).call();
    }

    private void streamUnreviewedChanges(InternalPullRequest pullRequest, PullRequestChangesRequest request, ChangeCallback callback) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        String lastReviewedCommit = pullRequest.getReviewers().stream().filter(p -> p.getUser().equals((Object)currentUser)).findFirst().map(PullRequestParticipant::getLastReviewedCommit).filter(Predicate.isEqual(pullRequest.getFromRef().getLatestCommit()).negate()).orElse(null);
        if (lastReviewedCommit != null) {
            CommitGraphContext commitGraphContext = new CommitGraphContext.Builder().exclude(lastReviewedCommit, new String[0]).include(pullRequest.getFromRef().getLatestCommit(), new String[0]).build();
            MutableBoolean includesMerge = new MutableBoolean(false);
            MutableBoolean lastReviewedCommitOnSourceBranch = new MutableBoolean(false);
            MutableInt unreviewedCommits = new MutableInt(0);
            this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest).commits(new PullRequestCommitsCommandParameters.Builder().withMessages(false).build(), commit -> {
                if (commitGraphContext.visit((CommitGraphNode)new SimpleCommitGraphNode.Builder(commit).build())) {
                    unreviewedCommits.increment();
                    if (includesMerge.isFalse() && commit.getParents().size() > 1) {
                        includesMerge.setTrue();
                    }
                }
                if (lastReviewedCommit.equals(commit.getId())) {
                    lastReviewedCommitOnSourceBranch.setTrue();
                }
                return lastReviewedCommitOnSourceBranch.isFalse() || commitGraphContext.isTraversing();
            }).call();
            if (lastReviewedCommitOnSourceBranch.getValue().booleanValue()) {
                callback = new ScopedChangeCallback(callback, DefaultPullRequestService.buildChangeProperties(PullRequestChangeScope.UNREVIEWED, includesMerge.getValue(), unreviewedCommits.getValue()));
                this.streamChanges(pullRequest, lastReviewedCommit, pullRequest.getFromRef().getLatestCommit(), callback, request.isWithComments());
                return;
            }
        }
        this.streamAllChanges(pullRequest, request, callback);
    }

    private void throwEmptyPullRequestException(PullRequestRef fromRef, PullRequestRef toRef) {
        Repository fromRepository = fromRef.getRepository();
        Repository toRepository = toRef.getRepository();
        KeyedMessage message = fromRepository.getId() == toRepository.getId() ? this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.empty.samerepository", new Object[]{toRef.getDisplayId(), fromRef.getDisplayId(), toRepository.getSlug()}) : (fromRepository.getProject().getId() == toRepository.getProject().getId() ? this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.empty.sameproject", new Object[]{toRef.getDisplayId(), toRepository.getSlug(), fromRef.getDisplayId(), fromRepository.getSlug()}) : this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.empty", new Object[]{toRef.getDisplayId(), toRepository.getProject().getName(), toRepository.getSlug(), fromRef.getDisplayId(), fromRepository.getProject().getName(), fromRepository.getSlug()}));
        throw new EmptyPullRequestException(message, fromRef, toRef);
    }

    private PullRequestSearchCriteria toCriteria(PullRequestSearchRequest request) {
        return new PullRequestSearchCriteria.Builder().closedSince(request.getClosedSince()).draft(this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_DRAFTS) ? request.isDraft() : null).filterText(request.getFilterText()).fromRefIds((Iterable)request.getFromRefIds()).fromRepositoryId(request.getFromRepositoryId()).orders(this.getPullRequestOrders(request)).participants(this.toParticipantCriteria(request.getParticipants())).state(request.getState()).toRefIds((Iterable)request.getToRefIds()).toRepositoryId(request.getToRepositoryId()).updatedSince(request.getUpdatedSince()).withDescription(request.isWithDescription()).build();
    }

    private Iterable<PullRequestParticipantCriteria> toParticipantCriteria(Collection<PullRequestParticipantRequest> requests) {
        Set usernames = (Set)requests.stream().map(request -> IdentifierUtils.toLowerCase((String)request.getUsername())).collect(MoreCollectors.toImmutableSet());
        Map usersByName = this.userService.getUsersByName(usernames, true).stream().collect(Collectors.toMap(user -> IdentifierUtils.toLowerCase((String)user.getName()), Function.identity()));
        if (usersByName.size() != usernames.size()) {
            throw new IllegalArgumentException("User couldn't not be found while resolving participant request");
        }
        ImmutableListMultimap usernameToRequests = Multimaps.index(requests, request -> IdentifierUtils.toLowerCase((String)request.getUsername()));
        return (Iterable)usernameToRequests.keySet().stream().map(arg_0 -> DefaultPullRequestService.lambda$toParticipantCriteria$36(usersByName, (Multimap)usernameToRequests, arg_0)).collect(MoreCollectors.toImmutableList());
    }

    private String trimRightToNull(String description) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.stripEnd((String)description, null), null);
    }

    private void validateCanUpdateReviewer(int repositoryId, String username) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null || !currentUser.getName().equals(username) && !this.permissionService.hasRepositoryPermission(repositoryId, Permission.REPO_WRITE)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.reviewers.permissions.insufficient", new Object[0]));
        }
    }

    private ApplicationUser validateCurrentUser() {
        ApplicationUser committer = this.authenticationContext.getCurrentUser();
        if (committer == null) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.anonymous", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)committer.getEmailAddress())) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.committer.email", new Object[]{committer.getName()}));
        }
        return committer;
    }

    private InternalPullRequest validatePullRequestState(PullRequestMergeRequest request) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail((AbstractPullRequestRequest)request, request.getVersion());
        this.checkRepositoryNotArchived((Repository)pullRequest.getScopeRepository());
        if (pullRequest.isLocked()) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.merging", new Object[0]));
        }
        this.checkIsOpen(pullRequest);
        this.checkIsNotDraft(pullRequest);
        InternalPullRequestRef fromRef = pullRequest.getFromRef();
        InternalPullRequestRef toRef = pullRequest.getToRef();
        InternalRepository repository = toRef.getRepository();
        if (!Objects.equals(repository.getHierarchyId(), fromRef.getRepository().getHierarchyId())) {
            throw new UnsupportedOperationException(this.i18nService.getMessage("bitbucket.service.pullrequest.merge.notsamehierarchy", new Object[0]));
        }
        return pullRequest;
    }

    private static /* synthetic */ PullRequestParticipantCriteria lambda$toParticipantCriteria$36(Map usersByName, Multimap usernameToRequests, String username) {
        ApplicationUser user = (ApplicationUser)usersByName.get(username);
        if (user == null) {
            throw new IllegalArgumentException("User couldn't not be found while resolving participant request");
        }
        Set roles = usernameToRequests.get((Object)username).stream().map(PullRequestParticipantRequest::getRole).collect(Collectors.toSet());
        Set statuses = usernameToRequests.get((Object)username).stream().map(PullRequestParticipantRequest::getStatuses).flatMap(Collection::stream).collect(Collectors.toSet());
        return new PullRequestParticipantCriteria.Builder(user).statuses(statuses).roles(roles).build();
    }

    private /* synthetic */ Object lambda$cleanup$22(InternalPullRequest pullRequest, Repository repository) throws RuntimeException {
        this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest).effectiveDiff().call();
        log.debug("Resolved up-to-date diff for {}/{}", (Object)repository, (Object)pullRequest.getScopedId());
        return null;
    }

    private /* synthetic */ Ref lambda$checkIfPullRequestNeedsRescoping$20(PullRequestRef fromRef) throws RuntimeException {
        return this.refService.resolveRef(new ResolveRefRequest.Builder(fromRef.getRepository()).refId(fromRef.getId()).build());
    }

    private class AcceptMergePullRequestOperation
    implements UncheckedOperation<String> {
        private final Date date;
        private final String expectedTargetHash;
        private final String mergeHash;
        private final InternalPullRequest pullRequest;

        private AcceptMergePullRequestOperation(Date date, String expectedTargetHash, String mergeHash, InternalPullRequest pullRequest) {
            this.date = date;
            this.expectedTargetHash = expectedTargetHash;
            this.pullRequest = pullRequest;
            this.mergeHash = mergeHash;
        }

        public String perform() {
            Branch updatedBranch;
            LockHelper lock = new LockHelper(this.date, this.pullRequest);
            InternalPullRequest locked = lock.lock(this.pullRequest);
            try {
                Command command = DefaultPullRequestService.this.scmService.getPullRequestCommandFactory((PullRequest)this.pullRequest).acceptMerge(new PullRequestAcceptMergeCommandParameters.Builder().mergeCommitHash(this.mergeHash).expectedTargetCommitHash(this.expectedTargetHash).build());
                command.setTimeout(DefaultPullRequestService.this.mergeTimeout);
                updatedBranch = (Branch)command.call();
            }
            catch (RuntimeException e) {
                lock.unlockWithRetries(locked, false);
                throw e;
            }
            lock.unlockWithRetries(locked, true);
            return updatedBranch.getLatestCommit();
        }
    }

    private static class CountingCommitCallback
    extends AbstractCommitCallback {
        private int count;

        private CountingCommitCallback() {
        }

        public int getCount() {
            return this.count;
        }

        public boolean onCommit(@Nonnull Commit commit) {
            ++this.count;
            return true;
        }
    }

    private class PrepareMergePullRequestOperation
    implements UncheckedOperation<String> {
        private final boolean autoSubject;
        private final int commitSummaries;
        private final ApplicationUser committer;
        private final Date date;
        private final String message;
        private final InternalPullRequest pullRequest;
        private final String strategyId;
        private final String temporaryBranchName;

        private PrepareMergePullRequestOperation(InternalPullRequest pullRequest, ApplicationUser committer, Date date, boolean autoSubject, String message, int commitSummaries, String strategyId, String temporaryBranchName) {
            this.autoSubject = autoSubject;
            this.committer = committer;
            this.commitSummaries = commitSummaries;
            this.date = date;
            this.message = message;
            this.pullRequest = pullRequest;
            this.strategyId = strategyId;
            this.temporaryBranchName = temporaryBranchName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String perform() throws RuntimeException {
            String mergeHash;
            LockHelper lock = new LockHelper(this.date, this.pullRequest);
            MergeOperationHelper helper = new MergeOperationHelper(this.autoSubject, this.committer, this.message, this.pullRequest);
            InternalPullRequest locked = lock.lock(this.pullRequest);
            try {
                Command command = DefaultPullRequestService.this.scmService.getPullRequestCommandFactory((PullRequest)locked).prepareMerge(((PullRequestPrepareMergeCommandParameters.Builder)((PullRequestPrepareMergeCommandParameters.Builder)((PullRequestPrepareMergeCommandParameters.Builder)((PullRequestPrepareMergeCommandParameters.Builder)((PullRequestPrepareMergeCommandParameters.Builder)new PullRequestPrepareMergeCommandParameters.Builder().author(helper.chooseAuthor())).committer(this.committer)).commitSummaries(this.commitSummaries)).message(helper.buildMergeMessage())).strategyId(this.strategyId)).temporaryBranchName(this.temporaryBranchName).build());
                command.setTimeout(DefaultPullRequestService.this.mergeTimeout);
                Branch branch = (Branch)command.call();
                if (branch == null) {
                    log.error("{}: Preparing the merge of pull request {} succeeded but no merge hash was available", (Object)locked.getScopeRepository(), (Object)locked.getId());
                    mergeHash = null;
                } else {
                    mergeHash = branch.getLatestCommit();
                }
            }
            finally {
                lock.unlockWithRetries(locked, false);
            }
            return mergeHash;
        }
    }

    private static class IsEmptyCommitCallback
    extends AbstractCommitCallback {
        private boolean empty = true;

        private IsEmptyCommitCallback() {
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public boolean onCommit(@Nonnull Commit commit) {
            this.empty = false;
            return false;
        }
    }

    private class PullRequestRefCleanupTask
    implements Runnable {
        private final PullRequestRefCleanupRequest request;

        private PullRequestRefCleanupTask(PullRequestRefCleanupRequest request) {
            this.request = request;
        }

        @Override
        public void run() {
            DefaultPullRequestService.this.withNewTransaction.execute(status -> {
                InternalPullRequest pullRequest = DefaultPullRequestService.this.pullRequestDao.findByRepositoryScopedId(this.request.getRepositoryId(), this.request.getPullRequestId());
                if (pullRequest == null) {
                    log.trace("Pull request with #{} not found in the repository with ID {}, so trying to delete it in SCM", (Object)this.request.getPullRequestId(), (Object)this.request.getRepositoryId());
                    DefaultPullRequestService.this.internalDeletePullRequestInScm(this.request);
                } else if (pullRequest.getState() == PullRequestState.DECLINED) {
                    DefaultPullRequestService.this.internalDoUpdateRefsInScm(this.request, (PullRequest)pullRequest);
                    DefaultPullRequestService.this.pullRequestDao.refresh((Object)pullRequest);
                    if (pullRequest.isOpen()) {
                        log.debug("[{}] Pull request #{} was re-opened after it's refs were updated, so updating the refs again", (Object)pullRequest.getToRef().getRepository(), (Object)pullRequest.getId());
                        DefaultPullRequestService.this.internalDoUpdateRefsInScm(new PullRequestRefCleanupRequest(this.request), (PullRequest)pullRequest);
                    }
                } else {
                    DefaultPullRequestService.this.internalDoUpdateRefsInScm(this.request, (PullRequest)pullRequest);
                }
                return null;
            });
        }
    }

    private class MergePullRequestOperation
    implements UncheckedOperation<String> {
        private final boolean autoMerge;
        private final boolean autoSubject;
        private final int commitSummaries;
        private final ApplicationUser committer;
        private final Date date;
        private final String message;
        private final InternalPullRequest pullRequest;
        private final String strategyId;

        private MergePullRequestOperation(InternalPullRequest pullRequest, ApplicationUser committer, Date date, boolean autoSubject, String message, int commitSummaries, String strategyId, boolean autoMerge) {
            this.autoMerge = autoMerge;
            this.autoSubject = autoSubject;
            this.committer = committer;
            this.commitSummaries = commitSummaries;
            this.date = date;
            this.message = message;
            this.pullRequest = pullRequest;
            this.strategyId = strategyId;
        }

        public String perform() throws RuntimeException {
            String mergeHash;
            LockHelper lock = new LockHelper(this.date, this.pullRequest);
            MergeOperationHelper helper = new MergeOperationHelper(this.autoSubject, this.committer, this.message, this.pullRequest);
            InternalPullRequest locked = lock.lock(this.pullRequest);
            try {
                Command command = DefaultPullRequestService.this.scmService.getPullRequestCommandFactory((PullRequest)locked).merge(((PullRequestMergeCommandParameters.Builder)((PullRequestMergeCommandParameters.Builder)((PullRequestMergeCommandParameters.Builder)((PullRequestMergeCommandParameters.Builder)((PullRequestMergeCommandParameters.Builder)new PullRequestMergeCommandParameters.Builder().author(helper.chooseAuthor())).autoMerge(this.autoMerge).committer(this.committer)).commitSummaries(this.commitSummaries)).message(helper.buildMergeMessage())).strategyId(this.strategyId)).build());
                command.setTimeout(DefaultPullRequestService.this.mergeTimeout);
                Branch branch = (Branch)command.call();
                if (branch == null) {
                    log.error("{}: Merge of pull request {} succeeded but no merge hash was available", (Object)locked.getScopeRepository(), (Object)locked.getId());
                    mergeHash = null;
                } else {
                    mergeHash = branch.getLatestCommit();
                }
            }
            catch (RuntimeException e) {
                lock.unlockWithRetries(locked, false);
                throw e;
            }
            lock.unlockWithRetries(locked, true);
            return mergeHash;
        }
    }

    private static class ScopedChangeCallback
    implements ChangeCallback {
        private final ChangeCallback delegate;
        private final Map<String, Object> properties;

        ScopedChangeCallback(@Nonnull ChangeCallback delegate, @Nonnull Map<String, Object> properties) {
            this.properties = Objects.requireNonNull(properties, "properties");
            this.delegate = Objects.requireNonNull(delegate, "delegate");
        }

        public boolean onChange(@Nonnull Change change) throws IOException {
            return this.delegate.onChange(change);
        }

        public void onEnd(@Nonnull ChangeSummary summary) throws IOException {
            this.delegate.onEnd(summary);
        }

        public void onStart(@Nonnull ChangeContext context) throws IOException {
            this.delegate.onStart(((ChangeContext.Builder)new ChangeContext.Builder(context).properties(this.properties)).build());
        }
    }

    private class MergeOperationHelper {
        private final boolean autoSubject;
        private final ApplicationUser committer;
        private final InternalPullRequestRef fromRef;
        private final String message;
        private final InternalPullRequest pullRequest;
        private final InternalPullRequestRef toRef;

        public MergeOperationHelper(boolean autoSubject, ApplicationUser committer, String message, InternalPullRequest pullRequest) {
            this.autoSubject = autoSubject;
            this.committer = committer;
            this.message = message;
            this.pullRequest = pullRequest;
            this.toRef = pullRequest.getToRef();
            this.fromRef = pullRequest.getFromRef();
        }

        private String buildMergeMessage() {
            if (this.autoSubject) {
                String subject = this.buildSubject();
                if (StringUtils.isBlank((CharSequence)this.message)) {
                    return subject;
                }
                return subject + "\n\n" + this.message;
            }
            return this.message;
        }

        private String buildSubject() {
            String format = this.pullRequest.isCrossRepository() ? DefaultPullRequestService.SUBJECT_INTER_REPOSITORY : DefaultPullRequestService.SUBJECT_INTRA_REPOSITORY;
            return String.format(format, this.pullRequest.getId(), this.message, this.toRef.getRepository().getProject().getKey(), this.toRef.getRepository().getSlug(), this.toRef.getDisplayId(), this.fromRef.getRepository().getProject().getKey(), this.fromRef.getRepository().getSlug(), this.fromRef.getDisplayId());
        }

        private ApplicationUser chooseAuthor() {
            if (DefaultPullRequestService.this.pullRequestMergeAuthor == PullRequestCommitAuthor.ACTOR) {
                return this.committer;
            }
            ApplicationUser author = this.pullRequest.getAuthor().getUser();
            if (StringUtils.isBlank((CharSequence)author.getEmailAddress())) {
                log.info("{}:{} {} does not have an e-mail address; falling back on merger as author", new Object[]{this.pullRequest.getScopeRepository(), this.pullRequest.getId(), author.getName()});
                return this.committer;
            }
            return author;
        }
    }

    private class LockHelper {
        private final Date date;
        private final InternalPullRequest pullRequest;
        private InternalPullRequestRef fromRef;
        private InternalPullRequestRef toRef;

        private LockHelper(Date date, InternalPullRequest pullRequest) {
            this.date = date;
            this.pullRequest = pullRequest;
        }

        private InternalPullRequest lock(InternalPullRequest pullRequest) {
            InternalPullRequest locked = this.updateState(pullRequest, false, true);
            DefaultPullRequestService.this.pullRequestDao.refresh((Object)pullRequest);
            this.toRef = pullRequest.getToRef();
            this.fromRef = pullRequest.getFromRef();
            return locked;
        }

        private void unlockWithRetries(InternalPullRequest pr, boolean mergeSucceeded) {
            int attempt = 1;
            while (true) {
                try {
                    this.updateState(pr, mergeSucceeded, false);
                    return;
                }
                catch (RuntimeException e) {
                    if (attempt >= 10) {
                        log.warn("{}: Failed to unlock pull request {} ({} attempts)", new Object[]{this.pullRequest.getScopeRepository(), this.pullRequest.getId(), attempt});
                        throw e;
                    }
                    ++attempt;
                    continue;
                }
                break;
            }
        }

        private InternalPullRequest updateState(InternalPullRequest pr, boolean setMerged, boolean locked) {
            return (InternalPullRequest)DefaultPullRequestService.this.withNewTransaction.execute(status -> {
                DefaultPullRequestService.this.pullRequestDao.refresh((Object)pr);
                InternalPullRequest.Builder builder = new InternalPullRequest.Builder(pr).locked(locked).updatedDate(this.date);
                if (setMerged) {
                    builder.fromRef(new InternalPullRequestRef.Builder(this.fromRef).build()).state(PullRequestState.MERGED).closedDate(this.date).toRef(new InternalPullRequestRef.Builder(this.toRef).build());
                }
                return (InternalPullRequest)DefaultPullRequestService.this.pullRequestDao.update((Object)builder.build());
            });
        }
    }
}

