/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestSupplier;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.RewriteExceptions;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.PullRequestDao;
import jakarta.annotation.Nullable;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@RewriteExceptions
public class DefaultPullRequestSupplier
extends AbstractService
implements PullRequestSupplier {
    protected final FeatureManager featureManager;
    protected final PullRequestDao pullRequestDao;

    public DefaultPullRequestSupplier(FeatureManager featureManager, PullRequestDao pullRequestDao) {
        this.featureManager = featureManager;
        this.pullRequestDao = pullRequestDao;
    }

    @Nullable
    @PostAuthorize(value="hasRepositoryPermission(returnObject?.scopeRepository, 'REPO_READ')")
    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    public InternalPullRequest getById(int repositoryId, long pullRequestId) {
        InternalPullRequest pullRequest = this.pullRequestDao.findByRepositoryScopedId(repositoryId, pullRequestId);
        return pullRequest != null && this.isDraftPullRequestAndFeatureFlagDisabled(pullRequest) ? new InternalPullRequest.Builder(pullRequest).draft(false).build() : pullRequest;
    }

    private boolean isDraftPullRequestAndFeatureFlagDisabled(InternalPullRequest pullRequest) {
        return this.featureManager.isDisabled((Feature)StandardFeature.PULL_REQUEST_DRAFTS) && pullRequest.isDraft();
    }
}

