/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.graph.CommitGraphContext;
import com.atlassian.bitbucket.commit.graph.CommitGraphNode;
import com.atlassian.bitbucket.event.pull.PullRequestMergedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionPredicateFactory;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestCommitSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.pull.RescopeDetails;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.CommitCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.bulk.BulkTraversalCallback;
import com.atlassian.bitbucket.scm.bulk.BulkTraversalStatus;
import com.atlassian.bitbucket.scm.bulk.BulkTraversalSummary;
import com.atlassian.bitbucket.scm.bulk.BulkTraverseCommitsCommandParameters;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestCommit;
import com.atlassian.stash.internal.pull.PullRequestCommitDao;
import com.atlassian.stash.internal.pull.PullRequestCommitSearchCriteria;
import com.atlassian.stash.internal.pull.PullRequestDao;
import com.atlassian.stash.internal.pull.PullRequestEnricher;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="pullRequestCommitHelper")
public class InternalPullRequestCommitHelper {
    private static final Logger log = LoggerFactory.getLogger(InternalPullRequestCommitHelper.class);
    private final ExecutorService executorService;
    private final PermissionValidationService permissionValidationService;
    private final PermissionPredicateFactory predicateFactory;
    private final PullRequestCommitDao pullRequestCommitDao;
    private final PullRequestDao pullRequestDao;
    private final PullRequestEnricher pullRequestEnricher;
    private final ScmService scmService;
    private final TransactionTemplate withNewTransaction;
    @Value(value="${pullrequest.commit.indexing.maximum.commits}")
    private int maxCommitsToIndexAtOnce;
    @Value(value="${page.max.pullrequests}")
    private int maxPullRequests;

    @Autowired
    public InternalPullRequestCommitHelper(ExecutorService executorService, PermissionValidationService permissionValidationService, PermissionPredicateFactory predicateFactory, PullRequestCommitDao pullRequestCommitDao, PullRequestDao pullRequestDao, PullRequestEnricher pullRequestEnricher, ScmService scmService, PlatformTransactionManager transactionManager) {
        this.executorService = executorService;
        this.permissionValidationService = permissionValidationService;
        this.predicateFactory = predicateFactory;
        this.pullRequestCommitDao = pullRequestCommitDao;
        this.pullRequestDao = pullRequestDao;
        this.pullRequestEnricher = pullRequestEnricher;
        this.scmService = scmService;
        this.withNewTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    public long countByCommit(@Nonnull PullRequestCommitSearchRequest request) {
        Objects.requireNonNull(request, "request");
        this.permissionValidationService.validateAuthenticated();
        return this.pullRequestCommitDao.count(this.toCriteria(request));
    }

    @EventListener
    public void onPullRequestMerged(PullRequestMergedEvent pullRequestMergedEvent) {
        this.executorService.submit(() -> this.reindexAfterMerge(pullRequestMergedEvent.getPullRequest(), pullRequestMergedEvent.getCommit()));
    }

    public boolean reindex(InternalPullRequest pullRequest) {
        long globalPullRequestId = pullRequest.getGlobalId();
        this.deleteCommitsByPullRequest(globalPullRequestId);
        String fromCommit = this.getFromCommit((PullRequest)pullRequest);
        String toCommit = pullRequest.getToRef().getLatestCommit();
        CommitGraphContext context = new CommitGraphContext.Builder().exclude(toCommit, new String[0]).include(fromCommit, new String[0]).build();
        LimitedTraversalCommitCollectingCallback callback = new LimitedTraversalCommitCollectingCallback(context);
        this.traversePullRequestCommits(callback, pullRequest, fromCommit, toCommit);
        Set<String> commitIds = callback.getCommitIds();
        if (commitIds.size() >= this.maxCommitsToIndexAtOnce) {
            log.info("Full index of pull request {} exceeded maximum number of commits and was truncated", (Object)globalPullRequestId);
        }
        log.debug("Indexing: linking PR {} with {} commit(s) using include: {}", new Object[]{globalPullRequestId, commitIds.size(), fromCommit});
        commitIds.forEach(commitId -> this.pullRequestCommitDao.create((Object)new InternalPullRequestCommit.Builder(commitId, pullRequest).build()));
        return commitIds.size() > 0;
    }

    @Nonnull
    public Page<PullRequest> searchByCommit(@Nonnull PullRequestCommitSearchRequest request, @Nonnull PageRequest pageRequest) {
        Page<InternalPullRequest> page;
        Objects.requireNonNull(request, "request");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxPullRequests);
        PullRequestCommitSearchCriteria criteria = this.toCriteria(request);
        Integer toRepositoryId = request.getToRepositoryId();
        if (toRepositoryId == null) {
            page = this.pullRequestCommitDao.searchPullRequests(criteria, pageRequest, this.predicateFactory.createPullRequestPermissionPredicate(Permission.REPO_READ));
        } else {
            this.permissionValidationService.validateRepositoryAccessible(toRepositoryId.intValue());
            page = this.pullRequestCommitDao.searchPullRequests(criteria, pageRequest);
        }
        if (page.getSize() > 0) {
            page = this.pullRequestEnricher.enrich(page);
        }
        return PageUtils.asPageOf(PullRequest.class, (Page)page);
    }

    public void updateOrDeleteCommits(InternalPullRequest pullRequest, RescopeDetails addedRescopeDetails, RescopeDetails removedRescopeDetails) {
        try {
            this.updateCommits(pullRequest, addedRescopeDetails, removedRescopeDetails);
        }
        catch (Exception e) {
            log.warn("{}: Error performing incremental update of commits for pull request {}", new Object[]{pullRequest.getScopeRepository(), pullRequest.getId(), e});
            this.deleteCommitsByPullRequest(pullRequest.getGlobalId());
        }
    }

    private void deleteCommitsByPullRequest(long globalPullRequestId) {
        this.pullRequestCommitDao.deleteByPullRequest(globalPullRequestId);
    }

    @Nonnull
    private List<Commit> getCommits(RescopeDetails rescopeDetails) {
        return rescopeDetails == null ? Collections.emptyList() : rescopeDetails.getCommits();
    }

    private String getFromCommit(PullRequest pullRequest) {
        PullRequestRef fromRef = pullRequest.getFromRef();
        if (fromRef.getType() == StandardRefType.TAG) {
            CommitCommandParameters parameters = ((CommitCommandParameters.Builder)new CommitCommandParameters.Builder().commitId(fromRef.getLatestCommit())).maxMessageLength(0).build();
            Commit fromCommit = (Commit)this.scmService.getCommandFactory(fromRef.getRepository()).commit(parameters).call();
            return fromCommit == null ? fromRef.getLatestCommit() : fromCommit.getId();
        }
        return fromRef.getLatestCommit();
    }

    private boolean isCommitListComplete(RescopeDetails rescopeDetails) {
        return rescopeDetails != null && rescopeDetails.getTotal() == rescopeDetails.getCommits().size();
    }

    private void performIncrementalIndex(InternalPullRequest pullRequest, RescopeDetails addedRescopeDetails, RescopeDetails removedRescopeDetails) {
        List<Commit> removedCommits = this.getCommits(removedRescopeDetails);
        for (Commit commit : removedCommits) {
            this.pullRequestCommitDao.deleteById((Object)new InternalPullRequestCommit.PK(commit.getId(), pullRequest.getGlobalId()));
        }
        List<Commit> addedCommits = this.getCommits(addedRescopeDetails);
        for (Commit commit : addedCommits) {
            this.pullRequestCommitDao.create((Object)new InternalPullRequestCommit.Builder(commit.getId(), pullRequest).build());
        }
    }

    private void reindexAfterMerge(PullRequest pullRequest, MinimalCommit merge) {
        InternalPullRequest internalPullRequest = InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest);
        long globalPullRequestId = InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest).getGlobalId();
        this.withNewTransaction.execute(status -> {
            this.deleteCommitsByPullRequest(globalPullRequestId);
            return null;
        });
        String fromCommit = this.getFromCommit(pullRequest);
        String toCommit = pullRequest.getToRef().getLatestCommit();
        String mergeCommit = merge == null ? toCommit : merge.getId();
        CommitGraphContext context = new CommitGraphContext.Builder().exclude(toCommit, new String[0]).include(fromCommit, new String[]{mergeCommit}).build();
        this.traversePullRequestCommits(new BatchedTraversalCommitCreatingCallback(context, globalPullRequestId), internalPullRequest, fromCommit, mergeCommit);
    }

    private PullRequestCommitSearchCriteria toCriteria(PullRequestCommitSearchRequest request) {
        return new PullRequestCommitSearchCriteria.Builder(request).build();
    }

    private void traversePullRequestCommits(BulkTraversalCallback callback, InternalPullRequest pullRequest, String include, String ... includes) {
        this.scmService.getBulkContentCommandFactory((Repository)pullRequest.getToRef().getRepository()).traverseCommits(new BulkTraverseCommitsCommandParameters.Builder().alternates((Repository)pullRequest.getFromRef().getRepository(), new Repository[0]).include(include, includes).build(), callback).call();
    }

    private void updateCommits(InternalPullRequest pullRequest, RescopeDetails addedRescopeDetails, RescopeDetails removedRescopeDetails) {
        if (this.isCommitListComplete(addedRescopeDetails) && this.isCommitListComplete(removedRescopeDetails) && this.pullRequestCommitDao.countByPullRequest(pullRequest.getGlobalId()) != 0L) {
            this.performIncrementalIndex(pullRequest, addedRescopeDetails, removedRescopeDetails);
        } else {
            this.reindex(pullRequest);
        }
    }

    private class LimitedTraversalCommitCollectingCallback
    implements BulkTraversalCallback {
        private final Set<String> commitIds;
        private final CommitGraphContext context;

        private LimitedTraversalCommitCollectingCallback(CommitGraphContext context) {
            this.context = Objects.requireNonNull(context, "context");
            this.commitIds = new HashSet<String>();
        }

        public Set<String> getCommitIds() {
            return this.commitIds;
        }

        public BulkTraversalStatus onNode(@Nonnull CommitGraphNode node) {
            if (this.context.visit(node)) {
                this.commitIds.add(node.getCommit().getId());
            }
            return this.context.isTraversing() && this.commitIds.size() < InternalPullRequestCommitHelper.this.maxCommitsToIndexAtOnce ? BulkTraversalStatus.CONTINUE : BulkTraversalStatus.FINISH;
        }
    }

    private class BatchedTraversalCommitCreatingCallback
    implements BulkTraversalCallback {
        private final List<String> commitIds;
        private final CommitGraphContext context;
        private final long globalPullRequestId;
        private final Set<String> includes;

        private BatchedTraversalCommitCreatingCallback(CommitGraphContext context, long globalPullRequestId) {
            this.context = Objects.requireNonNull(context, "context");
            this.globalPullRequestId = globalPullRequestId;
            this.commitIds = new ArrayList<String>(InternalPullRequestCommitHelper.this.maxCommitsToIndexAtOnce);
            this.includes = new HashSet<String>(context.getIncludes());
        }

        public void onEnd(@Nonnull BulkTraversalSummary summary) {
            if (!this.commitIds.isEmpty()) {
                this.commitBatch();
            }
        }

        public BulkTraversalStatus onNode(@Nonnull CommitGraphNode node) {
            if (this.context.visit(node)) {
                this.commitIds.add(node.getCommit().getId());
                if (this.commitIds.size() >= InternalPullRequestCommitHelper.this.maxCommitsToIndexAtOnce) {
                    this.commitBatch();
                }
            }
            return this.context.isTraversing() ? BulkTraversalStatus.CONTINUE : BulkTraversalStatus.FINISH;
        }

        private void commitBatch() {
            log.debug("Batch indexing: linking PR {} with {} commit(s) using include(s): {}", new Object[]{this.globalPullRequestId, this.commitIds.size(), this.includes});
            InternalPullRequestCommitHelper.this.withNewTransaction.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(@Nonnull TransactionStatus status) {
                    InternalPullRequest pullRequest = (InternalPullRequest)InternalPullRequestCommitHelper.this.pullRequestDao.loadById((Object)BatchedTraversalCommitCreatingCallback.this.globalPullRequestId);
                    BatchedTraversalCommitCreatingCallback.this.commitIds.forEach(commitId -> InternalPullRequestCommitHelper.this.pullRequestCommitDao.create((Object)new InternalPullRequestCommit.Builder(commitId, pullRequest).build()));
                }
            });
            this.commitIds.clear();
        }
    }
}

