/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.event.pull.PullRequestActivityEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantApprovedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantReviewedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantUnapprovedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantsUpdatedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestRescopedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReviewersUpdatedActivityEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReviewersUpdatedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.IllegalPullRequestStateException;
import com.atlassian.bitbucket.pull.InvalidPullRequestParticipantException;
import com.atlassian.bitbucket.pull.InvalidPullRequestParticipantsException;
import com.atlassian.bitbucket.pull.InvalidPullRequestReviewersException;
import com.atlassian.bitbucket.pull.InvalidPullRequestRoleException;
import com.atlassian.bitbucket.pull.NoSuchParticipantException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestOutOfDateException;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestReviewersUpdatedActivity;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.UnmodifiablePullRequestRoleException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.UserUtils;
import com.atlassian.bitbucket.watcher.UnwatchRequest;
import com.atlassian.bitbucket.watcher.WatchRequest;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.WatcherService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipant;
import com.atlassian.stash.internal.pull.InternalPullRequestReviewersUpdatedActivity;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.pull.PullRequestParticipantDao;
import com.atlassian.stash.internal.pull.PullRequestParticipantSearchCriteria;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.util.InternalPageUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.Principal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="pullRequestParticipantHelper")
public class InternalPullRequestParticipantHelper {
    private final PullRequestActivityDao activityDao;
    private final AuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PullRequestParticipantDao participantDao;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;
    private final WatcherService watcherService;
    @Value(value="${page.max.users}")
    private int maxUserPageSize;

    @Autowired
    public InternalPullRequestParticipantHelper(PullRequestActivityDao activityDao, AuthenticationContext authenticationContext, EventPublisher eventPublisher, I18nService i18nService, PullRequestParticipantDao participantDao, PermissionService permissionService, PermissionValidationService permissionValidationService, PlatformTransactionManager transactionManager, UserService userService, WatcherService watcherService) {
        this.activityDao = activityDao;
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.participantDao = participantDao;
        this.permissionValidationService = permissionValidationService;
        this.permissionService = permissionService;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.userService = userService;
        this.watcherService = watcherService;
    }

    @Nonnull
    public InternalPullRequestParticipant addReviewer(@Nonnull InternalPullRequest pullRequest, @Nonnull ApplicationUser applicationUser) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(applicationUser, "applicationUser");
        this.checkAccess(applicationUser, pullRequest);
        this.checkCanUpdateRole(pullRequest);
        InternalApplicationUser user = InternalConverter.convertToInternalUser((ApplicationUser)applicationUser);
        InternalPullRequestParticipant participant = this.participantDao.findByPullRequestAndUser(pullRequest.getGlobalId(), user.getId());
        if (participant == null) {
            return this.createReviewer(pullRequest, user);
        }
        if (participant.getRole() == PullRequestRole.AUTHOR) {
            throw new UnmodifiablePullRequestRoleException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.role.assign.unmodifiable", new Object[0]));
        }
        if (participant.getRole() != PullRequestRole.REVIEWER) {
            participant = this.updateParticipant(participant, null, PullRequestRole.REVIEWER, null);
            this.watcherService.watch(((WatchRequest.Builder)new WatchRequest.Builder((Watchable)pullRequest).user((ApplicationUser)user)).build());
        }
        return participant;
    }

    public void createInitialParticipants(@Nonnull InternalPullRequest pullRequest, @Nonnull ApplicationUser author, @Nonnull Set<ApplicationUser> reviewers) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(reviewers, "reviewers");
        if (!pullRequest.getAllParticipants().isEmpty()) {
            throw new IllegalArgumentException("The pull request must not have any existing participants when creating initial participants");
        }
        this.addParticipant(pullRequest, InternalConverter.convertToInternalUser((ApplicationUser)author), PullRequestRole.AUTHOR);
        reviewers.forEach(reviewer -> this.addParticipant(pullRequest, InternalConverter.convertToInternalUser((ApplicationUser)reviewer), PullRequestRole.REVIEWER));
    }

    @Nonnull
    public Page<InternalPullRequestParticipant> getParticipants(@Nonnull InternalPullRequest pullRequest, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(pageRequest, "pageRequest");
        return this.participantDao.findByPullRequest(pullRequest.getGlobalId(), pageRequest);
    }

    public void importParticipants(@Nonnull InternalPullRequest pullRequest, @Nonnull ApplicationUser author, @Nonnull Set<ApplicationUser> reviewers, @Nonnull Set<ApplicationUser> otherParticipants, @Nonnull Map<String, PullRequestParticipantStatus> statusesByParticipant, @Nonnull Map<String, String> lastReviewCommitsByParticipant) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(reviewers, "reviewers");
        Objects.requireNonNull(otherParticipants, "otherParticipants");
        Objects.requireNonNull(statusesByParticipant, "statusesByParticipant");
        Objects.requireNonNull(lastReviewCommitsByParticipant, "lastReviewCommitsByParticipant");
        if (!pullRequest.getAllParticipants().isEmpty()) {
            throw new IllegalArgumentException("The pull request must not have any existing participants when importing participants");
        }
        this.importParticipant(pullRequest, InternalConverter.convertToInternalUser((ApplicationUser)author), PullRequestRole.AUTHOR, statusesByParticipant.get(author.getName()), lastReviewCommitsByParticipant.get(author.getName()));
        reviewers.forEach(reviewer -> this.importParticipant(pullRequest, InternalConverter.convertToInternalUser((ApplicationUser)reviewer), PullRequestRole.REVIEWER, (PullRequestParticipantStatus)statusesByParticipant.get(reviewer.getName()), (String)lastReviewCommitsByParticipant.get(reviewer.getName())));
        Sets.difference((Set)Sets.difference(otherParticipants, Collections.singleton(author)), reviewers).forEach(otherParticipant -> this.importParticipant(pullRequest, InternalConverter.convertToInternalUser((ApplicationUser)otherParticipant), PullRequestRole.PARTICIPANT, (PullRequestParticipantStatus)statusesByParticipant.get(otherParticipant.getName()), (String)lastReviewCommitsByParticipant.get(otherParticipant.getName())));
    }

    @Nonnull
    public InternalPullRequestParticipant makeCurrentUserParticipantAndWatcher(@Nonnull InternalPullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        return this.makeParticipantAndWatcher(pullRequest, (ApplicationUser)this.getCurrentUser());
    }

    @Nonnull
    public InternalPullRequestParticipant makeParticipantAndWatcher(@Nonnull InternalPullRequest pullRequest, @Nonnull ApplicationUser applicationUser) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(applicationUser, "applicationUser");
        InternalApplicationUser user = InternalConverter.convertToInternalUser((ApplicationUser)applicationUser);
        InternalPullRequestParticipant participant = this.participantDao.findByPullRequestAndUser(pullRequest.getGlobalId(), user.getId());
        return participant == null ? this.doMakeParticipantAndWatcher(pullRequest, user) : participant;
    }

    @EventListener
    public void onPullRequestRescoped(PullRequestRescopedEvent rescopedEvent) {
        if (rescopedEvent.isFromHashUpdated()) {
            InternalPullRequest pullRequest = InternalConverter.convertToInternalPullRequest((PullRequest)rescopedEvent.getPullRequest());
            this.transactionTemplate.execute(status -> this.participantDao.resetStatusByPullRequest(pullRequest.getGlobalId()));
        }
    }

    public void removeReviewer(@Nonnull InternalPullRequest pullRequest, @Nonnull ApplicationUser user) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(user, "user");
        this.checkCanUpdateRole(pullRequest);
        InternalPullRequestParticipant participant = this.participantDao.findByPullRequestAndUser(pullRequest.getGlobalId(), user.getId());
        if (participant != null) {
            boolean hasNotContributed;
            PullRequestRole previousRole = participant.getRole();
            if (previousRole == PullRequestRole.AUTHOR) {
                throw new UnmodifiablePullRequestRoleException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.role.unassign.unmodifiable", new Object[0]));
            }
            boolean bl = hasNotContributed = this.activityDao.countByUser(pullRequest.getGlobalId(), user.getId(), Collections.emptySet(), Collections.singleton(PullRequestAction.RESCOPED)) == 0L;
            if (hasNotContributed) {
                this.removeParticipant(participant);
            } else if (previousRole == PullRequestRole.REVIEWER) {
                this.updateParticipant(participant, null, PullRequestRole.PARTICIPANT, null);
            }
        }
    }

    public void resetLastReviewedCommit(@Nonnull InternalPullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        this.participantDao.resetLastReviewedCommitByPullRequest(pullRequest.getGlobalId());
    }

    @Nonnull
    public Set<ApplicationUser> resolveOtherParticipantsForImport(@Nonnull Set<String> names, @Nonnull Repository targetRepository) {
        Objects.requireNonNull(names, "names");
        Objects.requireNonNull(targetRepository, "targetRepository");
        return this.resolveParticipants(Collections.emptySet(), true, names, PullRequestRole.PARTICIPANT, targetRepository);
    }

    @Nonnull
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Set<ApplicationUser> resolveReviewers(@Nonnull Set<String> names, @Nonnull Repository targetRepository) {
        Objects.requireNonNull(names, "names");
        Objects.requireNonNull(targetRepository, "targetRepository");
        return this.resolveParticipants(Collections.emptySet(), false, names, PullRequestRole.REVIEWER, targetRepository);
    }

    @Nonnull
    public Set<ApplicationUser> resolveReviewersForImport(@Nonnull Set<String> names, @Nonnull Repository targetRepository) {
        Objects.requireNonNull(names, "names");
        Objects.requireNonNull(targetRepository, "targetRepository");
        return this.resolveParticipants(Collections.emptySet(), true, names, PullRequestRole.REVIEWER, targetRepository);
    }

    @Nonnull
    public Page<ApplicationUser> searchUsers(@Nonnull PullRequestParticipantSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        searchRequest.getFromRepository().ifPresent(repository -> this.permissionValidationService.validateForRepository(repository, Permission.REPO_READ));
        searchRequest.getToRepository().ifPresent(repository -> this.permissionValidationService.validateForRepository(repository, Permission.REPO_READ));
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        Optional filter = searchRequest.getFilter();
        if (filter.isPresent()) {
            return InternalPageUtils.filterPages(this.participantPageProvider(searchRequest), this.filterPredicate((String)filter.get()), pageRequest, this.maxUserPageSize * 2);
        }
        return this.participantPageProvider(searchRequest).get(pageRequest);
    }

    public void setReviewers(@Nonnull InternalPullRequest pullRequest, @Nonnull Set<String> newReviewerNames) {
        Set allCurrentParticipants = (Set)pullRequest.getAllParticipants().stream().map(PullRequestParticipant::getUser).collect(MoreCollectors.toImmutableSet());
        ApplicationUser author = pullRequest.getAuthor().getUser();
        Set currentReviewers = (Set)pullRequest.getReviewers().stream().map(PullRequestParticipant::getUser).collect(MoreCollectors.toImmutableSet());
        Set currentParticipants = (Set)pullRequest.getParticipants().stream().map(PullRequestParticipant::getUser).collect(MoreCollectors.toImmutableSet());
        Set nonAuthorReviewerNames = (Set)newReviewerNames.stream().filter(name -> !name.equals(author.getName())).collect(MoreCollectors.toImmutableSet());
        Set<ApplicationUser> newReviewers = this.resolveParticipants(allCurrentParticipants, false, nonAuthorReviewerNames, PullRequestRole.REVIEWER, (Repository)pullRequest.getScopeRepository());
        Sets.SetView addedReviewers = Sets.difference(newReviewers, (Set)currentReviewers);
        Sets.SetView currentNonAuthors = Sets.union((Set)currentReviewers, (Set)currentParticipants);
        Sets.SetView removedReviewers = Sets.difference((Set)currentReviewers, newReviewers);
        Sets.SetView addedParticipants = Sets.difference((Set)addedReviewers, (Set)currentNonAuthors);
        Sets.SetView removedParticipants = removedReviewers.isEmpty() ? Collections.emptySet() : Sets.difference((Set)removedReviewers, this.getUsersWithActivities(pullRequest));
        this.updateParticipants(pullRequest, (Set<ApplicationUser>)removedReviewers, (Set<ApplicationUser>)removedParticipants, (Set<ApplicationUser>)addedReviewers, (Set<ApplicationUser>)addedParticipants);
        this.fireReviewersUpdatedEvent(pullRequest, (Set<ApplicationUser>)addedReviewers, (Set<ApplicationUser>)removedReviewers);
        this.fireParticipantsUpdatedEvent(pullRequest, (Set<ApplicationUser>)addedParticipants, (Set<ApplicationUser>)removedParticipants);
        this.logReviewersUpdatedActivity(pullRequest, (Set<ApplicationUser>)addedReviewers, (Set<ApplicationUser>)removedReviewers);
    }

    @Nonnull
    public PullRequestParticipant setStatus(@Nonnull InternalPullRequest pullRequest, @Nonnull PullRequestParticipantStatus status, @Nullable String lastReviewedCommit) {
        Objects.requireNonNull(status, "status");
        this.checkCanUpdateStatus(pullRequest);
        InternalApplicationUser currentUser = this.getCurrentUser();
        InternalPullRequestParticipant participant = this.getParticipant(pullRequest, (ApplicationUser)currentUser);
        if (participant == null) {
            if (status == PullRequestParticipantStatus.UNAPPROVED) {
                throw new NoSuchParticipantException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.approve.remove.nosuchparticipant", new Object[]{currentUser.getName()}));
            }
            participant = this.doMakeParticipantAndWatcher(pullRequest, currentUser);
        }
        if (participant.getRole() == PullRequestRole.AUTHOR) {
            throw new InvalidPullRequestRoleException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.update.participantstatus.author", new Object[0]));
        }
        if (participant.getStatus() != status) {
            lastReviewedCommit = lastReviewedCommit != null ? lastReviewedCommit : pullRequest.getFromRef().getLatestCommit();
            participant = this.updateStatus(participant, lastReviewedCommit, status);
        }
        return participant;
    }

    private InternalPullRequestParticipant addParticipant(InternalPullRequest pullRequest, InternalApplicationUser user, PullRequestRole role) {
        InternalPullRequestParticipant participant = (InternalPullRequestParticipant)this.participantDao.create((Object)((InternalPullRequestParticipant.Builder)new InternalPullRequestParticipant.Builder(pullRequest).role(role).user(user)).build());
        this.watcherService.watch(((WatchRequest.Builder)new WatchRequest.Builder((Watchable)pullRequest).user((ApplicationUser)user)).build());
        return participant;
    }

    private void checkAccess(ApplicationUser user, InternalPullRequest pullRequest) {
        this.validateCanAccess(user, (Repository)pullRequest.getScopeRepository()).ifPresent(message -> {
            throw new InvalidPullRequestParticipantException(message, PullRequestRole.REVIEWER);
        });
    }

    private void checkCanUpdateStatus(InternalPullRequest pullRequest) {
        this.checkIsOpen(pullRequest, "bitbucket.service.pullrequest.update.participantstatus.declined", "bitbucket.service.pullrequest.update.participantstatus.merged");
    }

    private void checkCanUpdateRole(InternalPullRequest pullRequest) {
        this.checkIsOpen(pullRequest, "bitbucket.service.pullrequest.roleupdate.declined", "bitbucket.service.pullrequest.roleupdate.merged");
    }

    private void checkIsOpen(InternalPullRequest pullRequest, String declineKey, String mergedKey) {
        switch (pullRequest.getState()) {
            case DECLINED: {
                throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage(declineKey, new Object[0]));
            }
            case MERGED: {
                throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage(mergedKey, new Object[0]));
            }
        }
    }

    private InternalPullRequestActivity createActivity(InternalPullRequest pullRequest, PullRequestAction action, Date createdDate) {
        InternalPullRequestActivity activity = ((InternalPullRequestActivity.Builder)((InternalPullRequestActivity.Builder)((InternalPullRequestActivity.Builder)new InternalPullRequestActivity.Builder(pullRequest).action(action)).createdDate(createdDate)).user(this.getCurrentUser())).build();
        this.activityDao.create((Object)activity);
        return activity;
    }

    private InternalPullRequestParticipant createReviewer(InternalPullRequest pullRequest, InternalApplicationUser user) {
        InternalPullRequestParticipant participant = this.addParticipant(pullRequest, user, PullRequestRole.REVIEWER);
        this.fireParticipantsUpdatedEvent(pullRequest, Collections.singleton(user), Collections.emptySet());
        this.fireReviewersUpdatedEvent(pullRequest, Collections.singleton(user), Collections.emptySet());
        this.logReviewersUpdatedActivity(pullRequest, Collections.singleton(user), Collections.emptySet());
        return participant;
    }

    private InternalPullRequestParticipant doMakeParticipantAndWatcher(InternalPullRequest pullRequest, InternalApplicationUser user) {
        InternalPullRequestParticipant participant = this.addParticipant(pullRequest, user, PullRequestRole.PARTICIPANT);
        this.fireParticipantsUpdatedEvent(pullRequest, Collections.singleton(user), Collections.emptySet());
        return participant;
    }

    private Predicate<ApplicationUser> filterPredicate(String filter) {
        Pattern pattern = UserUtils.createNameMatchingPattern((String)filter);
        return user -> pattern.matcher(user.getDisplayName()).find() || StringUtils.isNotBlank((CharSequence)user.getEmailAddress()) && pattern.matcher(user.getEmailAddress()).find() || pattern.matcher(user.getName()).find();
    }

    private void fireParticipantsUpdatedEvent(InternalPullRequest pullRequest, Set<ApplicationUser> added, Set<ApplicationUser> removed) {
        if (!added.isEmpty() || !removed.isEmpty()) {
            this.eventPublisher.publish((Object)new PullRequestParticipantsUpdatedEvent((Object)this, (PullRequest)pullRequest, added, removed));
        }
    }

    private void fireReviewersUpdatedEvent(InternalPullRequest pullRequest, Set<ApplicationUser> added, Set<ApplicationUser> removed) {
        if (!added.isEmpty() || !removed.isEmpty()) {
            this.eventPublisher.publish((Object)new PullRequestReviewersUpdatedEvent((Object)this, (PullRequest)pullRequest, added, removed));
        }
    }

    private InternalApplicationUser getCurrentUser() {
        return InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser());
    }

    private InternalPullRequestParticipant getParticipant(InternalPullRequest pullRequest, ApplicationUser user) {
        return this.participantDao.findByPullRequestAndUser(pullRequest.getGlobalId(), user.getId());
    }

    private InternalApplicationUser getUserByName(String username) {
        return InternalConverter.convertToInternalUser((ApplicationUser)this.userService.getUserByName(username, true));
    }

    private Set<InternalApplicationUser> getUsersWithActivities(InternalPullRequest pullRequest) {
        return this.activityDao.findUsersWithActivities(pullRequest.getGlobalId(), Collections.emptySet(), Collections.singleton(PullRequestAction.RESCOPED));
    }

    private InternalPullRequestParticipant importParticipant(InternalPullRequest pullRequest, InternalApplicationUser user, PullRequestRole role, PullRequestParticipantStatus status, String lastReviewedCommit) {
        InternalPullRequestParticipant.Builder builder = ((InternalPullRequestParticipant.Builder)new InternalPullRequestParticipant.Builder(pullRequest).role(role).user(user)).status(status);
        if (StringUtils.isNotBlank((CharSequence)lastReviewedCommit)) {
            builder.lastReviewedCommit(lastReviewedCommit);
        }
        return (InternalPullRequestParticipant)this.participantDao.create((Object)builder.build());
    }

    private void logParticipantStatusActivity(InternalPullRequest pullRequest, PullRequestParticipantStatus previousStatus, PullRequestParticipantStatus currentStatus, Date createdDate) {
        if (previousStatus == PullRequestParticipantStatus.NEEDS_WORK && currentStatus == PullRequestParticipantStatus.UNAPPROVED) {
            return;
        }
        InternalPullRequestActivity activity = this.createActivity(pullRequest, InternalPullRequestParticipantHelper.resolveAction(currentStatus), createdDate);
        this.eventPublisher.publish((Object)new PullRequestActivityEvent((Object)this, (PullRequestActivity)activity));
    }

    private void logReviewersUpdatedActivity(InternalPullRequest pullRequest, Set<ApplicationUser> added, Set<ApplicationUser> removed) {
        if (!added.isEmpty() || !removed.isEmpty()) {
            InternalPullRequestReviewersUpdatedActivity activity = ((InternalPullRequestReviewersUpdatedActivity.Builder)((InternalPullRequestReviewersUpdatedActivity.Builder)new InternalPullRequestReviewersUpdatedActivity.Builder(pullRequest).addedReviewers(added).removedReviewers(removed).createdDate(new Date())).user(this.getCurrentUser())).build();
            this.activityDao.create((Object)activity);
            this.eventPublisher.publish((Object)new PullRequestReviewersUpdatedActivityEvent((Object)this, (PullRequestReviewersUpdatedActivity)activity));
        }
    }

    private PageProvider<ApplicationUser> participantPageProvider(PullRequestParticipantSearchRequest searchRequest) {
        PullRequestParticipantSearchCriteria searchCriteria = new PullRequestParticipantSearchCriteria.Builder(searchRequest).build();
        return request -> PageUtils.asPageOf(ApplicationUser.class, (Page)this.participantDao.searchUsers(searchCriteria, request));
    }

    private void removeParticipant(InternalPullRequestParticipant participant) {
        InternalPullRequest pullRequest = participant.getPullRequest();
        InternalApplicationUser user = participant.getUser();
        this.participantDao.delete((Object)participant);
        this.watcherService.unwatch(((UnwatchRequest.Builder)new UnwatchRequest.Builder((Watchable)pullRequest).user((ApplicationUser)user)).build());
        this.fireParticipantsUpdatedEvent(pullRequest, Collections.emptySet(), Collections.singleton(user));
        if (PullRequestRole.REVIEWER == participant.getRole()) {
            this.fireReviewersUpdatedEvent(pullRequest, Collections.emptySet(), Collections.singleton(user));
            this.logReviewersUpdatedActivity(pullRequest, Collections.emptySet(), Collections.singleton(user));
        }
    }

    private static PullRequestAction resolveAction(PullRequestParticipantStatus currentStatus) {
        switch (currentStatus) {
            case APPROVED: {
                return PullRequestAction.APPROVED;
            }
            case NEEDS_WORK: {
                return PullRequestAction.REVIEWED;
            }
            case UNAPPROVED: {
                return PullRequestAction.UNAPPROVED;
            }
        }
        return null;
    }

    private Set<ApplicationUser> resolveParticipants(Set<ApplicationUser> allCurrentParticipants, boolean isImport, Set<String> participantNames, PullRequestRole role, Repository targetRepository) {
        Map userLookup = this.userService.getUsersByName(participantNames, true).stream().collect(Collectors.toMap(Principal::getName, Function.identity()));
        if (isImport && userLookup.size() < participantNames.size()) {
            Set serviceUserNames = (Set)participantNames.stream().filter(s -> !userLookup.containsKey(s)).collect(MoreCollectors.toImmutableSet());
            this.userService.getServiceUsersByName(serviceUserNames, true).forEach(serviceUser -> userLookup.put(serviceUser.getName(), serviceUser));
        }
        HashMap errorsByName = Maps.newHashMap();
        HashSet resolvedParticipants = Sets.newHashSet();
        participantNames.forEach(name -> this.resolveParticipant(allCurrentParticipants, isImport, (String)name, userLookup::get, targetRepository).fold(error -> errorsByName.put(name, error), resolvedParticipants::add));
        if (!errorsByName.isEmpty()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.invalidparticipants", new Object[0]);
            throw role == PullRequestRole.REVIEWER ? new InvalidPullRequestReviewersException(message, (Map)errorsByName, (Set)resolvedParticipants) : new InvalidPullRequestParticipantsException(message, role, (Map)errorsByName, (Set)resolvedParticipants);
        }
        return resolvedParticipants;
    }

    @Nonnull
    public ApplicationUser resolveAuthorForImport(@Nonnull String name, @Nonnull Repository targetRepository) {
        return (ApplicationUser)this.resolveParticipant(Collections.emptySet(), true, name, this::getUserByName, targetRepository).getOrThrow(() -> {
            throw new InvalidPullRequestParticipantException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.import.nosuchuser.participant", new Object[]{name, targetRepository}), PullRequestRole.AUTHOR);
        });
    }

    private Either<KeyedMessage, ApplicationUser> resolveParticipant(Set<ApplicationUser> existingParticipants, boolean isImport, String name, Function<String, ApplicationUser> userLookup, Repository targetRepository) {
        ApplicationUser participant = userLookup.apply(name);
        if (participant == null || !participant.isActive() && !isImport) {
            return Either.left((Object)this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.invalidparticipant", new Object[]{name}));
        }
        if (isImport || existingParticipants.contains(participant)) {
            return Either.right((Object)participant);
        }
        return this.validateCanAccess(participant, targetRepository).map(Either::left).orElseGet(() -> Either.right((Object)InternalConverter.convertToInternalUser((ApplicationUser)participant)));
    }

    private InternalPullRequestParticipant updateParticipant(InternalPullRequestParticipant participant, String lastReviewedCommit, PullRequestRole role, PullRequestParticipantStatus status) {
        PullRequestParticipantStatus previousStatus = participant.getStatus();
        InternalPullRequestParticipant.Builder builder = new InternalPullRequestParticipant.Builder(participant);
        if (role != null) {
            builder.role(role);
        }
        builder.status(status == null ? PullRequestParticipantStatus.UNAPPROVED : status);
        Date activityTime = new Date();
        if (lastReviewedCommit != null) {
            builder.lastReviewedCommit(lastReviewedCommit);
            if (!this.participantDao.updateIfLastReviewedCommitMatches(builder.build())) {
                throw new PullRequestOutOfDateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.outofdate", new Object[0]), (PullRequest)participant.getPullRequest(), participant.getPullRequest().getVersion());
            }
        }
        InternalPullRequestParticipant updated = (InternalPullRequestParticipant)this.participantDao.update((Object)builder.build());
        InternalPullRequest pullRequest = updated.getPullRequest();
        if (role != null) {
            Set<ApplicationUser> removed;
            Set<ApplicationUser> added;
            if (PullRequestRole.REVIEWER == role) {
                added = Collections.singleton(participant.getUser());
                removed = Collections.emptySet();
            } else {
                added = Collections.emptySet();
                removed = Collections.singleton(participant.getUser());
            }
            this.fireReviewersUpdatedEvent(participant.getPullRequest(), added, removed);
            this.logReviewersUpdatedActivity(pullRequest, added, removed);
        }
        if (status != null) {
            if (status == PullRequestParticipantStatus.NEEDS_WORK) {
                this.eventPublisher.publish((Object)new PullRequestParticipantReviewedEvent((Object)this, (PullRequest)pullRequest, (PullRequestParticipant)updated, previousStatus));
            } else if (status == PullRequestParticipantStatus.APPROVED) {
                this.eventPublisher.publish((Object)new PullRequestParticipantApprovedEvent((Object)this, (PullRequest)pullRequest, (PullRequestParticipant)updated, previousStatus));
            } else if (status == PullRequestParticipantStatus.UNAPPROVED) {
                this.eventPublisher.publish((Object)new PullRequestParticipantUnapprovedEvent((Object)this, (PullRequest)pullRequest, (PullRequestParticipant)updated, previousStatus));
            }
            this.logParticipantStatusActivity(pullRequest, previousStatus, status, activityTime);
        }
        return updated;
    }

    private void updateParticipants(InternalPullRequest pullRequest, Set<ApplicationUser> removedReviewers, Set<ApplicationUser> removedReviewersNoLongerParticipating, Set<ApplicationUser> addedReviewers, Set<ApplicationUser> addedReviewersNewlyParticipating) {
        pullRequest.getAllParticipants().forEach(participant -> {
            InternalPullRequestParticipant internal = InternalConverter.convertToInternalParticipant((PullRequestParticipant)participant);
            ApplicationUser user = participant.getUser();
            if (removedReviewersNoLongerParticipating.contains(user)) {
                this.participantDao.delete((Object)internal);
                this.watcherService.unwatch(((UnwatchRequest.Builder)new UnwatchRequest.Builder((Watchable)internal.getPullRequest()).user((ApplicationUser)internal.getUser())).build());
            } else if (removedReviewers.contains(user)) {
                this.updateRole(internal, PullRequestRole.PARTICIPANT);
            } else if (addedReviewers.contains(user)) {
                this.updateRole(internal, PullRequestRole.REVIEWER);
            }
        });
        addedReviewersNewlyParticipating.forEach(user -> this.addParticipant(pullRequest, InternalConverter.convertToInternalUser((ApplicationUser)user), PullRequestRole.REVIEWER));
    }

    private InternalPullRequestParticipant updateRole(InternalPullRequestParticipant participant, PullRequestRole role) {
        return (InternalPullRequestParticipant)this.participantDao.update((Object)new InternalPullRequestParticipant.Builder(participant).role(role).status(PullRequestParticipantStatus.UNAPPROVED).build());
    }

    private InternalPullRequestParticipant updateStatus(InternalPullRequestParticipant participant, String latestCommit, PullRequestParticipantStatus status) {
        String lastReviewedCommit = PullRequestParticipantStatus.UNAPPROVED == status ? null : latestCommit;
        PullRequestRole role = PullRequestParticipantStatus.UNAPPROVED != status && PullRequestRole.REVIEWER != participant.getRole() ? PullRequestRole.REVIEWER : null;
        return this.updateParticipant(participant, lastReviewedCommit, role, status);
    }

    private Optional<KeyedMessage> validateCanAccess(ApplicationUser reviewer, Repository targetRepository) {
        if (!this.permissionService.hasGlobalPermission(reviewer, Permission.LICENSED_USER)) {
            return Optional.of(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.participant.license", new Object[]{reviewer.getDisplayName()}));
        }
        if (!this.permissionService.hasRepositoryPermission(reviewer, targetRepository, Permission.REPO_READ)) {
            return Optional.of(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.unauthorisedparticipant", new Object[]{reviewer.getDisplayName()}));
        }
        return Optional.empty();
    }
}

