/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.PullRequestStateGuard;
import jakarta.annotation.Nonnull;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class MapPullRequestStateGuard
implements PullRequestStateGuard {
    private final ConcurrentMap<Long, AtomicInteger> updateCountsById = new ConcurrentHashMap<Long, AtomicInteger>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIfUpdated(@Nonnull InternalPullRequest pullRequest, @Nonnull UncheckedOperation<Void> updateOperation) {
        AtomicInteger updateCount = this.getUpdateCount(pullRequest);
        if (updateCount.get() == 0) {
            return;
        }
        AtomicInteger atomicInteger = updateCount;
        synchronized (atomicInteger) {
            int count = updateCount.get();
            if (count > 0) {
                updateOperation.perform();
                updateCount.addAndGet(-count);
            }
        }
    }

    public void updated(@Nonnull InternalPullRequest pullRequest) {
        this.getUpdateCount(pullRequest).incrementAndGet();
    }

    private AtomicInteger getUpdateCount(InternalPullRequest pullRequest) {
        return this.updateCountsById.computeIfAbsent(pullRequest.getGlobalId(), id -> new AtomicInteger(1));
    }
}

