/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.concurrent.PullRequestLock;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.nutcluster.core.IMap;
import com.atlassian.nutcluster.map.AbstractEntryProcessor;
import com.atlassian.nutcluster.map.EntryProcessor;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.PullRequestStateGuard;
import jakarta.annotation.Nonnull;
import java.util.Map;

public class NutclusterPullRequestStateGuard
implements PullRequestStateGuard {
    private final IMap<Long, Integer> pendingUpdatesCount;
    private final PullRequestLock pullRequestLock;

    public NutclusterPullRequestStateGuard(PullRequestLock pullRequestLock, IMap<Long, Integer> pendingUpdatesCount) {
        this.pullRequestLock = pullRequestLock;
        this.pendingUpdatesCount = pendingUpdatesCount;
    }

    public void processIfUpdated(@Nonnull InternalPullRequest pullRequest, @Nonnull UncheckedOperation<Void> updateOperation) {
        try (Timer timer = TimerUtils.start((String)"StateGuard.processIfUpdated - check");){
            Long pullRequestGlobalId = pullRequest.getGlobalId();
            if (this.getPendingUpdatesCount(pullRequestGlobalId) == 0) {
                return;
            }
            timer.mark("StateGuard.processIfUpdated - lock");
            this.pullRequestLock.withLock((PullRequest)pullRequest, () -> {
                int updateCount = this.getPendingUpdatesCount(pullRequestGlobalId);
                if (updateCount > 0) {
                    updateOperation.perform();
                    this.pendingUpdatesCount.executeOnKey((Object)pullRequestGlobalId, (EntryProcessor)new PendingUpdatesModifier(-updateCount));
                }
                return null;
            });
        }
    }

    public void updated(@Nonnull InternalPullRequest pullRequest) {
        try (Timer ignored = TimerUtils.start((String)"StateGuard.update");){
            this.pendingUpdatesCount.executeOnKey((Object)pullRequest.getGlobalId(), (EntryProcessor)new PendingUpdatesModifier(1));
        }
    }

    private int getPendingUpdatesCount(Long pullRequestGlobalId) {
        Integer oldUpdatesCount = (Integer)this.pendingUpdatesCount.putIfAbsent((Object)pullRequestGlobalId, (Object)1);
        return oldUpdatesCount == null ? 1 : oldUpdatesCount;
    }

    private static class PendingUpdatesModifier
    extends AbstractEntryProcessor<Long, Integer> {
        private final int modifier;

        private PendingUpdatesModifier(int modifier) {
            this.modifier = modifier;
        }

        public Object process(Map.Entry<Long, Integer> entry) {
            Integer val = entry.getValue();
            if (val == null) {
                entry.setValue(this.modifier);
            } else {
                entry.setValue(val + this.modifier);
            }
            return null;
        }
    }
}

