/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeability;
import com.atlassian.bitbucket.pull.PullRequestMergeabilityPropertyProvider;
import com.atlassian.bitbucket.pull.PullRequestPropertyContext;
import com.atlassian.bitbucket.pull.PullRequestPropertyProvider;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.content.AbstractProviderContext;
import com.atlassian.stash.internal.plugin.PullRequestMergeabilityPropertyProviderDescriptor;
import com.atlassian.stash.internal.plugin.PullRequestPropertyProviderDescriptor;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.PullRequestEnricher;
import com.atlassian.stash.internal.pull.SimplePullRequestMergeability;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pullRequestEnricher")
public class PluginPullRequestEnricher
implements PullRequestEnricher {
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginPullRequestEnricher(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    @Nonnull
    public Iterable<InternalPullRequest> enrich(@Nonnull Iterable<InternalPullRequest> pullRequests) {
        Context context = new Context(pullRequests);
        this.enrich(context);
        return ImmutableList.copyOf((Iterable)Iterables.transform(pullRequests, new Enricher(context)::apply));
    }

    @Override
    @Nonnull
    public Page<InternalPullRequest> enrich(@Nonnull Page<InternalPullRequest> pullRequests) {
        Context context = new Context(pullRequests);
        this.enrich(context);
        return pullRequests.transform((Function)new Enricher(context));
    }

    @Override
    @Nonnull
    public PullRequestMergeability enrich(@Nonnull InternalPullRequest pullRequest, @Nonnull SimplePullRequestMergeability mergeability) {
        PropertyMap.Builder builder = new PropertyMap.Builder();
        this.getMergeabilityPropertyProviders().map(provider -> provider.provideProperties((PullRequest)pullRequest, (PullRequestMergeability)mergeability)).filter(Objects::nonNull).forEach(arg_0 -> ((PropertyMap.Builder)builder).properties(arg_0));
        mergeability.setProperties(builder.build());
        return mergeability;
    }

    private void enrich(Context context) {
        this.getPropertyProviders().forEach(propertyProvider -> propertyProvider.provideProperties((PullRequestPropertyContext)context));
    }

    private Stream<PullRequestPropertyProvider> getPropertyProviders() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(PullRequestPropertyProviderDescriptor.class).stream().map(ModuleDescriptorUtils.toModule());
    }

    private Stream<PullRequestMergeabilityPropertyProvider> getMergeabilityPropertyProviders() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(PullRequestMergeabilityPropertyProviderDescriptor.class).stream().map(ModuleDescriptorUtils.toModule());
    }

    private static class Context
    extends AbstractProviderContext<PullRequest>
    implements PullRequestPropertyContext {
        private Context(Iterable<? extends PullRequest> pullRequests) {
            super(ImmutableSet.copyOf(pullRequests));
        }

        private Context(Page<? extends PullRequest> pullRequests) {
            this((Iterable<? extends PullRequest>)ImmutableSet.copyOf((Iterable)pullRequests.getValues()));
        }
    }

    private static class Enricher
    implements Function<InternalPullRequest, InternalPullRequest> {
        private final Context context;

        public Enricher(Context context) {
            this.context = context;
        }

        @Override
        public InternalPullRequest apply(InternalPullRequest pullRequest) {
            pullRequest.setProperties(this.context.getPropertiesFor(pullRequest));
            return pullRequest;
        }
    }
}

