/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.EntityOutOfDateException;
import com.atlassian.bitbucket.commit.graph.CommitGraphContext;
import com.atlassian.bitbucket.commit.graph.CommitGraphNode;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.pull.PullRequestSummaryField;
import com.atlassian.bitbucket.dmz.pull.PullRequestSummaryRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.bulk.BulkTraversalCallback;
import com.atlassian.bitbucket.scm.bulk.BulkTraversalStatus;
import com.atlassian.bitbucket.scm.bulk.BulkTraversalSummary;
import com.atlassian.bitbucket.scm.bulk.BulkTraverseCommitsCommandParameters;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.diagnostics.AlertRequest;
import com.atlassian.diagnostics.ComponentMonitor;
import com.atlassian.diagnostics.Issue;
import com.atlassian.diagnostics.MonitoringService;
import com.atlassian.diagnostics.Severity;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestCommit;
import com.atlassian.stash.internal.pull.InternalPullRequestSummary;
import com.atlassian.stash.internal.pull.PullRequestCommitDao;
import com.atlassian.stash.internal.pull.PullRequestDao;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.upgrade.UpgradeTask;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.hibernate.exception.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component
@DefaultApplicationMode
@UpgradeTask(value="core-backfill-pull-request-commits")
public class PullRequestCommitBackfillJob
implements ScheduledJobSource {
    static final String KEY_TASK = "core-backfill-pull-request-commits";
    static final String LOCK_NAME = PullRequestCommitBackfillJobRunner.class.getSimpleName();
    static final JobId PR_COMMIT_BACKFILL_JOB_ID = JobId.of((String)PullRequestCommitBackfillJobRunner.class.getSimpleName());
    static final JobRunnerKey PR_COMMIT_BACKFILL_JOB_RUNNER_KEY = JobRunnerKey.of((String)PullRequestCommitBackfillJobRunner.class.getName());
    private static final int BACKFILL_COMPLETE = -1;
    private static final int BACKFILL_NOT_STARTED = 0;
    private static final Duration INITIAL_SCHEDULE_DELAY = Duration.ofSeconds(10L);
    private static final Logger log = LoggerFactory.getLogger(PullRequestCommitBackfillJob.class);
    private final Issue invalidFileContent;
    private final LockService lockService;
    private final ComponentMonitor monitor;
    private final Path progressMarkerPath;
    private final PullRequestCommitDao pullRequestCommitDao;
    private final PullRequestDao pullRequestDao;
    private final RepositoryDao repositoryDao;
    private final TransactionTemplate requiresNewTransactionTemplate;
    private final ScmService scmService;
    @Value(value="${pullrequest.commit.indexing.backfill.batch.size}")
    private int batchSize;
    @Value(value="${pullrequest.commit.indexing.backfill.maximum.processed}")
    private int maxPullRequestsToProcess;
    @Value(value="${pullrequest.commit.indexing.backfill.process.timeout}")
    private int processTimeout;

    @Autowired
    public PullRequestCommitBackfillJob(HomeLayout homeLayout, LockService lockService, MonitoringService monitoringService, PullRequestCommitDao pullRequestCommitDao, PullRequestDao pullRequestDao, RepositoryDao repositoryDao, ScmService scmService, PlatformTransactionManager transactionManager) {
        this.lockService = lockService;
        this.pullRequestCommitDao = pullRequestCommitDao;
        this.pullRequestDao = pullRequestDao;
        this.repositoryDao = repositoryDao;
        this.scmService = scmService;
        this.monitor = monitoringService.createMonitor("UpgradeTask", "bitbucket.diagnostics.upgrade.name");
        this.invalidFileContent = this.monitor.defineIssue(2001).summaryI18nKey("bitbucket.diagnostics.upgrade.issue.2001.summary").descriptionI18nKey("bitbucket.diagnostics.upgrade.issue.2001.description").severity(Severity.WARNING).build();
        this.progressMarkerPath = homeLayout.getUpgradesDir().resolve(KEY_TASK);
        this.requiresNewTransactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        try {
            MoreFiles.mkdir((Path)this.progressMarkerPath.getParent());
            if (this.getBackfillProgress() == -1) {
                log.debug("Backfill of pull request commits has already completed. The job will not be scheduled.");
                return;
            }
        }
        catch (Exception e) {
            log.warn("Failed to access progress marker file. The job will not be scheduled.", (Throwable)e);
            return;
        }
        PullRequestCommitBackfillJobRunner jobRunner = new PullRequestCommitBackfillJobRunner();
        schedulerService.registerJobRunner(PR_COMMIT_BACKFILL_JOB_RUNNER_KEY, (JobRunner)jobRunner);
        Date startTime = Date.from(Instant.now().plus(INITIAL_SCHEDULE_DELAY));
        schedulerService.scheduleJob(PR_COMMIT_BACKFILL_JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)PR_COMMIT_BACKFILL_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce((Date)startTime)));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        schedulerService.unregisterJobRunner(PR_COMMIT_BACKFILL_JOB_RUNNER_KEY);
    }

    private void backfillPullRequests(Repository repository, Page<InternalPullRequestSummary> pullRequestSummaries) {
        if (pullRequestSummaries.getSize() < 1) {
            return;
        }
        HashMap<Long, CommitGraphContext> pullRequestCommitContexts = new HashMap<Long, CommitGraphContext>(pullRequestSummaries.getSize(), 1.0f);
        HashSet<String> allToAndFromCommits = new HashSet<String>(pullRequestSummaries.getSize() * 3, 1.0f);
        HashSet<InternalRepository> alternates = new HashSet<InternalRepository>();
        for (InternalPullRequestSummary summary : pullRequestSummaries.getValues()) {
            allToAndFromCommits.add(summary.getFromRef().getLatestCommit());
            allToAndFromCommits.add(summary.getToRef().getLatestCommit());
            CommitGraphContext.Builder contextBuilder = new CommitGraphContext.Builder().include(summary.getFromRef().getLatestCommit(), new String[0]).exclude(summary.getToRef().getLatestCommit(), new String[0]);
            summary.getMergeHash().ifPresent(mergeHash -> {
                allToAndFromCommits.add((String)mergeHash);
                contextBuilder.include(mergeHash, new String[0]);
            });
            pullRequestCommitContexts.put(summary.getGlobalId(), contextBuilder.build());
            alternates.add(summary.getFromRef().getRepository());
        }
        alternates.remove(repository);
        this.clearPullRequestCommits(pullRequestCommitContexts.keySet());
        log.debug("{}: Indexing commits for {} pull requests", (Object)repository, (Object)pullRequestCommitContexts.size());
        Command command = this.scmService.getBulkContentCommandFactory(repository).traverseCommits(new BulkTraverseCommitsCommandParameters.Builder().include(allToAndFromCommits).alternates(alternates).ignoreMissing(true).build(), (BulkTraversalCallback)new BatchingPrBackfillTraversalCallback(pullRequestCommitContexts, repository));
        command.setTimeout((long)this.processTimeout);
        command.call();
    }

    private void backfillRemainingRepositories(int afterId) {
        MutableObject pageRequest = new MutableObject((Object)PageUtils.newRequest((int)0, (int)100));
        while (pageRequest.getValue() != null) {
            this.requiresNewTransactionTemplate.execute(status -> {
                Page repositories = this.repositoryDao.getOrderedById(afterId, (PageRequest)pageRequest.getValue());
                for (Repository repository : repositories.getValues()) {
                    this.backfillRepository(repository);
                }
                pageRequest.setValue((Object)repositories.getNextPageRequest());
                return null;
            });
        }
        this.setBackfillProgress(-1);
        log.info("Backfilling of pull request commits has completed for all repositories.");
    }

    private void backfillRepository(Repository repository) {
        log.debug("{}: Backfill started", (Object)repository);
        PageRequest pageRequest = PageUtils.newRequest((int)0, (int)this.maxPullRequestsToProcess);
        while (pageRequest != null) {
            Page summaryPage = this.pullRequestDao.summarize(new PullRequestSummaryRequest.Builder(repository.getId()).field(PullRequestSummaryField.MERGE_HASH).onlyClosed(true).build(), pageRequest);
            this.backfillPullRequests(repository, (Page<InternalPullRequestSummary>)summaryPage);
            pageRequest = summaryPage.getNextPageRequest();
        }
        this.setBackfillProgress(repository.getId());
        log.debug("{}: Backfill completed", (Object)repository);
    }

    private void clearPullRequestCommits(Set<Long> pullRequestIds) {
        this.requiresNewTransactionTemplate.execute(status -> this.pullRequestCommitDao.deleteByPullRequests((Collection)pullRequestIds));
    }

    private int getBackfillProgress() throws IOException {
        String progress = null;
        try {
            progress = MoreFiles.toString((Path)this.progressMarkerPath);
            return Integer.parseInt(progress);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            log.debug("Backfilling pull request commits for all repositories.");
            return 0;
        }
        catch (NumberFormatException e) {
            String truncatedFileContents = progress == null ? "" : StringUtils.abbreviate((String)progress, (int)10);
            this.monitor.alert(new AlertRequest.Builder(this.invalidFileContent).details(() -> ImmutableMap.of((Object)"content", (Object)truncatedFileContents)).build());
            log.warn("The progress marker file contains invalid content: " + truncatedFileContents, (Throwable)e);
            throw e;
        }
    }

    private void setBackfillProgress(int repositoryId) {
        try (BufferedWriter writer = Files.newBufferedWriter(this.progressMarkerPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(Integer.toString(repositoryId));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to update progress marker file during PR commit backfilling. Backfilling will fail and be re-attempted on next start up.", e);
        }
    }

    private class PullRequestCommitBackfillJobRunner
    implements JobRunner {
        private PullRequestCommitBackfillJobRunner() {
        }

        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            try {
                if (PullRequestCommitBackfillJob.this.getBackfillProgress() == -1) {
                    log.debug("Backfill of pull request commits has already completed.");
                } else {
                    this.runJobWithLock();
                }
                return JobRunnerResponse.success();
            }
            catch (Exception e) {
                log.warn("An exception was encountered while backfilling. The job has failed and will be attempted again on next startup.", (Throwable)e);
                return JobRunnerResponse.failed((Throwable)e);
            }
        }

        private void runJobWithLock() throws IOException {
            try (LockGuard guard = LockGuard.tryLock((Lock)PullRequestCommitBackfillJob.this.lockService.getLock(LOCK_NAME));){
                if (guard == null) {
                    log.debug("The job will not run as it is already running on another node.");
                    return;
                }
                int progress = PullRequestCommitBackfillJob.this.getBackfillProgress();
                if (progress == -1) {
                    log.debug("Backfill of pull request commits has already completed.");
                } else {
                    log.info("Starting backfill of pull request commits.");
                    PullRequestCommitBackfillJob.this.backfillRemainingRepositories(progress);
                }
            }
        }
    }

    private class BatchingPrBackfillTraversalCallback
    implements BulkTraversalCallback {
        private final Map<Long, CommitGraphContext> commitContexts;
        private final Map<Long, Set<String>> pullRequestCommits;
        private final Repository repository;
        private int commitCount;
        private int totalCommits;

        BatchingPrBackfillTraversalCallback(Map<Long, CommitGraphContext> commitContexts, Repository repository) {
            this.commitContexts = commitContexts;
            this.repository = repository;
            this.pullRequestCommits = new HashMap<Long, Set<String>>(PullRequestCommitBackfillJob.this.batchSize, 1.0f);
        }

        public void onEnd(@Nonnull BulkTraversalSummary summary) {
            if (!this.pullRequestCommits.isEmpty()) {
                this.commitBatch(this.repository, this.pullRequestCommits);
                this.totalCommits += this.commitCount;
            }
            log.debug("{}: Traversal completed with {} pull requests unresolved. {} commits were indexed.", new Object[]{this.repository, this.commitContexts.size(), this.totalCommits});
        }

        public BulkTraversalStatus onNode(@Nonnull CommitGraphNode node) {
            Iterator<Map.Entry<Long, CommitGraphContext>> contextIterator = this.commitContexts.entrySet().iterator();
            while (contextIterator.hasNext()) {
                Map.Entry<Long, CommitGraphContext> prIdToCommitGraphContext = contextIterator.next();
                if (prIdToCommitGraphContext.getValue().visit(node)) {
                    this.pullRequestCommits.computeIfAbsent(prIdToCommitGraphContext.getKey(), i -> new HashSet()).add(node.getCommit().getId());
                    ++this.commitCount;
                    if (this.commitCount >= PullRequestCommitBackfillJob.this.batchSize) {
                        this.commitBatch(this.repository, this.pullRequestCommits);
                        this.pullRequestCommits.clear();
                        this.totalCommits += this.commitCount;
                        this.commitCount = 0;
                    }
                }
                if (prIdToCommitGraphContext.getValue().isTraversing()) continue;
                contextIterator.remove();
            }
            return this.commitContexts.isEmpty() ? BulkTraversalStatus.FINISH : BulkTraversalStatus.CONTINUE;
        }

        private void commitBatch(Repository repository, Map<Long, Set<String>> pullRequestCommits) {
            try {
                PullRequestCommitBackfillJob.this.requiresNewTransactionTemplate.execute(status -> {
                    pullRequestCommits.forEach((key, value) -> {
                        InternalPullRequest pullRequest = (InternalPullRequest)PullRequestCommitBackfillJob.this.pullRequestDao.loadById(key);
                        value.forEach(commit -> PullRequestCommitBackfillJob.this.pullRequestCommitDao.create((Object)new InternalPullRequestCommit.Builder(commit, pullRequest).build()));
                    });
                    return null;
                });
            }
            catch (EntityOutOfDateException | ConstraintViolationException | DataIntegrityViolationException e) {
                log.error("{}: A conflict occurred while backfilling PR commits. Commit links may be incomplete or missing for some pull requests", (Object)repository, (Object)e);
            }
        }
    }
}

