/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.PullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.pull.PullRequestMergeConfigType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.stash.internal.pull.PullRequestMergeConfigEvent;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;

@AsynchronousPreferred
@EventName(value="stash.pullrequest.merge.config.updated")
public class PullRequestMergeConfigUpdatedEvent
extends PullRequestMergeConfigEvent {
    private final int commitSummaries;
    private final String defaultStrategyId;
    private final Set<String> enabledStrategyIds;
    private final int oldCommitSummaries;
    private final String oldDefaultStrategyId;
    private final Set<String> oldEnabledStrategyIds;
    private final PullRequestCommitMessageTemplate oldPullRequestCommitMessageTemplate;
    private final PullRequestMergeConfigType oldType;
    private final PullRequestCommitMessageTemplate pullRequestCommitMessageTemplate;

    public PullRequestMergeConfigUpdatedEvent(@Nonnull Object source, @Nonnull String scmId, int commitSummaries, @Nonnull String defaultStrategyId, @Nonnull Set<String> enabledStrategyIds, int oldCommitSummaries, @Nonnull String oldDefaultStrategyId, @Nonnull Set<String> oldEnabledStrategyIds, @Nonnull PullRequestMergeConfigType oldType) {
        this(source, scmId, null, null, PullRequestMergeConfigType.SCM, commitSummaries, defaultStrategyId, enabledStrategyIds, oldCommitSummaries, oldDefaultStrategyId, oldEnabledStrategyIds, oldType, null, null);
    }

    public PullRequestMergeConfigUpdatedEvent(@Nonnull Object source, @Nonnull String scmId, @Nonnull Project project, int commitSummaries, @Nonnull String defaultStrategyId, @Nonnull Set<String> enabledStrategyIds, int oldCommitSummaries, @Nonnull String oldDefaultStrategyId, @Nonnull Set<String> oldEnabledStrategyIds, @Nonnull PullRequestMergeConfigType oldType, @Nullable PullRequestCommitMessageTemplate oldPullRequestCommitMessageTemplate, @Nullable PullRequestCommitMessageTemplate pullRequestCommitMessageTemplate) {
        this(source, scmId, project, null, PullRequestMergeConfigType.PROJECT, commitSummaries, defaultStrategyId, enabledStrategyIds, oldCommitSummaries, oldDefaultStrategyId, oldEnabledStrategyIds, oldType, oldPullRequestCommitMessageTemplate, pullRequestCommitMessageTemplate);
    }

    public PullRequestMergeConfigUpdatedEvent(@Nonnull Object source, @Nonnull Repository repository, int commitSummaries, @Nonnull String defaultStrategyId, @Nonnull Set<String> enabledStrategyIds, int oldCommitSummaries, @Nonnull String oldDefaultStrategyId, @Nonnull Set<String> oldEnabledStrategyIds, @Nonnull PullRequestMergeConfigType oldType, @Nullable PullRequestCommitMessageTemplate oldPullRequestCommitMessageTemplate, @Nullable PullRequestCommitMessageTemplate pullRequestCommitMessageTemplate) {
        this(source, repository.getScmId(), repository.getProject(), repository, PullRequestMergeConfigType.REPOSITORY, commitSummaries, defaultStrategyId, enabledStrategyIds, oldCommitSummaries, oldDefaultStrategyId, oldEnabledStrategyIds, oldType, oldPullRequestCommitMessageTemplate, pullRequestCommitMessageTemplate);
    }

    private PullRequestMergeConfigUpdatedEvent(@Nonnull Object source, @Nonnull String scmId, @Nullable Project project, @Nullable Repository repository, @Nonnull PullRequestMergeConfigType type, int commitSummaries, @Nonnull String defaultStrategyId, @Nonnull Set<String> enabledStrategyIds, int oldCommitSummaries, @Nonnull String oldDefaultStrategyId, @Nonnull Set<String> oldEnabledStrategyIds, @Nonnull PullRequestMergeConfigType oldType, @Nullable PullRequestCommitMessageTemplate oldPullRequestCommitMessageTemplate, @Nullable PullRequestCommitMessageTemplate pullRequestCommitMessageTemplate) {
        super(source, scmId, project, repository, type);
        this.commitSummaries = commitSummaries;
        this.defaultStrategyId = Objects.requireNonNull(defaultStrategyId, "defaultStrategyId");
        this.enabledStrategyIds = Objects.requireNonNull(enabledStrategyIds, "enabledStrategyIds");
        this.oldCommitSummaries = oldCommitSummaries;
        this.oldDefaultStrategyId = Objects.requireNonNull(oldDefaultStrategyId, "oldDefaultStrategyId");
        this.oldEnabledStrategyIds = Objects.requireNonNull(oldEnabledStrategyIds, "oldDefaultStrategyId");
        this.oldType = Objects.requireNonNull(oldType, "oldType");
        this.oldPullRequestCommitMessageTemplate = oldPullRequestCommitMessageTemplate;
        this.pullRequestCommitMessageTemplate = pullRequestCommitMessageTemplate;
    }

    public int getCommitSummaries() {
        return this.commitSummaries;
    }

    @Nonnull
    public String getDefaultStrategyId() {
        return this.defaultStrategyId;
    }

    @Nonnull
    public Set<String> getEnabledStrategyIds() {
        return this.enabledStrategyIds;
    }

    public int getOldCommitSummaries() {
        return this.oldCommitSummaries;
    }

    @Nonnull
    public String getOldDefaultStrategyId() {
        return this.oldDefaultStrategyId;
    }

    @Nonnull
    public Set<String> getOldEnabledStrategyIds() {
        return this.oldEnabledStrategyIds;
    }

    @Nullable
    public PullRequestCommitMessageTemplate getOldPullRequestCommitMessageTemplate() {
        return this.oldPullRequestCommitMessageTemplate;
    }

    @Nonnull
    public PullRequestMergeConfigType getOldType() {
        return this.oldType;
    }

    @Nullable
    public PullRequestCommitMessageTemplate getPullRequestCommitMessageTemplate() {
        return this.pullRequestCommitMessageTemplate;
    }

    public boolean isCustomTemplate() {
        return this.pullRequestCommitMessageTemplate != null;
    }
}

