/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class PullRequestRefCleanupRequest {
    private final long pullRequestId;
    private final int repositoryId;
    private final ApplicationUser user;
    private int attempts;

    public PullRequestRefCleanupRequest(int repositoryId, long pullRequestId, @Nonnull ApplicationUser user) {
        this.repositoryId = repositoryId;
        this.pullRequestId = pullRequestId;
        this.user = Objects.requireNonNull(user, "user");
    }

    public PullRequestRefCleanupRequest(@Nonnull PullRequestRefCleanupRequest refCleanupRequest) {
        this(Objects.requireNonNull(refCleanupRequest, (String)"refCleanupRequest").repositoryId, refCleanupRequest.pullRequestId, refCleanupRequest.user);
        this.attempts = 0;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public long getPullRequestId() {
        return this.pullRequestId;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    @Nonnull
    public ApplicationUser getUser() {
        return this.user;
    }

    public int incrementAttempts() {
        return ++this.attempts;
    }
}

