/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.troubleshooting.spi.SupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pullRequestSupportData")
public class PullRequestSupportData
implements SupportDataAppender<Repository> {
    private static final String PULL_REQUESTS = "bitbucket.atst.repository.pullrequests";
    private static final String COUNT_OPEN = "bitbucket.atst.repository.pullrequests.open";
    private static final String COUNT_MERGED = "bitbucket.atst.repository.pullrequests.merged";
    private static final String COUNT_DECLINED = "bitbucket.atst.repository.pullrequests.declined";
    private final InternalPullRequestService pullRequestService;

    @Autowired
    public PullRequestSupportData(InternalPullRequestService pullRequestService) {
        this.pullRequestService = pullRequestService;
    }

    public void addSupportData(SupportDataBuilder supportDataBuilder, Repository repository) {
        Map countsByState = this.pullRequestService.getCountsByState(repository.getId());
        supportDataBuilder.addCategory(PULL_REQUESTS).addValue(COUNT_OPEN, PullRequestSupportData.countOrZero(countsByState, PullRequestState.OPEN)).addValue(COUNT_MERGED, PullRequestSupportData.countOrZero(countsByState, PullRequestState.MERGED)).addValue(COUNT_DECLINED, PullRequestSupportData.countOrZero(countsByState, PullRequestState.DECLINED));
    }

    private static String countOrZero(Map<PullRequestState, Long> countsByState, PullRequestState state) {
        return Long.toString(countsByState.getOrDefault(state, 0L));
    }
}

