/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequestMergeStrategy;
import com.atlassian.bitbucket.scm.PluginMergeStrategy;
import jakarta.annotation.Nonnull;
import java.util.Optional;

public class ScmPullRequestMergeStrategy
implements PullRequestMergeStrategy {
    private final boolean enabled;
    private final I18nService i18nService;
    private final PluginMergeStrategy strategy;

    private ScmPullRequestMergeStrategy(Builder builder) {
        this.enabled = builder.enabled;
        this.i18nService = builder.i18nService;
        this.strategy = builder.strategy;
    }

    @Nonnull
    public String getDescription() {
        return this.i18nService.getMessage(this.strategy.getDescriptionKey(), new Object[0]);
    }

    @Nonnull
    public Optional<String> getFlag() {
        return this.strategy.getFlag();
    }

    @Nonnull
    public String getId() {
        return this.strategy.getId();
    }

    @Nonnull
    public String getName() {
        return this.i18nService.getMessage(this.strategy.getNameKey(), new Object[0]);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static class Builder {
        private final I18nService i18nService;
        private final PluginMergeStrategy strategy;
        private boolean enabled;

        public Builder(I18nService i18nService, PluginMergeStrategy strategy) {
            this.i18nService = i18nService;
            this.strategy = strategy;
        }

        @Nonnull
        public ScmPullRequestMergeStrategy build() {
            return new ScmPullRequestMergeStrategy(this);
        }

        @Nonnull
        public Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }
    }
}

