/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeVeto;
import com.atlassian.stash.internal.pull.InternalMergeRequest;
import com.atlassian.stash.internal.pull.SimplePullRequestMergeVeto;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SimpleMergeRequest
implements InternalMergeRequest {
    private final boolean abortOnFirstVeto;
    private final boolean dryRun;
    private final String message;
    private final PullRequest pullRequest;
    private final List<PullRequestMergeVeto> vetoes;

    private SimpleMergeRequest(Builder builder) {
        this.abortOnFirstVeto = builder.abortOnFirstVeto;
        this.dryRun = builder.dryRun;
        this.message = builder.message;
        this.pullRequest = builder.pullRequest;
        this.vetoes = Lists.newArrayList();
    }

    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nonnull
    public Collection<PullRequestMergeVeto> getVetoes() {
        return ImmutableList.copyOf(this.vetoes);
    }

    public boolean isAbortOnFirstVeto() {
        return this.abortOnFirstVeto;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isVetoed() {
        return !this.vetoes.isEmpty();
    }

    public void veto(@Nonnull String summary, @Nonnull String detailedMessage) {
        this.vetoes.add(new SimplePullRequestMergeVeto(summary, detailedMessage));
    }

    public static class Builder {
        private final PullRequest pullRequest;
        private boolean abortOnFirstVeto;
        private boolean dryRun;
        private String message;

        public Builder(PullRequest pullRequest) {
            this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
            this.dryRun = true;
        }

        public Builder(@Nonnull PullRequest pullRequest, @Nonnull PullRequestMergeRequest mergeRequest) {
            this(pullRequest);
            this.message = Objects.requireNonNull(mergeRequest, "mergeRequest").getMessage();
            this.dryRun = false;
        }

        @Nonnull
        public Builder abortOnFirstVeto(boolean value) {
            this.abortOnFirstVeto = value;
            return this;
        }

        @Nonnull
        public SimpleMergeRequest build() {
            return new SimpleMergeRequest(this);
        }

        @Nonnull
        public Builder dryRun(boolean value) {
            this.dryRun = value;
            return this;
        }

        @Nonnull
        public Builder message(@Nonnull String value) {
            this.message = value;
            return this;
        }
    }
}

