/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.pull.PullRequestMergeConfig;
import com.atlassian.bitbucket.pull.PullRequestMergeConfigType;
import com.atlassian.bitbucket.pull.PullRequestMergeStrategy;
import com.atlassian.stash.internal.merge.MergeConfigType;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SimplePullRequestMergeConfig
implements PullRequestMergeConfig {
    private final PullRequestCommitMessageTemplate commitMessageTemplate;
    private final int commitSummaries;
    private final PullRequestMergeStrategy defaultStrategy;
    private final Set<PullRequestMergeStrategy> strategies;
    private final PullRequestMergeConfigType type;

    private SimplePullRequestMergeConfig(Builder builder) {
        this.commitSummaries = builder.commitSummaries;
        this.commitMessageTemplate = builder.commitMessageTemplate;
        this.defaultStrategy = builder.defaultStrategy;
        this.strategies = builder.strategies.build();
        this.type = builder.type;
    }

    @Nonnull
    public Optional<PullRequestCommitMessageTemplate> getCommitMessageTemplate() {
        return Optional.ofNullable(this.commitMessageTemplate);
    }

    public int getCommitSummaries() {
        return this.commitSummaries;
    }

    @Nonnull
    public PullRequestMergeStrategy getDefaultStrategy() {
        return this.defaultStrategy;
    }

    @Nonnull
    public Set<PullRequestMergeStrategy> getStrategies() {
        return this.strategies;
    }

    @Nonnull
    public PullRequestMergeConfigType getType() {
        return this.type;
    }

    public static class Builder {
        private final ImmutableSet.Builder<PullRequestMergeStrategy> strategies = ImmutableSet.builder();
        private PullRequestCommitMessageTemplate commitMessageTemplate;
        private int commitSummaries = 20;
        private PullRequestMergeStrategy defaultStrategy;
        private PullRequestMergeConfigType type;

        @Nonnull
        public SimplePullRequestMergeConfig build() {
            return new SimplePullRequestMergeConfig(this);
        }

        @Nonnull
        public Builder commitMessageTemplate(@Nullable PullRequestCommitMessageTemplate value) {
            this.commitMessageTemplate = value;
            return this;
        }

        @Nonnull
        public Builder commitSummaries(int value) {
            this.commitSummaries = value;
            return this;
        }

        @Nonnull
        public Builder defaultStrategy(@Nonnull PullRequestMergeStrategy value) {
            this.defaultStrategy = Objects.requireNonNull(value, "defaultStrategy");
            return this;
        }

        @Nonnull
        public Builder strategies(@Nonnull Iterable<PullRequestMergeStrategy> values) {
            this.strategies.addAll(Objects.requireNonNull(values, "strategies"));
            return this;
        }

        @Nonnull
        public Builder type(@Nonnull MergeConfigType value) {
            return this.type(PullRequestMergeConfigType.valueOf((String)Objects.requireNonNull(value, "type").name()));
        }

        @Nonnull
        public Builder type(@Nonnull PullRequestMergeConfigType value) {
            this.type = Objects.requireNonNull(value, "type");
            return this;
        }
    }
}

