/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.automerge;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.Objects;

public class AutoMergeProcessingRequest {
    static final Comparator<AutoMergeProcessingRequest> COMPARATOR = Comparator.comparing(AutoMergeProcessingRequest::getReadyTime).thenComparing(AutoMergeProcessingRequest::getAutoMergeRequestId);
    private final int attempt;
    private final long autoMergeRequestId;
    private final Instant readyTime;
    private final int repositoryId;

    private AutoMergeProcessingRequest(Builder builder) {
        this.repositoryId = builder.repositoryId;
        this.autoMergeRequestId = builder.autoMergeRequestId;
        this.attempt = builder.attempt;
        this.readyTime = builder.readyTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoMergeProcessingRequest that = (AutoMergeProcessingRequest)o;
        return this.autoMergeRequestId == that.autoMergeRequestId && this.repositoryId == that.repositoryId;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public long getAutoMergeRequestId() {
        return this.autoMergeRequestId;
    }

    @Nonnull
    public Instant getReadyTime() {
        return this.readyTime;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public int hashCode() {
        return Objects.hash(this.autoMergeRequestId, this.repositoryId);
    }

    public boolean isReady() {
        return Instant.now().isAfter(this.readyTime);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("autoMergeRequestId", this.autoMergeRequestId).add("repositoryId", this.repositoryId).add("readyBy", (Object)this.readyTime).add("attempt", this.attempt).toString();
    }

    public static class Builder {
        private final long autoMergeRequestId;
        private final int repositoryId;
        private int attempt;
        private Instant readyTime;

        public Builder(int repositoryId, long autoMergeRequestId) {
            this.repositoryId = repositoryId;
            this.autoMergeRequestId = autoMergeRequestId;
            this.attempt = 1;
            this.readyTime = Instant.now();
        }

        public Builder(@Nonnull AutoMergeProcessingRequest autoMergeProcessingRequest) {
            Objects.requireNonNull(autoMergeProcessingRequest, "autoMergeProcessingRequest");
            this.repositoryId = autoMergeProcessingRequest.repositoryId;
            this.autoMergeRequestId = autoMergeProcessingRequest.autoMergeRequestId;
            this.attempt = autoMergeProcessingRequest.attempt;
            this.readyTime = autoMergeProcessingRequest.readyTime;
        }

        @Nonnull
        public Builder attempt(int value) {
            Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (Object)"value should be greater than 0");
            this.attempt = value;
            return this;
        }

        @Nonnull
        public AutoMergeProcessingRequest build() {
            return new AutoMergeProcessingRequest(this);
        }

        @Nonnull
        public Builder delay(@Nonnull Duration value) {
            this.readyTime = Instant.now().plus(Objects.requireNonNull(value, "value"));
            return this;
        }
    }
}

