/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.automerge;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.pull.automerge.AutoMergeProcessingRequest;
import com.atlassian.stash.internal.pull.automerge.AutoMergeStalePullRequestQueue;
import com.atlassian.stash.internal.pull.automerge.ExceptionHandlingAutoMergeProcessor;
import com.atlassian.stash.internal.pull.automerge.InternalAutoMergeService;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DefaultApplicationMode
public class AutoMergeQueuePoller
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AutoMergeQueuePoller.class);
    private final ExceptionHandlingAutoMergeProcessor autoMergeProcessor;
    private final Thread autoMergeQueueProcessor;
    private final InternalAutoMergeService autoMergeService;
    private final boolean featureEnabled;
    private final AutoMergeStalePullRequestQueue queue;
    private final SecurityService securityService;
    private boolean running;

    @Autowired
    public AutoMergeQueuePoller(ExceptionHandlingAutoMergeProcessor autoMergeProcessor, InternalAutoMergeService autoMergeService, FeatureManager featureManager, AutoMergeStalePullRequestQueue queue, SecurityService securityService) {
        this.autoMergeProcessor = autoMergeProcessor;
        this.autoMergeService = autoMergeService;
        this.queue = queue;
        this.securityService = securityService;
        this.featureEnabled = featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_AUTO_MERGE);
        this.autoMergeQueueProcessor = new Thread((Runnable)new AutoMergeQueueProcessor(), "auto-merge-queue-processor");
    }

    public void afterPropertiesSet() throws Exception {
        if (this.featureEnabled) {
            this.running = true;
            this.autoMergeQueueProcessor.start();
        }
    }

    public void destroy() {
        if (this.featureEnabled) {
            this.running = false;
            this.autoMergeQueueProcessor.interrupt();
        }
    }

    private class AutoMergeQueueProcessor
    implements Runnable {
        private AutoMergeQueueProcessor() {
        }

        @Override
        public void run() {
            while (AutoMergeQueuePoller.this.running) {
                try {
                    this.processNext();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception | StackOverflowError e) {
                    log.warn("Unhandled exception while processing auto-merge queue", e);
                }
            }
        }

        private void processNext() throws InterruptedException {
            AutoMergeProcessingRequest request = AutoMergeQueuePoller.this.queue.take();
            this.waitToBeReady(request);
            int repositoryId = request.getRepositoryId();
            AutoMergeQueuePoller.this.autoMergeService.performUsingLock(repositoryId, acquired -> {
                if (acquired.booleanValue()) {
                    return AutoMergeQueuePoller.this.securityService.withPermission(Permission.ADMIN, "Processing auto-merge request").call(() -> {
                        AutoMergeQueuePoller.this.autoMergeProcessor.tryAutoMerge(request);
                        return null;
                    });
                }
                log.debug("Lock could not be acquired for repository ID {}, adding request back to queue", (Object)repositoryId);
                AutoMergeQueuePoller.this.queue.offerRetryWithoutAttempt(request);
                return null;
            });
        }

        private void waitToBeReady(AutoMergeProcessingRequest request) throws InterruptedException {
            Instant now = Instant.now();
            if (!request.isReady()) {
                Thread.sleep(Duration.between(now, request.getReadyTime()).toMillis());
            }
        }
    }
}

