/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.automerge;

import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionProcessor;
import com.atlassian.bitbucket.settingsrestriction.RestrictionProcessingRequest;
import com.atlassian.stash.internal.pull.automerge.AutoMergeSettingsDao;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="autoMergeSettingsRestrictionProcessor")
public class AutoMergeSettingsRestrictionProcessor
implements ProjectSettingsRestrictionProcessor {
    private static final Logger log = LoggerFactory.getLogger(AutoMergeSettingsRestrictionProcessor.class);
    private final AutoMergeSettingsDao dao;

    @Autowired
    public AutoMergeSettingsRestrictionProcessor(AutoMergeSettingsDao dao) {
        this.dao = dao;
    }

    @Nonnull
    public String getFeatureKey() {
        return ProjectSettingsRestrictionKeys.AUTO_MERGE.getFeatureKey();
    }

    @Nonnull
    public String getNamespace() {
        return ProjectSettingsRestrictionKeys.AUTO_MERGE.getNamespace();
    }

    @Transactional
    public boolean process(@Nonnull RestrictionProcessingRequest processingRequest) {
        Objects.requireNonNull(processingRequest, "processingRequest");
        log.trace("Deleting auto-merge settings for request {}", (Object)processingRequest);
        if (processingRequest.getRepositories().isEmpty()) {
            log.trace("No repos to process for request {}", (Object)processingRequest);
            return true;
        }
        Set repositoryIds = (Set)processingRequest.getRepositories().stream().map(Repository::getId).collect(ImmutableSet.toImmutableSet());
        Project project = ((Repository)processingRequest.getRepositories().iterator().next()).getProject();
        try (Ticker ignored = Timers.timer((String)("AutoMergeSettingsRestrictionProcessor: Processing restrictions for " + repositoryIds.size() + " repositories")).start(new Object[]{project.getId()});){
            try {
                int totalSettingsDeleted = this.dao.deleteByRepositoryIds(repositoryIds);
                log.trace("Successfully deleted {} auto-merge settings for request {}", (Object)totalSettingsDeleted, (Object)processingRequest);
            }
            catch (Exception e) {
                log.error("Error while deleting auto-merge settings for request {}", (Object)processingRequest, (Object)e);
                boolean bl = false;
                if (ignored != null) {
                    ignored.close();
                }
                return bl;
            }
        }
        return true;
    }
}

