/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.automerge;

import com.atlassian.bitbucket.util.RetryBackoffUtils;
import com.atlassian.stash.internal.concurrent.SetPriorityBlockingQueue;
import com.atlassian.stash.internal.pull.automerge.AutoMergeProcessingRequest;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.stereotype.Component;

@Component
public class AutoMergeStalePullRequestQueue {
    private static final Logger log = LoggerFactory.getLogger(AutoMergeStalePullRequestQueue.class);
    private final int maxRetryAttempts;
    private final Duration maxRetryDelay;
    private final Duration minRetryDelay;
    private final SetPriorityBlockingQueue<AutoMergeProcessingRequest> queue;

    @Autowired
    public AutoMergeStalePullRequestQueue(@Value(value="${pullrequest.auto.merge.max.queue.size}") int maxQueueSize, @Value(value="${pullrequest.auto.merge.stale.retry.maxAttempts}") int maxRetryAttempts, @DurationUnit(value=ChronoUnit.SECONDS) @Value(value="${pullrequest.auto.merge.stale.retry.maxDelay}") Duration maxRetryDelay, @DurationUnit(value=ChronoUnit.SECONDS) @Value(value="${pullrequest.auto.merge.stale.retry.minDelay}") Duration minRetryDelay) {
        this.maxRetryAttempts = maxRetryAttempts;
        this.maxRetryDelay = maxRetryDelay;
        this.minRetryDelay = minRetryDelay;
        this.queue = new SetPriorityBlockingQueue<AutoMergeProcessingRequest>(maxQueueSize, AutoMergeProcessingRequest.COMPARATOR);
    }

    public boolean offer(@Nonnull AutoMergeProcessingRequest request) {
        Objects.requireNonNull(request, "request");
        boolean offered = this.queue.offer(request);
        if (offered) {
            log.trace("Added [{}] successfully to the queue", (Object)request);
        } else {
            log.warn("Auto-merge processing queue is full, could not add [{}]", (Object)request);
        }
        return offered;
    }

    public boolean offerRetry(@Nonnull AutoMergeProcessingRequest request) {
        Objects.requireNonNull(request, "request");
        int attempt = request.getAttempt();
        if (attempt <= this.maxRetryAttempts) {
            return this.offer(new AutoMergeProcessingRequest.Builder(request).delay(RetryBackoffUtils.calculateDelay((int)attempt, (Duration)this.minRetryDelay, (Duration)this.maxRetryDelay)).attempt(++attempt).build());
        }
        log.debug("[{}] has exhausted max retry attempts: {}, would not be added to the queue", (Object)request, (Object)this.maxRetryAttempts);
        return false;
    }

    public boolean offerRetryWithoutAttempt(@Nonnull AutoMergeProcessingRequest request) {
        Objects.requireNonNull(request, "request");
        return this.offer(new AutoMergeProcessingRequest.Builder(request).delay(RetryBackoffUtils.calculateDelay((int)(request.getAttempt() - 1), (Duration)this.minRetryDelay, (Duration)this.maxRetryDelay)).build());
    }

    public AutoMergeProcessingRequest take() throws InterruptedException {
        return this.queue.take();
    }
}

